/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.freebsd;

import oshi.hardware.Baseboard;
import oshi.hardware.Firmware;
import oshi.hardware.common.AbstractComputerSystem;
import oshi.hardware.platform.unix.freebsd.FreeBsdBaseboard;
import oshi.hardware.platform.unix.freebsd.FreeBsdFirmware;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;

final class FreeBsdComputerSystem
extends AbstractComputerSystem {
    private static final long serialVersionUID = 1L;

    FreeBsdComputerSystem() {
    }

    @Override
    public String getManufacturer() {
        if (this.manufacturer == null) {
            this.readDmiDecode();
        }
        return this.manufacturer;
    }

    @Override
    public String getModel() {
        if (this.model == null) {
            this.readDmiDecode();
        }
        return this.model;
    }

    @Override
    public String getSerialNumber() {
        if (this.serialNumber == null) {
            this.readDmiDecode();
        }
        return this.serialNumber;
    }

    @Override
    public Firmware getFirmware() {
        if (this.firmware == null) {
            this.firmware = new FreeBsdFirmware();
        }
        return this.firmware;
    }

    @Override
    public Baseboard getBaseboard() {
        if (this.baseboard == null) {
            this.baseboard = new FreeBsdBaseboard();
        }
        return this.baseboard;
    }

    private void readDmiDecode() {
        String manufacturerMarker = "Manufacturer:";
        String productNameMarker = "Product Name:";
        String serialNumMarker = "Serial Number:";
        for (String checkLine : ExecutingCommand.runNative("dmidecode -t system")) {
            String serialNumber;
            String productName;
            String manufacturer;
            if (checkLine.contains("Manufacturer:") && !(manufacturer = checkLine.split("Manufacturer:")[1].trim()).isEmpty()) {
                this.manufacturer = manufacturer;
            }
            if (checkLine.contains("Product Name:") && !(productName = checkLine.split("Product Name:")[1].trim()).isEmpty()) {
                this.model = productName;
            }
            if (!checkLine.contains("Serial Number:")) continue;
            this.serialNumber = serialNumber = checkLine.split("Serial Number:")[1].trim();
        }
        if (this.serialNumber == null || this.serialNumber.isEmpty()) {
            this.serialNumber = this.getSystemSerialNumber();
        }
    }

    private String getSystemSerialNumber() {
        String marker = "system.hardware.serial =";
        for (String checkLine : ExecutingCommand.runNative("lshal")) {
            if (!checkLine.contains(marker)) continue;
            return ParseUtil.getSingleQuoteStringValue(checkLine);
        }
        return "unknown";
    }
}

