/*
 * Decompiled with CFR 0.152.
 */
package oshi.driver.unix.freebsd;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.jna.platform.unix.freebsd.FreeBsdLibc;
import oshi.software.os.OSSession;

@ThreadSafe
public final class Who {
    private static final FreeBsdLibc LIBC = FreeBsdLibc.INSTANCE;

    private Who() {
    }

    public static synchronized List<OSSession> queryUtxent() {
        FreeBsdLibc.FreeBsdUtmpx ut;
        ArrayList<OSSession> whoList = new ArrayList<OSSession>();
        LIBC.setutxent();
        while ((ut = LIBC.getutxent()) != null) {
            if (ut.ut_type != 7 && ut.ut_type != 6) continue;
            String user = new String(ut.ut_user, StandardCharsets.US_ASCII).trim();
            String device = new String(ut.ut_line, StandardCharsets.US_ASCII).trim();
            String host = new String(ut.ut_host, StandardCharsets.US_ASCII).trim();
            long loginTime = ut.ut_tv.tv_sec * 1000L + ut.ut_tv.tv_usec / 1000L;
            whoList.add(new OSSession(user, device, loginTime, host));
        }
        LIBC.endutxent();
        return whoList;
    }
}

