/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import com.sun.jna.platform.win32.COM.WbemcliUtil;
import com.sun.jna.platform.win32.Cfgmgr32;
import com.sun.jna.platform.win32.Cfgmgr32Util;
import com.sun.jna.ptr.IntByReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.Immutable;
import oshi.driver.windows.wmi.Win32DiskDrive;
import oshi.driver.windows.wmi.Win32PnPEntity;
import oshi.driver.windows.wmi.Win32USBController;
import oshi.hardware.UsbDevice;
import oshi.hardware.common.AbstractUsbDevice;
import oshi.util.ParseUtil;
import oshi.util.platform.windows.WmiUtil;
import oshi.util.tuples.Pair;
import oshi.util.tuples.Triplet;

@Immutable
public class WindowsUsbDevice
extends AbstractUsbDevice {
    private static final Logger LOG = LoggerFactory.getLogger(WindowsUsbDevice.class);

    public WindowsUsbDevice(String name, String vendor, String vendorId, String productId, String serialNumber, String uniqueDeviceId, List<UsbDevice> connectedDevices) {
        super(name, vendor, vendorId, productId, serialNumber, uniqueDeviceId, connectedDevices);
    }

    public static List<UsbDevice> getUsbDevices(boolean tree) {
        List<UsbDevice> devices = WindowsUsbDevice.getUsbDevices();
        if (tree) {
            return devices;
        }
        ArrayList<UsbDevice> deviceList = new ArrayList<UsbDevice>();
        for (UsbDevice device : devices) {
            WindowsUsbDevice.addDevicesToList(deviceList, device.getConnectedDevices());
        }
        return deviceList;
    }

    private static List<UsbDevice> getUsbDevices() {
        HashMap<String, List<String>> deviceTreeMap = new HashMap<String, List<String>>();
        HashSet<String> devicesSeen = new HashSet<String>();
        ArrayList<UsbDevice> controllerDevices = new ArrayList<UsbDevice>();
        List<String> controllerDeviceIdList = WindowsUsbDevice.getControllerDeviceIdList();
        for (String controllerDeviceId : controllerDeviceIdList) {
            WindowsUsbDevice.putChildrenInDeviceTree(controllerDeviceId, 0, deviceTreeMap, devicesSeen);
        }
        Map<String, Triplet<String, String, String>> deviceStringMap = WindowsUsbDevice.queryDeviceStringsMap(devicesSeen);
        for (String controllerDeviceId : controllerDeviceIdList) {
            WindowsUsbDevice deviceAndChildren = WindowsUsbDevice.getDeviceAndChildren(controllerDeviceId, "0000", "0000", deviceTreeMap, deviceStringMap);
            if (deviceAndChildren == null) continue;
            controllerDevices.add(deviceAndChildren);
        }
        return controllerDevices;
    }

    private static void addDevicesToList(List<UsbDevice> deviceList, List<UsbDevice> list) {
        for (UsbDevice device : list) {
            deviceList.add(new WindowsUsbDevice(device.getName(), device.getVendor(), device.getVendorId(), device.getProductId(), device.getSerialNumber(), device.getUniqueDeviceId(), Collections.emptyList()));
            WindowsUsbDevice.addDevicesToList(deviceList, device.getConnectedDevices());
        }
    }

    private static Map<String, Triplet<String, String, String>> queryDeviceStringsMap(Set<String> devicesToAdd) {
        HashMap<String, Triplet<String, String, String>> deviceStringCache = new HashMap<String, Triplet<String, String, String>>();
        if (!devicesToAdd.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (String deviceID : devicesToAdd) {
                if (first) {
                    sb.append(" WHERE (PnPDeviceID=\"");
                    first = false;
                } else {
                    sb.append(" OR (PnPDeviceID=\"");
                }
                sb.append(deviceID).append("\")");
            }
            String whereClause = sb.toString();
            HashMap<String, String> pnpToSerialMap = new HashMap<String, String>();
            WbemcliUtil.WmiResult<Win32DiskDrive.DeviceIdProperty> serialNumbers = Win32DiskDrive.queryDiskDriveId(whereClause);
            for (int i = 0; i < serialNumbers.getResultCount(); ++i) {
                String pnpDeviceID = WmiUtil.getString(serialNumbers, Win32DiskDrive.DeviceIdProperty.PNPDEVICEID, i);
                if (!deviceStringCache.containsKey(pnpDeviceID)) continue;
                pnpToSerialMap.put(pnpDeviceID, ParseUtil.hexStringToString(WmiUtil.getString(serialNumbers, Win32DiskDrive.DeviceIdProperty.SERIALNUMBER, i)));
            }
            WbemcliUtil.WmiResult<Win32PnPEntity.PnPEntityProperty> pnpEntity = Win32PnPEntity.queryDeviceId(whereClause);
            for (int i = 0; i < pnpEntity.getResultCount(); ++i) {
                String pnpDeviceID = WmiUtil.getString(pnpEntity, Win32PnPEntity.PnPEntityProperty.PNPDEVICEID, i);
                String name = WmiUtil.getString(pnpEntity, Win32PnPEntity.PnPEntityProperty.NAME, i);
                String vendor = WmiUtil.getString(pnpEntity, Win32PnPEntity.PnPEntityProperty.MANUFACTURER, i);
                deviceStringCache.put(pnpDeviceID, new Triplet<String, String, String>(name, vendor, pnpToSerialMap.getOrDefault(pnpDeviceID, "")));
                LOG.debug("Adding {} to USB device cache.", (Object)pnpDeviceID);
            }
        }
        return deviceStringCache;
    }

    private static void putChildrenInDeviceTree(String deviceId, int deviceInstance, Map<String, List<String>> deviceTreeMap, Set<String> devicesSeen) {
        IntByReference child;
        devicesSeen.add(deviceId);
        int devInst = deviceInstance;
        if (devInst == 0) {
            IntByReference pdnDevInst = new IntByReference();
            Cfgmgr32.INSTANCE.CM_Locate_DevNode(pdnDevInst, deviceId, 0);
            devInst = pdnDevInst.getValue();
        }
        if (0 == Cfgmgr32.INSTANCE.CM_Get_Child(child = new IntByReference(), devInst, 0)) {
            ArrayList<String> childList = new ArrayList<String>();
            String childId = Cfgmgr32Util.CM_Get_Device_ID((int)child.getValue());
            childList.add(childId);
            deviceTreeMap.put(deviceId, childList);
            WindowsUsbDevice.putChildrenInDeviceTree(childId, child.getValue(), deviceTreeMap, devicesSeen);
            IntByReference sibling = new IntByReference();
            while (0 == Cfgmgr32.INSTANCE.CM_Get_Sibling(sibling, child.getValue(), 0)) {
                String siblingId = Cfgmgr32Util.CM_Get_Device_ID((int)sibling.getValue());
                deviceTreeMap.get(deviceId).add(siblingId);
                WindowsUsbDevice.putChildrenInDeviceTree(siblingId, sibling.getValue(), deviceTreeMap, devicesSeen);
                child = sibling;
            }
        }
    }

    private static WindowsUsbDevice getDeviceAndChildren(String hubDeviceId, String vid, String pid, Map<String, List<String>> deviceTreeMap, Map<String, Triplet<String, String, String>> deviceStringMap) {
        String vendorId = vid;
        String productId = pid;
        Pair<String, String> idPair = ParseUtil.parsePnPDeviceIdToVendorProductId(hubDeviceId);
        if (idPair != null) {
            vendorId = idPair.getA();
            productId = idPair.getB();
        }
        List pnpDeviceIds = deviceTreeMap.getOrDefault(hubDeviceId, new ArrayList());
        ArrayList<UsbDevice> usbDevices = new ArrayList<UsbDevice>();
        for (String pnpDeviceId : pnpDeviceIds) {
            WindowsUsbDevice deviceAndChildren = WindowsUsbDevice.getDeviceAndChildren(pnpDeviceId, vendorId, productId, deviceTreeMap, deviceStringMap);
            if (deviceAndChildren == null) continue;
            usbDevices.add(deviceAndChildren);
        }
        Collections.sort(usbDevices);
        if (deviceStringMap.containsKey(hubDeviceId)) {
            Triplet<String, String, String> device = deviceStringMap.get(hubDeviceId);
            String name = device.getA();
            if (name.isEmpty()) {
                name = vendorId + ":" + productId;
            }
            return new WindowsUsbDevice(name, device.getB(), vendorId, productId, device.getC(), hubDeviceId, usbDevices);
        }
        return null;
    }

    private static List<String> getControllerDeviceIdList() {
        ArrayList<String> controllerDeviceIdsList = new ArrayList<String>();
        WbemcliUtil.WmiResult<Win32USBController.USBControllerProperty> usbController = Win32USBController.queryUSBControllers();
        for (int i = 0; i < usbController.getResultCount(); ++i) {
            controllerDeviceIdsList.add(WmiUtil.getString(usbController, Win32USBController.USBControllerProperty.PNPDEVICEID, i));
        }
        return controllerDeviceIdsList;
    }
}

