/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.linux;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.Immutable;
import oshi.hardware.Display;
import oshi.hardware.common.AbstractDisplay;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;

@Immutable
final class LinuxDisplay
extends AbstractDisplay {
    private static final Logger LOG = LoggerFactory.getLogger(LinuxDisplay.class);

    LinuxDisplay(byte[] edid) {
        super(edid);
        LOG.debug("Initialized LinuxDisplay");
    }

    public static Display[] getDisplays() {
        List<String> xrandr = ExecutingCommand.runNative("xrandr --verbose");
        if (xrandr.isEmpty()) {
            return new Display[0];
        }
        ArrayList<LinuxDisplay> displays = new ArrayList<LinuxDisplay>();
        StringBuilder sb = null;
        for (String s : xrandr) {
            if (s.contains("EDID")) {
                sb = new StringBuilder();
                continue;
            }
            if (sb == null) continue;
            sb.append(s.trim());
            if (sb.length() < 256) continue;
            String edidStr = sb.toString();
            LOG.debug("Parsed EDID: {}", (Object)edidStr);
            byte[] edid = ParseUtil.hexStringToByteArray(edidStr);
            if (edid.length >= 128) {
                displays.add(new LinuxDisplay(edid));
            }
            sb = null;
        }
        return displays.toArray(new Display[0]);
    }
}

