/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.solaris;

import com.sun.jna.platform.unix.solaris.LibKstat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.PowerSource;
import oshi.hardware.common.AbstractPowerSource;
import oshi.util.platform.unix.solaris.KstatUtil;

public class SolarisPowerSource
extends AbstractPowerSource {
    private static final Logger LOG = LoggerFactory.getLogger(SolarisPowerSource.class);
    private static final String[] KSTAT_BATT_MOD = new String[]{null, "battery", "acpi_drv"};
    private static final int KSTAT_BATT_IDX;

    public SolarisPowerSource(String newName, double newRemainingCapacity, double newTimeRemaining) {
        super(newName, newRemainingCapacity, newTimeRemaining);
        LOG.debug("Initialized SolarisPowerSource");
    }

    public static PowerSource[] getPowerSources() {
        PowerSource[] ps = new SolarisPowerSource[]{SolarisPowerSource.getPowerSource("BAT0")};
        return ps;
    }

    private static SolarisPowerSource getPowerSource(String name) {
        long energyNow;
        long energyFull;
        if (KSTAT_BATT_IDX == 0) {
            return new SolarisPowerSource(name, 0.0, -1.0);
        }
        double timeRemaining = -2.0;
        try (KstatUtil.KstatChain kc = KstatUtil.openChain();){
            boolean isCharging;
            LibKstat.Kstat ksp = kc.lookup(KSTAT_BATT_MOD[KSTAT_BATT_IDX], 0, "battery BIF0");
            if (ksp == null) {
                SolarisPowerSource solarisPowerSource = new SolarisPowerSource(name, 0.0, -1.0);
                return solarisPowerSource;
            }
            energyFull = KstatUtil.dataLookupLong(ksp, "bif_last_cap");
            if (energyFull == -1L || energyFull <= 0L) {
                energyFull = KstatUtil.dataLookupLong(ksp, "bif_design_cap");
            }
            if (energyFull == -1L || energyFull <= 0L) {
                SolarisPowerSource solarisPowerSource = new SolarisPowerSource(name, 0.0, -1.0);
                return solarisPowerSource;
            }
            ksp = kc.lookup(KSTAT_BATT_MOD[KSTAT_BATT_IDX], 0, "battery BST0");
            if (ksp == null) {
                SolarisPowerSource solarisPowerSource = new SolarisPowerSource(name, 0.0, -1.0);
                return solarisPowerSource;
            }
            energyNow = KstatUtil.dataLookupLong(ksp, "bst_rem_cap");
            if (energyNow < 0L) {
                SolarisPowerSource solarisPowerSource = new SolarisPowerSource(name, 0.0, -1.0);
                return solarisPowerSource;
            }
            long powerNow = KstatUtil.dataLookupLong(ksp, "bst_rate");
            if (powerNow == -1L) {
                powerNow = 0L;
            }
            boolean bl = isCharging = (KstatUtil.dataLookupLong(ksp, "bst_state") & 0x10L) > 0L;
            if (!isCharging) {
                timeRemaining = powerNow > 0L ? 3600.0 * (double)energyNow / (double)powerNow : -1.0;
            }
        }
        return new SolarisPowerSource(name, (double)energyNow / (double)energyFull, timeRemaining);
    }

    @Override
    public void updateAttributes() {
        SolarisPowerSource ps = SolarisPowerSource.getPowerSource(this.name);
        this.remainingCapacity = ps.getRemainingCapacity();
        this.timeRemaining = ps.getTimeRemaining();
    }

    static {
        try (KstatUtil.KstatChain kc = KstatUtil.openChain();){
            KSTAT_BATT_IDX = kc.lookup(KSTAT_BATT_MOD[1], 0, null) != null ? 1 : (kc.lookup(KSTAT_BATT_MOD[2], 0, null) != null ? 2 : 0);
        }
    }
}

