/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.mac;

import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;
import oshi.hardware.Baseboard;
import oshi.hardware.Firmware;
import oshi.hardware.common.AbstractComputerSystem;
import oshi.hardware.platform.mac.MacBaseboard;
import oshi.hardware.platform.mac.MacFirmware;
import oshi.jna.platform.mac.IOKit;
import oshi.jna.platform.mac.IOKitUtil;
import oshi.util.Memoizer;
import oshi.util.Util;

final class MacComputerSystem
extends AbstractComputerSystem {
    private final Supplier<ManufacturerModelSerial> profileSystem = Memoizer.memoize(this::platformExpert);

    MacComputerSystem() {
    }

    @Override
    public String getManufacturer() {
        return this.profileSystem.get().manufacturer;
    }

    @Override
    public String getModel() {
        return this.profileSystem.get().model;
    }

    @Override
    public String getSerialNumber() {
        return this.profileSystem.get().serialNumber;
    }

    @Override
    public Firmware createFirmware() {
        return new MacFirmware();
    }

    @Override
    public Baseboard createBaseboard() {
        return new MacBaseboard();
    }

    private ManufacturerModelSerial platformExpert() {
        String manufacturer = null;
        String model = null;
        String serialNumber = null;
        IOKit.IOService platformExpert = IOKitUtil.getMatchingService("IOPlatformExpertDevice");
        if (platformExpert != null) {
            byte[] data = platformExpert.getByteArrayProperty("manufacturer");
            if (data != null) {
                manufacturer = new String(data, StandardCharsets.UTF_8);
            }
            if ((data = platformExpert.getByteArrayProperty("model")) != null) {
                model = new String(data, StandardCharsets.UTF_8);
            }
            serialNumber = platformExpert.getStringProperty("IOPlatformSerialNumber");
            platformExpert.release();
        }
        return new ManufacturerModelSerial(manufacturer, model, serialNumber);
    }

    private static final class ManufacturerModelSerial {
        private final String manufacturer;
        private final String model;
        private final String serialNumber;

        private ManufacturerModelSerial(String manufacturer, String model, String serialNumber) {
            this.manufacturer = Util.isBlank(manufacturer) ? "Apple Inc." : manufacturer;
            this.model = Util.isBlank(model) ? "unknown" : model;
            this.serialNumber = Util.isBlank(serialNumber) ? "unknown" : serialNumber;
        }
    }
}

