/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.mac;

import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;
import oshi.hardware.common.AbstractBaseboard;
import oshi.jna.platform.mac.IOKit;
import oshi.jna.platform.mac.IOKitUtil;
import oshi.util.Memoizer;
import oshi.util.Util;

final class MacBaseboard
extends AbstractBaseboard {
    private final Supplier<PlatformStrings> platform = Memoizer.memoize(this::queryPlatform);

    MacBaseboard() {
    }

    @Override
    public String getManufacturer() {
        return this.platform.get().manufacturer;
    }

    @Override
    public String getModel() {
        return this.platform.get().model;
    }

    @Override
    public String getVersion() {
        return this.platform.get().version;
    }

    @Override
    public String getSerialNumber() {
        return this.platform.get().serialNumber;
    }

    private PlatformStrings queryPlatform() {
        String manufacturer = null;
        String model = null;
        String version = null;
        String serialNumber = null;
        IOKit.IOService platformExpert = IOKitUtil.getMatchingService("IOPlatformExpertDevice");
        if (platformExpert != null) {
            byte[] data = platformExpert.getByteArrayProperty("manufacturer");
            if (data != null) {
                manufacturer = new String(data, StandardCharsets.UTF_8);
            }
            if ((data = platformExpert.getByteArrayProperty("board-id")) != null) {
                model = new String(data, StandardCharsets.UTF_8);
            }
            if ((data = platformExpert.getByteArrayProperty("version")) != null) {
                version = new String(data, StandardCharsets.UTF_8);
            }
            serialNumber = platformExpert.getStringProperty("IOPlatformSerialNumber");
            platformExpert.release();
        }
        return new PlatformStrings(manufacturer, model, version, serialNumber);
    }

    private static final class PlatformStrings {
        private final String manufacturer;
        private final String model;
        private final String version;
        private final String serialNumber;

        private PlatformStrings(String manufacturer, String model, String version, String serialNumber) {
            this.manufacturer = Util.isBlank(manufacturer) ? "Apple Inc." : manufacturer;
            this.model = Util.isBlank(model) ? "unknown" : model;
            this.version = Util.isBlank(version) ? "unknown" : version;
            this.serialNumber = Util.isBlank(serialNumber) ? "unknown" : serialNumber;
        }
    }
}

