/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.mac;

import com.sun.jna.Pointer;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.PowerSource;
import oshi.hardware.common.AbstractPowerSource;
import oshi.jna.platform.mac.CoreFoundation;
import oshi.jna.platform.mac.IOKit;

public class MacPowerSource
extends AbstractPowerSource {
    private static final Logger LOG = LoggerFactory.getLogger(MacPowerSource.class);
    private static final CoreFoundation CF = CoreFoundation.INSTANCE;
    private static final IOKit IO = IOKit.INSTANCE;

    public MacPowerSource(String newName, double newRemainingCapacity, double newTimeRemaining) {
        super(newName, newRemainingCapacity, newTimeRemaining);
        LOG.debug("Initialized MacPowerSource");
    }

    public static PowerSource[] getPowerSources() {
        CoreFoundation.CFTypeRef powerSourcesInfo = IO.IOPSCopyPowerSourcesInfo();
        CoreFoundation.CFArrayRef powerSourcesList = IO.IOPSCopyPowerSourcesList(powerSourcesInfo);
        int powerSourcesCount = powerSourcesList.getCount();
        double timeRemaining = IO.IOPSGetTimeRemainingEstimate();
        CoreFoundation.CFStringRef nameKey = CoreFoundation.CFStringRef.createCFString("Name");
        CoreFoundation.CFStringRef isPresentKey = CoreFoundation.CFStringRef.createCFString("Is Present");
        CoreFoundation.CFStringRef currentCapacityKey = CoreFoundation.CFStringRef.createCFString("Current Capacity");
        CoreFoundation.CFStringRef maxCapacityKey = CoreFoundation.CFStringRef.createCFString("Max Capacity");
        ArrayList<MacPowerSource> psList = new ArrayList<MacPowerSource>(powerSourcesCount);
        for (int ps = 0; ps < powerSourcesCount; ++ps) {
            CoreFoundation.CFBooleanRef isPresentRef;
            Pointer pwrSrcPtr = powerSourcesList.getValueAtIndex(ps);
            CoreFoundation.CFTypeRef powerSource = new CoreFoundation.CFTypeRef();
            powerSource.setPointer(pwrSrcPtr);
            CoreFoundation.CFDictionaryRef dictionary = IO.IOPSGetPowerSourceDescription(powerSourcesInfo, powerSource);
            Pointer result = dictionary.getValue(isPresentKey);
            if (result == null || 0 == CF.CFBooleanGetValue(isPresentRef = new CoreFoundation.CFBooleanRef(result))) continue;
            result = dictionary.getValue(nameKey);
            CoreFoundation.CFStringRef cfName = new CoreFoundation.CFStringRef(result);
            String name = cfName.stringValue();
            if (name == null) {
                name = "unknown";
            }
            int currentCapacity = 0;
            if (dictionary.getValueIfPresent(currentCapacityKey, null)) {
                result = dictionary.getValue(currentCapacityKey);
                CoreFoundation.CFNumberRef cap = new CoreFoundation.CFNumberRef(result);
                currentCapacity = cap.intValue();
            }
            int maxCapacity = 100;
            if (dictionary.getValueIfPresent(maxCapacityKey, null)) {
                result = dictionary.getValue(maxCapacityKey);
                CoreFoundation.CFNumberRef cap = new CoreFoundation.CFNumberRef(result);
                maxCapacity = cap.intValue();
            }
            psList.add(new MacPowerSource(name, (double)currentCapacity / (double)maxCapacity, timeRemaining));
        }
        isPresentKey.release();
        nameKey.release();
        currentCapacityKey.release();
        maxCapacityKey.release();
        powerSourcesList.release();
        powerSourcesInfo.release();
        return psList.toArray(new MacPowerSource[0]);
    }

    @Override
    public void updateAttributes() {
        PowerSource[] psArr;
        for (PowerSource ps : psArr = MacPowerSource.getPowerSources()) {
            if (!ps.getName().equals(this.name)) continue;
            this.remainingCapacity = ps.getRemainingCapacity();
            this.timeRemaining = ps.getTimeRemaining();
            return;
        }
        this.remainingCapacity = 0.0;
        this.timeRemaining = -1.0;
    }
}

