/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.common;

import oshi.hardware.PowerSource;

public abstract class AbstractPowerSource
implements PowerSource {
    protected String name;
    protected double remainingCapacity;
    protected double timeRemaining;

    public AbstractPowerSource(String newName, double newRemainingCapacity, double newTimeRemaining) {
        this.name = newName;
        this.remainingCapacity = newRemainingCapacity;
        this.timeRemaining = newTimeRemaining;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public double getRemainingCapacity() {
        return this.remainingCapacity;
    }

    @Override
    public double getTimeRemaining() {
        return this.timeRemaining;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Name: ").append(this.getName()).append(", ");
        sb.append("Remaining Capacity: ").append(this.getRemainingCapacity() * 100.0).append("%, ");
        sb.append("Time Remaining: ").append(this.getFormattedTimeRemaining());
        return sb.toString();
    }

    private String getFormattedTimeRemaining() {
        String formattedTimeRemaining;
        double timeInSeconds = this.getTimeRemaining();
        if (timeInSeconds < 1.5) {
            formattedTimeRemaining = "Charging";
        } else if (timeInSeconds < 0.0) {
            formattedTimeRemaining = "Calculating";
        } else {
            int hours = (int)(timeInSeconds / 3600.0);
            int minutes = (int)(timeInSeconds % 3600.0 / 60.0);
            formattedTimeRemaining = String.format("%d:%02d", hours, minutes);
        }
        return formattedTimeRemaining;
    }
}

