/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.common;

import java.util.ArrayList;
import java.util.List;
import oshi.hardware.GlobalMemory;
import oshi.hardware.PhysicalMemory;
import oshi.util.ExecutingCommand;
import oshi.util.FormatUtil;
import oshi.util.ParseUtil;

public abstract class AbstractGlobalMemory
implements GlobalMemory {
    @Override
    public PhysicalMemory[] getPhysicalMemory() {
        ArrayList<PhysicalMemory> pmList = new ArrayList<PhysicalMemory>();
        List<String> dmi = ExecutingCommand.runNative("dmidecode --type 17");
        int bank = 0;
        String bankLabel = "unknown";
        String locator = "";
        long capacity = 0L;
        long speed = 0L;
        String manufacturer = "unknown";
        String memoryType = "unknown";
        for (String line : dmi) {
            String[] split;
            if (line.trim().contains("DMI type 17")) {
                if (bank++ <= 0) continue;
                if (capacity > 0L) {
                    pmList.add(new PhysicalMemory(bankLabel + locator, capacity, speed, manufacturer, memoryType));
                }
                bankLabel = "unknown";
                locator = "";
                capacity = 0L;
                speed = 0L;
                continue;
            }
            if (bank <= 0 || (split = line.trim().split(":")).length != 2) continue;
            switch (split[0]) {
                case "Bank Locator": {
                    bankLabel = split[1].trim();
                    break;
                }
                case "Locator": {
                    locator = "/" + split[1].trim();
                    break;
                }
                case "Size": {
                    capacity = this.parsePhysicalMemorySize(split[1].trim());
                    break;
                }
                case "Type": {
                    memoryType = split[1].trim();
                    break;
                }
                case "Speed": {
                    speed = ParseUtil.parseHertz(split[1]);
                    break;
                }
                case "Manufacturer": {
                    manufacturer = split[1].trim();
                    break;
                }
            }
        }
        if (capacity > 0L) {
            pmList.add(new PhysicalMemory(bankLabel + locator, capacity, speed, manufacturer, memoryType));
        }
        return pmList.toArray(new PhysicalMemory[0]);
    }

    protected long parsePhysicalMemorySize(String size) {
        String[] mem = ParseUtil.whitespaces.split(size);
        long capacity = ParseUtil.parseLongOrDefault(mem[0], 0L);
        if (mem.length == 2 && mem[1].length() > 1) {
            switch (mem[1].charAt(0)) {
                case 'T': {
                    capacity <<= 40;
                    break;
                }
                case 'G': {
                    capacity <<= 30;
                    break;
                }
                case 'M': {
                    capacity <<= 20;
                    break;
                }
                case 'K': 
                case 'k': {
                    capacity <<= 10;
                    break;
                }
            }
        }
        return capacity;
    }

    protected static String smBiosMemoryType(int type) {
        switch (type) {
            case 1: {
                return "Other";
            }
            case 3: {
                return "DRAM";
            }
            case 4: {
                return "EDRAM";
            }
            case 5: {
                return "VRAM";
            }
            case 6: {
                return "SRAM";
            }
            case 7: {
                return "RAM";
            }
            case 8: {
                return "ROM";
            }
            case 9: {
                return "FLASH";
            }
            case 10: {
                return "EEPROM";
            }
            case 11: {
                return "FEPROM";
            }
            case 12: {
                return "EPROM";
            }
            case 13: {
                return "CDRAM";
            }
            case 14: {
                return "3DRAM";
            }
            case 15: {
                return "SDRAM";
            }
            case 16: {
                return "SGRAM";
            }
            case 17: {
                return "RDRAM";
            }
            case 18: {
                return "DDR";
            }
            case 19: {
                return "DDR2";
            }
            case 20: {
                return "DDR2 FB-DIMM";
            }
            case 24: {
                return "DDR3";
            }
            case 25: {
                return "FBD2";
            }
            case 26: {
                return "DDR4";
            }
            case 27: {
                return "LPDDR";
            }
            case 28: {
                return "LPDDR2";
            }
            case 29: {
                return "LPDDR3";
            }
            case 30: {
                return "LPDDR4";
            }
            case 31: {
                return "Logical non-volatile device";
            }
        }
        return "Unknown";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Available: ");
        sb.append(FormatUtil.formatBytes(this.getAvailable()));
        sb.append("/");
        sb.append(FormatUtil.formatBytes(this.getTotal()));
        return sb.toString();
    }
}

