/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import com.sun.jna.platform.win32.COM.WbemcliUtil;
import oshi.hardware.common.AbstractBaseboard;
import oshi.util.platform.windows.WmiQueryHandler;
import oshi.util.platform.windows.WmiUtil;

final class WindowsBaseboard
extends AbstractBaseboard {
    private static final long serialVersionUID = 1L;

    WindowsBaseboard() {
    }

    @Override
    public String getManufacturer() {
        if (this.manufacturer == null) {
            this.queryWmi();
        }
        return super.getManufacturer();
    }

    @Override
    public String getModel() {
        if (this.model == null) {
            this.queryWmi();
        }
        return super.getModel();
    }

    @Override
    public String getVersion() {
        if (this.version == null) {
            this.queryWmi();
        }
        return super.getVersion();
    }

    @Override
    public String getSerialNumber() {
        if (this.serialNumber == null) {
            this.queryWmi();
        }
        return super.getSerialNumber();
    }

    private void queryWmi() {
        WbemcliUtil.WmiQuery baseboardQuery = new WbemcliUtil.WmiQuery("Win32_BaseBoard", BaseboardProperty.class);
        WbemcliUtil.WmiResult win32BaseBoard = WmiQueryHandler.createInstance().queryWMI(baseboardQuery);
        if (win32BaseBoard.getResultCount() > 0) {
            this.manufacturer = WmiUtil.getString(win32BaseBoard, BaseboardProperty.MANUFACTURER, 0);
            this.model = WmiUtil.getString(win32BaseBoard, BaseboardProperty.MODEL, 0);
            this.version = WmiUtil.getString(win32BaseBoard, BaseboardProperty.VERSION, 0);
            this.serialNumber = WmiUtil.getString(win32BaseBoard, BaseboardProperty.SERIALNUMBER, 0);
        }
    }

    static enum BaseboardProperty {
        MANUFACTURER,
        MODEL,
        VERSION,
        SERIALNUMBER;

    }
}

