/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.freebsd;

import oshi.hardware.VirtualMemory;
import oshi.hardware.common.AbstractGlobalMemory;
import oshi.hardware.platform.unix.freebsd.FreeBsdVirtualMemory;
import oshi.util.platform.unix.freebsd.BsdSysctlUtil;

public class FreeBsdGlobalMemory
extends AbstractGlobalMemory {
    private static final long serialVersionUID = 1L;

    @Override
    public long getAvailable() {
        long inactive = BsdSysctlUtil.sysctl("vm.stats.vm.v_inactive_count", 0L);
        long cache = BsdSysctlUtil.sysctl("vm.stats.vm.v_cache_count", 0L);
        long free = BsdSysctlUtil.sysctl("vm.stats.vm.v_free_count", 0L);
        this.memAvailable = (inactive + cache + free) * this.getPageSize();
        return this.memAvailable;
    }

    @Override
    public long getTotal() {
        if (this.memTotal < 0L) {
            this.memTotal = BsdSysctlUtil.sysctl("hw.physmem", 0L);
        }
        return this.memTotal;
    }

    @Override
    public long getPageSize() {
        if (this.pageSize < 0L) {
            this.pageSize = BsdSysctlUtil.sysctl("hw.pagesize", 4096L);
        }
        return this.pageSize;
    }

    @Override
    public VirtualMemory getVirtualMemory() {
        if (this.virtualMemory == null) {
            this.virtualMemory = new FreeBsdVirtualMemory();
        }
        return this.virtualMemory;
    }
}

