/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.linux;

import java.util.List;
import oshi.hardware.common.AbstractBaseboard;
import oshi.util.FileUtil;
import oshi.util.ParseUtil;
import oshi.util.platform.linux.ProcUtil;

final class LinuxBaseboard
extends AbstractBaseboard {
    private static final long serialVersionUID = 1L;

    LinuxBaseboard() {
    }

    @Override
    public String getManufacturer() {
        if (this.manufacturer == null && !this.queryManufacturerFromSysfs() && !this.queryProcCpuinfo()) {
            this.manufacturer = "unknown";
        }
        return super.getManufacturer();
    }

    @Override
    public String getModel() {
        if (this.model == null && !this.queryModelFromSysfs() && !this.queryProcCpuinfo()) {
            this.model = "unknown";
        }
        return super.getModel();
    }

    @Override
    public String getVersion() {
        if (this.version == null && !this.queryVersionFromSysfs() && !this.queryProcCpuinfo()) {
            this.version = "unknown";
        }
        return super.getVersion();
    }

    @Override
    public String getSerialNumber() {
        if (this.serialNumber == null && !this.querySerialNumberFromSysfs() && !this.queryProcCpuinfo()) {
            this.serialNumber = "unknown";
        }
        return super.getSerialNumber();
    }

    private boolean queryManufacturerFromSysfs() {
        String boardVendor = FileUtil.getStringFromFile("/sys/devices/virtual/dmi/id/board_vendor").trim();
        if (!boardVendor.isEmpty()) {
            this.manufacturer = boardVendor;
            return true;
        }
        return false;
    }

    private boolean queryModelFromSysfs() {
        String boardName = FileUtil.getStringFromFile("/sys/devices/virtual/dmi/id/board_name").trim();
        if (!boardName.isEmpty()) {
            this.model = boardName;
            return true;
        }
        return false;
    }

    private boolean queryVersionFromSysfs() {
        String boardVersion = FileUtil.getStringFromFile("/sys/devices/virtual/dmi/id/board_version").trim();
        if (!boardVersion.isEmpty()) {
            this.version = boardVersion;
            return true;
        }
        return false;
    }

    private boolean querySerialNumberFromSysfs() {
        String boardSerialNumber = FileUtil.getStringFromFile("/sys/devices/virtual/dmi/id/board_serial").trim();
        if (!boardSerialNumber.isEmpty()) {
            this.serialNumber = boardSerialNumber;
            return true;
        }
        return false;
    }

    private boolean queryProcCpuinfo() {
        List<String> cpuInfo = FileUtil.readFile(ProcUtil.getProcPath() + "/cpuinfo");
        for (String line : cpuInfo) {
            String[] splitLine = ParseUtil.whitespacesColonWhitespace.split(line);
            if (splitLine.length < 2) continue;
            switch (splitLine[0]) {
                case "Hardware": {
                    this.model = splitLine[1];
                    break;
                }
                case "Revision": {
                    this.version = splitLine[1];
                    if (this.version.length() <= 1) break;
                    this.manufacturer = this.queryBoardManufacturer(this.version.charAt(1));
                    break;
                }
                case "Serial": {
                    this.serialNumber = splitLine[1];
                    break;
                }
            }
            if (this.model == null || this.version == null || this.serialNumber == null) continue;
            return true;
        }
        return false;
    }

    private String queryBoardManufacturer(char digit) {
        switch (digit) {
            case '0': {
                return "Sony UK";
            }
            case '1': {
                return "Egoman";
            }
            case '2': {
                return "Embest";
            }
            case '3': {
                return "Sony Japan";
            }
            case '4': {
                return "Embest";
            }
            case '5': {
                return "Stadium";
            }
        }
        return "unknown";
    }
}

