/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.unix.solaris;

import com.sun.jna.platform.unix.solaris.LibKstat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oshi.jna.platform.linux.Libc;
import oshi.software.common.AbstractOperatingSystem;
import oshi.software.os.FileSystem;
import oshi.software.os.NetworkParams;
import oshi.software.os.OSProcess;
import oshi.software.os.OperatingSystem;
import oshi.software.os.unix.solaris.SolarisFileSystem;
import oshi.software.os.unix.solaris.SolarisNetworkParams;
import oshi.software.os.unix.solaris.SolarisOSVersionInfoEx;
import oshi.util.ExecutingCommand;
import oshi.util.LsofUtil;
import oshi.util.ParseUtil;
import oshi.util.platform.linux.ProcUtil;
import oshi.util.platform.unix.solaris.KstatUtil;

public class SolarisOperatingSystem
extends AbstractOperatingSystem {
    private static final long serialVersionUID = 1L;
    private static final long BOOTTIME;

    public SolarisOperatingSystem() {
        this.manufacturer = "Oracle";
        this.family = "SunOS";
        this.version = new SolarisOSVersionInfoEx();
        this.initBitness();
    }

    private void initBitness() {
        if (this.bitness < 64) {
            this.bitness = ParseUtil.parseIntOrDefault(ExecutingCommand.getFirstAnswer("isainfo -b"), 32);
        }
    }

    @Override
    public FileSystem getFileSystem() {
        return new SolarisFileSystem();
    }

    @Override
    public OSProcess[] getProcesses(int limit, OperatingSystem.ProcessSort sort, boolean slowFields) {
        List<OSProcess> procs = this.getProcessListFromPS("ps -eo s,pid,ppid,user,uid,group,gid,nlwp,pri,vsz,rss,etime,time,comm,args", -1, slowFields);
        List<OSProcess> sorted = this.processSort(procs, limit, sort);
        return sorted.toArray(new OSProcess[0]);
    }

    @Override
    public OSProcess getProcess(int pid) {
        return this.getProcess(pid, true);
    }

    private OSProcess getProcess(int pid, boolean slowFields) {
        List<OSProcess> procs = this.getProcessListFromPS("ps -o s,pid,ppid,user,uid,group,gid,nlwp,pri,vsz,rss,etime,time,comm,args -p ", pid, slowFields);
        if (procs.isEmpty()) {
            return null;
        }
        return procs.get(0);
    }

    @Override
    public OSProcess[] getChildProcesses(int parentPid, int limit, OperatingSystem.ProcessSort sort) {
        List<OSProcess> procs = this.getProcessListFromPS("ps -eo s,pid,ppid,user,uid,group,gid,nlwp,pri,vsz,rss,etime,time,comm,args --ppid", parentPid, true);
        List<OSProcess> sorted = this.processSort(procs, limit, sort);
        return sorted.toArray(new OSProcess[0]);
    }

    private List<OSProcess> getProcessListFromPS(String psCommand, int pid, boolean slowFields) {
        Map<Integer, String> cwdMap = LsofUtil.getCwdMap(pid);
        ArrayList<OSProcess> procs = new ArrayList<OSProcess>();
        List<String> procList = ExecutingCommand.runNative(psCommand + (pid < 0 ? "" : Integer.valueOf(pid)));
        if (procList.isEmpty() || procList.size() < 2) {
            return procs;
        }
        procList.remove(0);
        for (String proc : procList) {
            String[] split = ParseUtil.whitespaces.split(proc.trim(), 15);
            if (split.length < 15) continue;
            long now = System.currentTimeMillis();
            OSProcess sproc = new OSProcess();
            switch (split[0].charAt(0)) {
                case 'O': {
                    sproc.setState(OSProcess.State.RUNNING);
                    break;
                }
                case 'S': {
                    sproc.setState(OSProcess.State.SLEEPING);
                    break;
                }
                case 'R': 
                case 'W': {
                    sproc.setState(OSProcess.State.WAITING);
                    break;
                }
                case 'Z': {
                    sproc.setState(OSProcess.State.ZOMBIE);
                    break;
                }
                case 'T': {
                    sproc.setState(OSProcess.State.STOPPED);
                    break;
                }
                default: {
                    sproc.setState(OSProcess.State.OTHER);
                }
            }
            sproc.setProcessID(ParseUtil.parseIntOrDefault(split[1], 0));
            sproc.setParentProcessID(ParseUtil.parseIntOrDefault(split[2], 0));
            sproc.setUser(split[3]);
            sproc.setUserID(split[4]);
            sproc.setGroup(split[5]);
            sproc.setGroupID(split[6]);
            sproc.setThreadCount(ParseUtil.parseIntOrDefault(split[7], 0));
            sproc.setPriority(ParseUtil.parseIntOrDefault(split[8], 0));
            sproc.setVirtualSize(ParseUtil.parseLongOrDefault(split[9], 0L) * 1024L);
            sproc.setResidentSetSize(ParseUtil.parseLongOrDefault(split[10], 0L) * 1024L);
            long elapsedTime = ParseUtil.parseDHMSOrDefault(split[11], 0L);
            sproc.setUpTime(elapsedTime < 1L ? 1L : elapsedTime);
            sproc.setStartTime(now - sproc.getUpTime());
            sproc.setUserTime(ParseUtil.parseDHMSOrDefault(split[12], 0L));
            sproc.setPath(split[13]);
            sproc.setName(sproc.getPath().substring(sproc.getPath().lastIndexOf(47) + 1));
            sproc.setCommandLine(split[14]);
            sproc.setCurrentWorkingDirectory(cwdMap.getOrDefault(sproc.getProcessID(), ""));
            if (slowFields) {
                List<String> openFilesList = ExecutingCommand.runNative(String.format("lsof -p %d", pid));
                sproc.setOpenFiles((long)openFilesList.size() - 1L);
                List<String> pflags = ExecutingCommand.runNative("pflags " + pid);
                for (String line : pflags) {
                    if (!line.contains("data model")) continue;
                    if (line.contains("LP32")) {
                        sproc.setBitness(32);
                        break;
                    }
                    if (!line.contains("LP64")) break;
                    sproc.setBitness(64);
                    break;
                }
            }
            procs.add(sproc);
        }
        return procs;
    }

    @Override
    public int getProcessId() {
        return Libc.INSTANCE.getpid();
    }

    @Override
    public int getProcessCount() {
        return ProcUtil.getPidFiles().length;
    }

    @Override
    public int getThreadCount() {
        List<String> threadList = ExecutingCommand.runNative("ps -eLo pid");
        if (!threadList.isEmpty()) {
            return threadList.size() - 1;
        }
        return this.getProcessCount();
    }

    @Override
    public long getSystemUptime() {
        return SolarisOperatingSystem.querySystemUptime();
    }

    private static long querySystemUptime() {
        LibKstat.Kstat ksp = KstatUtil.kstatLookup("unix", 0, "system_misc");
        if (ksp == null) {
            return 0L;
        }
        return ksp.ks_snaptime / 1000000000L;
    }

    @Override
    public long getSystemBootTime() {
        return BOOTTIME;
    }

    @Override
    public NetworkParams getNetworkParams() {
        return new SolarisNetworkParams();
    }

    static {
        LibKstat.Kstat ksp = KstatUtil.kstatLookup("unix", 0, "system_misc");
        BOOTTIME = ksp != null && KstatUtil.kstatRead(ksp) ? KstatUtil.kstatDataLookupLong(ksp, "boot_time") : System.currentTimeMillis() / 1000L - SolarisOperatingSystem.querySystemUptime();
    }
}

