/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.mac;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.platform.mac.SystemB;
import com.sun.jna.ptr.IntByReference;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.software.common.AbstractOperatingSystem;
import oshi.software.os.FileSystem;
import oshi.software.os.NetworkParams;
import oshi.software.os.OSProcess;
import oshi.software.os.OperatingSystem;
import oshi.software.os.mac.MacFileSystem;
import oshi.software.os.mac.MacNetworkParams;
import oshi.software.os.mac.MacOSVersionInfoEx;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;
import oshi.util.platform.mac.SysctlUtil;

public class MacOperatingSystem
extends AbstractOperatingSystem {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(MacOperatingSystem.class);
    private int maxProc = 1024;
    int P_LP64 = 4;
    private static final int SSLEEP = 1;
    private static final int SWAIT = 2;
    private static final int SRUN = 3;
    private static final int SIDL = 4;
    private static final int SZOMB = 5;
    private static final int SSTOP = 6;
    private static final long BOOTTIME;

    public MacOperatingSystem() {
        this.manufacturer = "Apple";
        this.version = new MacOSVersionInfoEx();
        this.family = ParseUtil.getFirstIntValue(this.version.getVersion()) == 10 && ParseUtil.getNthIntValue(this.version.getVersion(), 2) >= 12 ? "macOS" : System.getProperty("os.name");
        this.maxProc = SysctlUtil.sysctl("kern.maxproc", 4096);
        this.initBitness();
    }

    private void initBitness() {
        if (this.bitness < 64) {
            this.bitness = this.getVersion().getOsxVersionNumber() > 7 ? 64 : ParseUtil.parseIntOrDefault(ExecutingCommand.getFirstAnswer("getconf LONG_BIT"), 32);
        }
    }

    @Override
    public FileSystem getFileSystem() {
        return new MacFileSystem();
    }

    @Override
    public OSProcess[] getProcesses(int limit, OperatingSystem.ProcessSort sort, boolean slowFields) {
        ArrayList<OSProcess> procs = new ArrayList<OSProcess>();
        int[] pids = new int[this.maxProc];
        int numberOfProcesses = SystemB.INSTANCE.proc_listpids(1, 0, pids, pids.length * SystemB.INT_SIZE) / SystemB.INT_SIZE;
        for (int i = 0; i < numberOfProcesses; ++i) {
            OSProcess proc;
            if (pids[i] == 0 || (proc = this.getProcess(pids[i], slowFields)) == null) continue;
            procs.add(proc);
        }
        List<OSProcess> sorted = this.processSort(procs, limit, sort);
        return sorted.toArray(new OSProcess[0]);
    }

    @Override
    public OSProcess getProcess(int pid) {
        return this.getProcess(pid, true);
    }

    private OSProcess getProcess(int pid, boolean slowFields) {
        SystemB.RUsageInfoV2 rUsageInfoV2;
        String[] pathSplit;
        SystemB.ProcTaskAllInfo taskAllInfo = new SystemB.ProcTaskAllInfo();
        if (0 > SystemB.INSTANCE.proc_pidinfo(pid, 2, 0L, (Structure)taskAllInfo, taskAllInfo.size())) {
            return null;
        }
        String name = null;
        String path = "";
        Memory buf = new Memory(4096L);
        if (0 < SystemB.INSTANCE.proc_pidpath(pid, (Pointer)buf, 4096) && (pathSplit = (path = buf.getString(0L).trim()).split("/")).length > 0) {
            name = pathSplit[pathSplit.length - 1];
        }
        if (taskAllInfo.ptinfo.pti_threadnum < 1) {
            return null;
        }
        if (name == null) {
            for (int t = 0; t < taskAllInfo.pbsd.pbi_comm.length; ++t) {
                if (taskAllInfo.pbsd.pbi_comm[t] != 0) continue;
                name = new String(taskAllInfo.pbsd.pbi_comm, 0, t);
                break;
            }
        }
        long bytesRead = 0L;
        long bytesWritten = 0L;
        if (this.getVersion().getOsxVersionNumber() >= 9 && 0 == SystemB.INSTANCE.proc_pid_rusage(pid, 2, rUsageInfoV2 = new SystemB.RUsageInfoV2())) {
            bytesRead = rUsageInfoV2.ri_diskio_bytesread;
            bytesWritten = rUsageInfoV2.ri_diskio_byteswritten;
        }
        long now = System.currentTimeMillis();
        OSProcess proc = new OSProcess();
        proc.setName(name);
        proc.setPath(path);
        switch (taskAllInfo.pbsd.pbi_status) {
            case 1: {
                proc.setState(OSProcess.State.SLEEPING);
                break;
            }
            case 2: {
                proc.setState(OSProcess.State.WAITING);
                break;
            }
            case 3: {
                proc.setState(OSProcess.State.RUNNING);
                break;
            }
            case 4: {
                proc.setState(OSProcess.State.NEW);
                break;
            }
            case 5: {
                proc.setState(OSProcess.State.ZOMBIE);
                break;
            }
            case 6: {
                proc.setState(OSProcess.State.STOPPED);
                break;
            }
            default: {
                proc.setState(OSProcess.State.OTHER);
            }
        }
        proc.setProcessID(pid);
        proc.setParentProcessID(taskAllInfo.pbsd.pbi_ppid);
        proc.setUserID(Integer.toString(taskAllInfo.pbsd.pbi_uid));
        SystemB.Passwd user = SystemB.INSTANCE.getpwuid(taskAllInfo.pbsd.pbi_uid);
        proc.setUser(user == null ? proc.getUserID() : user.pw_name);
        proc.setGroupID(Integer.toString(taskAllInfo.pbsd.pbi_gid));
        SystemB.Group group = SystemB.INSTANCE.getgrgid(taskAllInfo.pbsd.pbi_gid);
        proc.setGroup(group == null ? proc.getGroupID() : group.gr_name);
        proc.setThreadCount(taskAllInfo.ptinfo.pti_threadnum);
        proc.setPriority(taskAllInfo.ptinfo.pti_priority);
        proc.setVirtualSize(taskAllInfo.ptinfo.pti_virtual_size);
        proc.setResidentSetSize(taskAllInfo.ptinfo.pti_resident_size);
        proc.setKernelTime(taskAllInfo.ptinfo.pti_total_system / 1000000L);
        proc.setUserTime(taskAllInfo.ptinfo.pti_total_user / 1000000L);
        proc.setStartTime(taskAllInfo.pbsd.pbi_start_tvsec * 1000L + taskAllInfo.pbsd.pbi_start_tvusec / 1000L);
        proc.setUpTime(now - proc.getStartTime());
        proc.setBytesRead(bytesRead);
        proc.setBytesWritten(bytesWritten);
        proc.setCommandLine(this.getCommandLine(pid));
        proc.setOpenFiles(taskAllInfo.pbsd.pbi_nfiles);
        proc.setBitness((taskAllInfo.pbsd.pbi_flags & this.P_LP64) == 0 ? 32 : 64);
        SystemB.VnodePathInfo vpi = new SystemB.VnodePathInfo();
        if (0 < SystemB.INSTANCE.proc_pidinfo(pid, 9, 0L, (Structure)vpi, vpi.size())) {
            int len = 0;
            for (byte b : vpi.pvi_cdir.vip_path) {
                if (b == 0) break;
                ++len;
            }
            proc.setCurrentWorkingDirectory(new String(vpi.pvi_cdir.vip_path, 0, len, StandardCharsets.US_ASCII));
        }
        return proc;
    }

    @Override
    public OSProcess[] getChildProcesses(int parentPid, int limit, OperatingSystem.ProcessSort sort) {
        ArrayList<OSProcess> procs = new ArrayList<OSProcess>();
        int[] pids = new int[this.maxProc];
        int numberOfProcesses = SystemB.INSTANCE.proc_listpids(1, 0, pids, pids.length * SystemB.INT_SIZE) / SystemB.INT_SIZE;
        for (int i = 0; i < numberOfProcesses; ++i) {
            OSProcess proc;
            if (pids[i] == 0 || parentPid != this.getParentProcessPid(pids[i]) || (proc = this.getProcess(pids[i], true)) == null) continue;
            procs.add(proc);
        }
        List<OSProcess> sorted = this.processSort(procs, limit, sort);
        return sorted.toArray(new OSProcess[0]);
    }

    private int getParentProcessPid(int pid) {
        SystemB.ProcTaskAllInfo taskAllInfo = new SystemB.ProcTaskAllInfo();
        if (0 > SystemB.INSTANCE.proc_pidinfo(pid, 2, 0L, (Structure)taskAllInfo, taskAllInfo.size())) {
            return 0;
        }
        return taskAllInfo.pbsd.pbi_ppid;
    }

    private String getCommandLine(int pid) {
        IntByReference size;
        int[] mib = new int[]{1, 49, pid};
        int argmax = SysctlUtil.sysctl("kern.argmax", 0);
        Memory procargs = new Memory((long)argmax);
        if (0 != SystemB.INSTANCE.sysctl(mib, mib.length, (Pointer)procargs, size = new IntByReference(argmax), null, 0)) {
            LOG.warn("Failed syctl call for process arguments (kern.procargs2), process {} may not exist. Error code: {}", (Object)pid, (Object)Native.getLastError());
            return "";
        }
        int nargs = procargs.getInt(0L);
        if (nargs < 0 || nargs > 1024) {
            LOG.error("Nonsensical number of process arguments for pid {}: {}", (Object)pid, (Object)nargs);
            return "";
        }
        ArrayList<String> args = new ArrayList<String>(nargs);
        long offset = SystemB.INT_SIZE;
        offset += (long)procargs.getString(offset).length();
        while (nargs-- > 0 && offset < (long)size.getValue()) {
            while (procargs.getByte(offset) == 0 && ++offset < (long)size.getValue()) {
            }
            String arg = procargs.getString(offset);
            args.add(arg);
            offset += (long)arg.length();
        }
        return String.join((CharSequence)"\u0000", args);
    }

    @Override
    public MacOSVersionInfoEx getVersion() {
        return (MacOSVersionInfoEx)this.version;
    }

    @Override
    public int getProcessId() {
        return SystemB.INSTANCE.getpid();
    }

    @Override
    public int getProcessCount() {
        return SystemB.INSTANCE.proc_listpids(1, 0, null, 0) / SystemB.INT_SIZE;
    }

    @Override
    public int getThreadCount() {
        int[] pids = new int[this.getProcessCount() + 10];
        int numberOfProcesses = SystemB.INSTANCE.proc_listpids(1, 0, pids, pids.length) / SystemB.INT_SIZE;
        int numberOfThreads = 0;
        SystemB.ProcTaskInfo taskInfo = new SystemB.ProcTaskInfo();
        for (int i = 0; i < numberOfProcesses; ++i) {
            SystemB.INSTANCE.proc_pidinfo(pids[i], 4, 0L, (Structure)taskInfo, taskInfo.size());
            numberOfThreads += taskInfo.pti_threadnum;
        }
        return numberOfThreads;
    }

    @Override
    public long getSystemUptime() {
        return System.currentTimeMillis() / 1000L - BOOTTIME;
    }

    @Override
    public long getSystemBootTime() {
        return BOOTTIME;
    }

    @Override
    public NetworkParams getNetworkParams() {
        return new MacNetworkParams();
    }

    static {
        SystemB.Timeval tv = new SystemB.Timeval();
        BOOTTIME = !SysctlUtil.sysctl("kern.boottime", (Structure)tv) || tv.tv_sec.longValue() == 0L ? ParseUtil.parseLongOrDefault(ExecutingCommand.getFirstAnswer("sysctl -n kern.boottime").split(",")[0].replaceAll("\\D", ""), System.currentTimeMillis() / 1000L) : tv.tv_sec.longValue();
    }
}

