/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import oshi.software.os.OSProcess;
import oshi.software.os.OperatingSystem;
import oshi.software.os.OperatingSystemVersion;

public abstract class AbstractOperatingSystem
implements OperatingSystem {
    private static final long serialVersionUID = 1L;
    protected String manufacturer;
    protected String family;
    protected OperatingSystemVersion version;
    protected int bitness = System.getProperty("os.arch").indexOf("64") != -1 ? 64 : 32;
    protected int elevated = -1;
    private static final Comparator<OSProcess> CPU_DESC_SORT = Comparator.comparingDouble(OSProcess::calculateCpuPercent).reversed();
    private static final Comparator<OSProcess> RSS_DESC_SORT = Comparator.comparingLong(OSProcess::getResidentSetSize).reversed();
    private static final Comparator<OSProcess> UPTIME_ASC_SORT = Comparator.comparingLong(OSProcess::getUpTime);
    private static final Comparator<OSProcess> UPTIME_DESC_SORT = UPTIME_ASC_SORT.reversed();
    private static final Comparator<OSProcess> PID_ASC_SORT = Comparator.comparingInt(OSProcess::getProcessID);
    private static final Comparator<OSProcess> PARENTPID_ASC_SORT = Comparator.comparingInt(OSProcess::getParentProcessID);
    private static final Comparator<OSProcess> NAME_ASC_SORT = Comparator.comparing(OSProcess::getName, String.CASE_INSENSITIVE_ORDER);

    @Override
    public OperatingSystemVersion getVersion() {
        return this.version;
    }

    @Override
    public String getFamily() {
        return this.family;
    }

    @Override
    public String getManufacturer() {
        return this.manufacturer;
    }

    protected List<OSProcess> processSort(List<OSProcess> processes, int limit, OperatingSystem.ProcessSort sort) {
        if (sort != null) {
            switch (sort) {
                case CPU: {
                    processes.sort(CPU_DESC_SORT);
                    break;
                }
                case MEMORY: {
                    processes.sort(RSS_DESC_SORT);
                    break;
                }
                case OLDEST: {
                    processes.sort(UPTIME_DESC_SORT);
                    break;
                }
                case NEWEST: {
                    processes.sort(UPTIME_ASC_SORT);
                    break;
                }
                case PID: {
                    processes.sort(PID_ASC_SORT);
                    break;
                }
                case PARENTPID: {
                    processes.sort(PARENTPID_ASC_SORT);
                    break;
                }
                case NAME: {
                    processes.sort(NAME_ASC_SORT);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unimplemented enum type: " + sort.toString());
                }
            }
        }
        int maxProcs = processes.size();
        if (limit <= 0 || maxProcs <= limit) {
            return processes;
        }
        maxProcs = limit;
        ArrayList<OSProcess> procs = new ArrayList<OSProcess>();
        for (int i = 0; i < maxProcs; ++i) {
            procs.add(processes.get(i));
        }
        return procs;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getManufacturer()).append(' ').append(this.getFamily()).append(' ').append(this.getVersion().toString());
        return sb.toString();
    }

    @Override
    public OSProcess[] getProcesses(int limit, OperatingSystem.ProcessSort sort) {
        return this.getProcesses(limit, sort, false);
    }

    @Override
    public List<OSProcess> getProcesses(Collection<Integer> pids) {
        ArrayList<OSProcess> returnValue = new ArrayList<OSProcess>(pids.size());
        for (Integer pid : pids) {
            OSProcess process = this.getProcess(pid);
            if (process == null) continue;
            returnValue.add(process);
        }
        return returnValue;
    }

    @Override
    public int getBitness() {
        return this.bitness;
    }

    @Override
    public boolean isElevated() {
        if (this.elevated < 0) {
            this.elevated = System.getenv("SUDO_COMMAND") == null ? 0 : 1;
        }
        return this.elevated > 0;
    }
}

