/*
 * Decompiled with CFR 0.152.
 */
package oshi.jna.platform.windows;

import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.WinNT;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ProcInfo {
    public static void main(String[] args) {
        ProcInfo.getGroups();
        System.out.println();
        ProcInfo.getPackages();
        System.out.println();
        ProcInfo.getNumaNodes();
        System.out.println();
        ProcInfo.getCaches();
        System.out.println();
        ProcInfo.getCores();
        System.out.println();
        ProcInfo.getItAll();
    }

    private static void getGroups() {
        WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION_EX[] processors = Kernel32Util.getLogicalProcessorInformationEx((int)4);
        System.out.format("Info for %d group structure (should only be 1):%n", processors.length);
        for (int i = 0; i < processors.length; ++i) {
            System.out.format("Relationship should be %d, it is %d%n", 4, processors[i].relationship);
            WinNT.GROUP_RELATIONSHIP group = (WinNT.GROUP_RELATIONSHIP)processors[i];
            System.out.format("Details for %d group(s):%n", group.activeGroupCount);
            for (int j = 0; j < group.activeGroupCount; ++j) {
                System.out.format("Group %d had %d active of %d max processors with bitmask %s.%n", j, group.groupInfo[j].activeProcessorCount, group.groupInfo[j].maximumProcessorCount, Long.toBinaryString(group.groupInfo[j].activeProcessorMask.longValue()));
            }
        }
    }

    private static void getPackages() {
        WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION_EX[] processors = Kernel32Util.getLogicalProcessorInformationEx((int)3);
        System.out.format("Details of %d package(s):%n", processors.length);
        for (int i = 0; i < processors.length; ++i) {
            System.out.format("Relationship should be %d, it is %d%n", 3, processors[i].relationship);
            WinNT.PROCESSOR_RELATIONSHIP pkg = (WinNT.PROCESSOR_RELATIONSHIP)processors[i];
            System.out.format("Flags should be 0 for a package, it is %d. Efficiency class is %d. Group count is %d.%n", pkg.flags, pkg.efficiencyClass, pkg.groupCount);
            for (int j = 0; j < pkg.groupCount; ++j) {
                System.out.format("Mask %d is in group %d with bitmask %s.%n", j, pkg.groupMask[j].group, Long.toBinaryString(pkg.groupMask[j].mask.longValue()));
            }
        }
    }

    private static void getNumaNodes() {
        WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION_EX[] processors = Kernel32Util.getLogicalProcessorInformationEx((int)1);
        System.out.format("Details of %d NUMA node(s):%n", processors.length);
        for (int i = 0; i < processors.length; ++i) {
            System.out.format("Relationship should be %d, it is %d%n", 1, processors[i].relationship);
            WinNT.NUMA_NODE_RELATIONSHIP node = (WinNT.NUMA_NODE_RELATIONSHIP)processors[i];
            System.out.format("Node %d is in group %d with bitmask %s.%n", node.nodeNumber, node.groupMask.group, Long.toBinaryString(node.groupMask.mask.longValue()));
        }
    }

    private static void getCaches() {
        WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION_EX[] processors = Kernel32Util.getLogicalProcessorInformationEx((int)2);
        System.out.format("Details of %d Cache(s):%n", processors.length);
        for (int i = 0; i < processors.length; ++i) {
            System.out.format("Relationship should be %d, it is %d%n", 2, processors[i].relationship);
            WinNT.CACHE_RELATIONSHIP cache = (WinNT.CACHE_RELATIONSHIP)processors[i];
            System.out.format("Cache is level %d with associativity %d and linesize %d. Type is %d and size is %d. It is in group %d with bitmask %s.%n", cache.level, cache.associativity, cache.lineSize, cache.type, cache.cacheSize, cache.groupMask.group, Long.toBinaryString(cache.groupMask.mask.longValue()));
        }
    }

    private static void getCores() {
        WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION_EX[] processors = Kernel32Util.getLogicalProcessorInformationEx((int)0);
        System.out.format("Details of %d core(s):%n", processors.length);
        for (int i = 0; i < processors.length; ++i) {
            System.out.format("Relationship should be %d, it is %d%n", 0, processors[i].relationship);
            WinNT.PROCESSOR_RELATIONSHIP core = (WinNT.PROCESSOR_RELATIONSHIP)processors[i];
            System.out.format("Efficiency class is %d. Group count is %d.%n", core.efficiencyClass, core.groupCount);
            System.out.format("Hyperthreading flag is %d, should be 1 only if bitmask bits %d > 1 or group count %d > 1.%n", core.flags, Long.bitCount(core.groupMask[0].mask.longValue()), core.groupCount);
            for (int j = 0; j < core.groupMask.length; ++j) {
                System.out.format("Mask %d is in group %d with bitmask %s.%n", j, core.groupMask[0].group, Long.toBinaryString(core.groupMask[0].mask.longValue()));
            }
        }
    }

    private static void getItAll() {
        System.out.println("Grabbing all info using Kernel32Util...");
        WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION_EX[] procInfo = Kernel32Util.getLogicalProcessorInformationEx((int)65535);
        List<Object> groups = new ArrayList();
        ArrayList<WinNT.GROUP_AFFINITY[]> packages = new ArrayList<WinNT.GROUP_AFFINITY[]>();
        ArrayList<WinNT.NUMA_NODE_RELATIONSHIP> numaNodes = new ArrayList<WinNT.NUMA_NODE_RELATIONSHIP>();
        ArrayList<WinNT.CACHE_RELATIONSHIP> caches = new ArrayList<WinNT.CACHE_RELATIONSHIP>();
        ArrayList<WinNT.GROUP_AFFINITY> cores = new ArrayList<WinNT.GROUP_AFFINITY>();
        block7: for (int i = 0; i < procInfo.length; ++i) {
            switch (procInfo[i].relationship) {
                case 4: {
                    groups = Arrays.asList(((WinNT.GROUP_RELATIONSHIP)procInfo[i]).groupInfo);
                    continue block7;
                }
                case 3: {
                    packages.add(((WinNT.PROCESSOR_RELATIONSHIP)procInfo[i]).groupMask);
                    continue block7;
                }
                case 1: {
                    numaNodes.add((WinNT.NUMA_NODE_RELATIONSHIP)procInfo[i]);
                    continue block7;
                }
                case 2: {
                    caches.add((WinNT.CACHE_RELATIONSHIP)procInfo[i]);
                    continue block7;
                }
                case 0: {
                    cores.add(((WinNT.PROCESSOR_RELATIONSHIP)procInfo[i]).groupMask[0]);
                    continue block7;
                }
                default: {
                    System.out.println("You should never see this message.");
                }
            }
        }
        System.out.format("Retrieved %d structures: %d groups, %d packages, %d numa nodes, %d caches, %d cores%n", procInfo.length, groups.size(), packages.size(), numaNodes.size(), caches.size(), cores.size());
        System.out.println("Topology:");
        System.out.format("%6s %7s %11s %5s %9s%n", "Group", "package", "NUMA node", "core", "logical processor");
        for (int g = 0; g < groups.size(); ++g) {
            for (int lp = 0; lp < 64; ++lp) {
                int pkg = ProcInfo.getMatchingPackage(packages, g, lp);
                if (pkg < 0) continue;
                System.out.format("%4d %8d %8d %8d %8d%n", g, pkg, ProcInfo.getMatchingNumaNode(numaNodes, g, lp), ProcInfo.getMatchingCore(cores, g, lp), lp);
            }
        }
    }

    private static int getMatchingPackage(List<WinNT.GROUP_AFFINITY[]> packages, int g, int lp) {
        for (int i = 0; i < packages.size(); ++i) {
            for (int j = 0; j < packages.get(i).length; ++j) {
                if ((packages.get((int)i)[j].mask.longValue() & 1L << lp) <= 0L || packages.get((int)i)[j].group != g) continue;
                return i;
            }
        }
        return -1;
    }

    private static int getMatchingNumaNode(List<WinNT.NUMA_NODE_RELATIONSHIP> numaNodes, int g, int lp) {
        for (int j = 0; j < numaNodes.size(); ++j) {
            if ((numaNodes.get((int)j).groupMask.mask.longValue() & 1L << lp) <= 0L || numaNodes.get((int)j).groupMask.group != g) continue;
            return numaNodes.get((int)j).nodeNumber;
        }
        return -1;
    }

    private static int getMatchingCore(List<WinNT.GROUP_AFFINITY> cores, int g, int lp) {
        for (int j = 0; j < cores.size(); ++j) {
            if ((cores.get((int)j).mask.longValue() & 1L << lp) <= 0L || cores.get((int)j).group != g) continue;
            return j;
        }
        return -1;
    }
}

