/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import com.sun.jna.platform.win32.COM.WbemcliUtil;
import oshi.hardware.Baseboard;
import oshi.hardware.Firmware;
import oshi.hardware.common.AbstractComputerSystem;
import oshi.hardware.platform.windows.WindowsBaseboard;
import oshi.hardware.platform.windows.WindowsFirmware;
import oshi.util.platform.windows.WmiQueryHandler;
import oshi.util.platform.windows.WmiUtil;

final class WindowsComputerSystem
extends AbstractComputerSystem {
    private static final long serialVersionUID = 1L;
    private final transient WmiQueryHandler wmiQueryHandler = WmiQueryHandler.createInstance();

    WindowsComputerSystem() {
    }

    @Override
    public String getManufacturer() {
        if (this.manufacturer == null) {
            this.queryManufacturerAndModel();
        }
        return super.getManufacturer();
    }

    @Override
    public String getModel() {
        if (this.model == null) {
            this.queryManufacturerAndModel();
        }
        return super.getModel();
    }

    @Override
    public String getSerialNumber() {
        if (this.serialNumber == null) {
            this.querySystemSerialNumber();
        }
        return this.serialNumber;
    }

    @Override
    public Firmware getFirmware() {
        if (this.firmware == null) {
            this.firmware = new WindowsFirmware();
        }
        return this.firmware;
    }

    @Override
    public Baseboard getBaseboard() {
        if (this.baseboard == null) {
            this.baseboard = new WindowsBaseboard();
        }
        return this.baseboard;
    }

    private void queryManufacturerAndModel() {
        WbemcliUtil.WmiQuery computerSystemQuery = new WbemcliUtil.WmiQuery("Win32_ComputerSystem", ComputerSystemProperty.class);
        WbemcliUtil.WmiResult win32ComputerSystem = this.wmiQueryHandler.queryWMI(computerSystemQuery);
        if (win32ComputerSystem.getResultCount() > 0) {
            this.manufacturer = WmiUtil.getString(win32ComputerSystem, ComputerSystemProperty.MANUFACTURER, 0);
            this.model = WmiUtil.getString(win32ComputerSystem, ComputerSystemProperty.MODEL, 0);
        }
    }

    private void querySystemSerialNumber() {
        if (!this.querySerialFromBios() && !this.querySerialFromCsProduct()) {
            this.serialNumber = "unknown";
        }
    }

    private boolean querySerialFromBios() {
        WbemcliUtil.WmiQuery serialNumberQuery = new WbemcliUtil.WmiQuery("Win32_BIOS where PrimaryBIOS=true", BiosProperty.class);
        WbemcliUtil.WmiResult serialNumber = this.wmiQueryHandler.queryWMI(serialNumberQuery);
        if (serialNumber.getResultCount() > 0) {
            this.serialNumber = WmiUtil.getString(serialNumber, BiosProperty.SERIALNUMBER, 0);
        }
        return this.serialNumber != null && !this.serialNumber.isEmpty();
    }

    private boolean querySerialFromCsProduct() {
        WbemcliUtil.WmiQuery identifyingNumberQuery = new WbemcliUtil.WmiQuery("Win32_ComputerSystemProduct", ComputerSystemProductProperty.class);
        WbemcliUtil.WmiResult identifyingNumber = this.wmiQueryHandler.queryWMI(identifyingNumberQuery);
        if (identifyingNumber.getResultCount() > 0) {
            this.serialNumber = WmiUtil.getString(identifyingNumber, ComputerSystemProductProperty.IDENTIFYINGNUMBER, 0);
        }
        return this.serialNumber != null && !this.serialNumber.isEmpty();
    }

    static enum ComputerSystemProductProperty {
        IDENTIFYINGNUMBER;

    }

    static enum BiosProperty {
        SERIALNUMBER;

    }

    static enum ComputerSystemProperty {
        MANUFACTURER,
        MODEL;

    }
}

