/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.mac;

import oshi.hardware.common.AbstractSensors;
import oshi.util.platform.mac.SmcUtil;

public class MacSensors
extends AbstractSensors {
    private static final long serialVersionUID = 1L;
    private int numFans = 0;

    @Override
    public double getCpuTemperature() {
        SmcUtil.smcOpen();
        double temp = SmcUtil.smcGetFloat("TC0P", 50);
        SmcUtil.smcClose();
        if (temp > 0.0) {
            return temp;
        }
        return 0.0;
    }

    @Override
    public int[] getFanSpeeds() {
        SmcUtil.smcOpen();
        if (this.numFans == 0) {
            this.numFans = (int)SmcUtil.smcGetLong("FNum", 50);
        }
        int[] fanSpeeds = new int[this.numFans];
        for (int i = 0; i < this.numFans; ++i) {
            fanSpeeds[i] = (int)SmcUtil.smcGetFloat(String.format("F%dAc", i), 50);
        }
        SmcUtil.smcClose();
        return fanSpeeds;
    }

    @Override
    public double getCpuVoltage() {
        SmcUtil.smcOpen();
        double volts = SmcUtil.smcGetFloat("VC0C", 50) / 1000.0;
        SmcUtil.smcClose();
        return volts;
    }
}

