/*
 * Decompiled with CFR 0.152.
 */
package oshi.util.platform.windows;

import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.OleAuto;
import com.sun.jna.platform.win32.Variant;
import com.sun.jna.platform.win32.WTypes;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.LongByReference;
import com.sun.jna.ptr.PointerByReference;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.jna.platform.windows.COM.EnumWbemClassObject;
import oshi.jna.platform.windows.COM.WbemClassObject;
import oshi.jna.platform.windows.COM.WbemLocator;
import oshi.jna.platform.windows.COM.WbemServices;
import oshi.jna.platform.windows.Ole32;
import oshi.util.ParseUtil;

public class WmiUtil {
    private static final Logger LOG = LoggerFactory.getLogger(WmiUtil.class);
    private static WmiUtil INSTANCE = new WmiUtil();
    public static final String DEFAULT_NAMESPACE = "ROOT\\CIMV2";
    public static final String OHM_NAMESPACE = "ROOT\\OpenHardwareMonitor";
    private static boolean comInitialized = false;
    private static boolean securityInitialized = false;
    private static Map<String, WmiConnection> connectionCache = new HashMap<String, WmiConnection>();
    private static long nextCacheClear = System.currentTimeMillis() + 300000L;
    private static Set<String> hasNamespaceCache = new HashSet<String>();
    private static Set<String> hasNotNamespaceCache = new HashSet<String>();
    private static final WmiQuery<NamespaceProperty> NAMESPACE_QUERY = WmiUtil.createQuery("ROOT", "__NAMESPACE", NamespaceProperty.class);

    private WmiUtil() {
        if (!WmiUtil.initCOM()) {
            WmiUtil.unInitCOM();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                WmiUtil.unInitCOM();
            }
        });
    }

    public static <T extends Enum<T>> WmiQuery<T> createQuery(String nameSpace, String wmiClassName, Class<T> propertyEnum) {
        WmiUtil wmiUtil = INSTANCE;
        wmiUtil.getClass();
        return wmiUtil.new WmiQuery<T>(nameSpace, wmiClassName, propertyEnum);
    }

    public static <T extends Enum<T>> WmiQuery<T> createQuery(String wmiClassName, Class<T> propertyEnum) {
        return WmiUtil.createQuery(DEFAULT_NAMESPACE, wmiClassName, propertyEnum);
    }

    public static boolean hasNamespace(String namespace) {
        if (hasNamespaceCache.contains(namespace)) {
            return true;
        }
        if (hasNotNamespaceCache.contains(namespace)) {
            return false;
        }
        WmiResult<NamespaceProperty> namespaces = WmiUtil.queryWMI(NAMESPACE_QUERY);
        for (int i = 0; i < namespaces.getResultCount(); ++i) {
            if (!namespace.equals(namespaces.get(NamespaceProperty.NAME).get(i))) continue;
            return true;
        }
        return false;
    }

    public static <T extends Enum<T>> WmiResult<T> queryWMI(WmiQuery<T> query) {
        try {
            return WmiUtil.queryWMI(query, -1);
        }
        catch (TimeoutException e) {
            LOG.error("Got a WMI timeout when infinite wait specified. This should never happen.", (Throwable)e);
            WmiUtil wmiUtil = INSTANCE;
            wmiUtil.getClass();
            return wmiUtil.new WmiResult<T>(query.getPropertyEnum());
        }
    }

    public static <T extends Enum<T>> WmiResult<T> queryWMI(WmiQuery<T> query, int timeout) throws TimeoutException {
        if (((Enum[])query.getPropertyEnum().getEnumConstants()).length < 1) {
            throw new IllegalArgumentException("The query's property enum has no values.");
        }
        WmiUtil wmiUtil = INSTANCE;
        wmiUtil.getClass();
        WmiResult<T> values = wmiUtil.new WmiResult<T>(query.getPropertyEnum());
        if (!comInitialized && !WmiUtil.initCOM()) {
            WmiUtil.unInitCOM();
            return values;
        }
        WmiConnection conn = WmiUtil.connectToNamespace(query.getNameSpace());
        if (conn == null) {
            return values;
        }
        PointerByReference pEnumerator = new PointerByReference();
        if (!WmiUtil.selectProperties(conn.getService(), pEnumerator, query)) {
            conn.close();
            return values;
        }
        EnumWbemClassObject enumerator = new EnumWbemClassObject(pEnumerator.getValue());
        try {
            WmiUtil.enumerateProperties(values, enumerator, query.getPropertyEnum(), timeout);
        }
        catch (TimeoutException e) {
            throw new TimeoutException(e.getMessage());
        }
        finally {
            enumerator.Release();
        }
        return values;
    }

    private static boolean initCOM() {
        WinNT.HRESULT hres = Ole32.INSTANCE.CoInitializeEx(null, 0);
        if (COMUtils.FAILED((WinNT.HRESULT)hres)) {
            if (hres.intValue() == -2147417850) {
                LOG.debug("COM already initialized.");
                securityInitialized = true;
                return true;
            }
            if (LOG.isErrorEnabled()) {
                LOG.error(String.format("Failed to initialize COM library. Error code = 0x%08x", hres.intValue()));
            }
            return false;
        }
        comInitialized = true;
        if (securityInitialized) {
            return true;
        }
        hres = Ole32.INSTANCE.CoInitializeSecurity(null, new NativeLong(-1L), null, null, 0, 3, null, 0, null);
        if (COMUtils.FAILED((WinNT.HRESULT)hres) && hres.intValue() != -2147417831) {
            if (LOG.isErrorEnabled()) {
                LOG.error(String.format("Failed to initialize security. Error code = 0x%08x", hres.intValue()));
            }
            Ole32.INSTANCE.CoUninitialize();
            return false;
        }
        securityInitialized = true;
        return true;
    }

    private static WmiConnection connectToNamespace(String namespace) {
        PointerByReference pSvc;
        if (System.currentTimeMillis() > nextCacheClear) {
            WmiUtil.closeStaleConnections();
            nextCacheClear = System.currentTimeMillis() + 300000L;
        }
        if (connectionCache.containsKey(namespace)) {
            WmiConnection conn = connectionCache.get(namespace);
            if (conn.isStale()) {
                conn.close();
                connectionCache.remove(namespace);
            } else {
                return conn;
            }
        }
        if (!WmiUtil.connectServer(namespace, pSvc = new PointerByReference())) {
            return null;
        }
        WmiUtil wmiUtil = INSTANCE;
        wmiUtil.getClass();
        WmiConnection conn = wmiUtil.new WmiConnection(pSvc);
        connectionCache.put(namespace, conn);
        return conn;
    }

    private static boolean connectServer(String namespace, PointerByReference pSvc) {
        WbemLocator loc = WbemLocator.create();
        if (loc == null) {
            return false;
        }
        WinNT.HRESULT hres = loc.ConnectServer(new WTypes.BSTR(namespace), null, null, null, null, null, null, pSvc);
        if (COMUtils.FAILED((WinNT.HRESULT)hres)) {
            if (!OHM_NAMESPACE.equals(namespace) && LOG.isErrorEnabled()) {
                LOG.error(String.format("Could not connect to namespace %s. Error code = 0x%08x", namespace, hres.intValue()));
            }
            loc.Release();
            WmiUtil.unInitCOM();
            return false;
        }
        LOG.debug("Connected to {} WMI namespace", (Object)namespace);
        loc.Release();
        hres = Ole32.INSTANCE.CoSetProxyBlanket(pSvc.getValue(), 10, 0, null, 3, 3, null, 0);
        if (COMUtils.FAILED((WinNT.HRESULT)hres)) {
            if (LOG.isErrorEnabled()) {
                LOG.error(String.format("Could not set proxy blanket. Error code = 0x%08x", hres.intValue()));
            }
            new WbemServices(pSvc.getValue()).Release();
            WmiUtil.unInitCOM();
            return false;
        }
        LOG.debug("Proxy blanket set.");
        return true;
    }

    private static <T extends Enum<T>> boolean selectProperties(WbemServices svc, PointerByReference pEnumerator, WmiQuery<T> query) {
        Enum[] props = (Enum[])query.getPropertyEnum().getEnumConstants();
        StringBuilder sb = new StringBuilder("SELECT ");
        sb.append(props[0].name());
        for (int i = 1; i < props.length; ++i) {
            sb.append(',').append(props[i].name());
        }
        sb.append(" FROM ").append(query.getWmiClassName());
        LOG.debug("Query: {}", (Object)sb);
        WinNT.HRESULT hres = svc.ExecQuery(new WTypes.BSTR("WQL"), new WTypes.BSTR(sb.toString().replaceAll("\\\\", "\\\\\\\\")), new NativeLong(48L), null, pEnumerator);
        if (COMUtils.FAILED((WinNT.HRESULT)hres)) {
            if (LOG.isErrorEnabled()) {
                LOG.error(String.format("Query '%s' failed. Error code = 0x%08x", sb, hres.intValue()));
            }
            svc.Release();
            WmiUtil.unInitCOM();
            return false;
        }
        LOG.debug("Query succeeded.");
        return true;
    }

    private static <T extends Enum<T>> void enumerateProperties(WmiResult<T> values, EnumWbemClassObject enumerator, Class<T> propertyEnum, int timeout) throws TimeoutException {
        PointerByReference pclsObj = new PointerByReference();
        LongByReference uReturn = new LongByReference(0L);
        while (enumerator.getPointer() != Pointer.NULL) {
            WinNT.HRESULT hres = enumerator.Next(new NativeLong((long)timeout), new NativeLong(1L), pclsObj, uReturn);
            if (hres.intValue() == 262148) {
                throw new TimeoutException("No results after " + timeout + " ms.");
            }
            if (COMUtils.FAILED((WinNT.HRESULT)hres) || 0L == uReturn.getValue() || hres.intValue() == 262145) {
                LOG.debug("Returned {} results.", (Object)values.getResultCount());
                break;
            }
            Variant.VARIANT.ByReference vtProp = new Variant.VARIANT.ByReference();
            WbemClassObject clsObj = new WbemClassObject(pclsObj.getValue());
            for (Enum property : (Enum[])propertyEnum.getEnumConstants()) {
                clsObj.Get(new WTypes.BSTR(property.name()), new NativeLong(0L), vtProp, null, null);
                switch (((WmiProperty)((Object)property)).getType()) {
                    case STRING: {
                        values.get(property).add(vtProp.getValue() == null ? "unknown" : vtProp.stringValue());
                        break;
                    }
                    case UINT16: {
                        values.get(property).add(vtProp.getValue() == null ? 0L : (long)vtProp.intValue());
                        break;
                    }
                    case UINT32: {
                        values.get(property).add(vtProp.getValue() == null ? 0L : vtProp.longValue());
                        break;
                    }
                    case UINT64: {
                        values.get(property).add(vtProp.getValue() == null ? 0L : ParseUtil.parseLongOrDefault(vtProp.stringValue(), 0L));
                        break;
                    }
                    case FLOAT: {
                        values.get(property).add(Float.valueOf(vtProp.getValue() == null ? 0.0f : vtProp.floatValue()));
                        break;
                    }
                    case DATETIME: {
                        values.get(property).add(vtProp.getValue() == null ? 0L : ParseUtil.cimDateTimeToMillis(vtProp.stringValue()));
                        break;
                    }
                    case BOOLEAN: {
                        values.get(property).add(vtProp.getValue() == null ? (Constable)Long.valueOf(0L) : (Constable)Boolean.valueOf(vtProp.booleanValue()));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unimplemented enum type: " + ((WmiProperty)((Object)property)).getType().toString());
                    }
                }
                OleAuto.INSTANCE.VariantClear((Variant.VARIANT)vtProp);
            }
            clsObj.Release();
            values.incrementResultCount();
        }
    }

    private static void unInitCOM() {
        for (Map.Entry<String, WmiConnection> entry : connectionCache.entrySet()) {
            entry.getValue().close();
        }
        connectionCache.clear();
        if (comInitialized) {
            Ole32.INSTANCE.CoUninitialize();
            comInitialized = false;
        }
    }

    private static void closeStaleConnections() {
        Iterator<Map.Entry<String, WmiConnection>> iter = connectionCache.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, WmiConnection> entry = iter.next();
            if (!entry.getValue().isStale()) continue;
            entry.getValue().close();
            iter.remove();
        }
    }

    private class WmiConnection {
        public static final long STALE_CONNECTION = 300000L;
        private long staleAfter;
        private WbemServices svc;

        WmiConnection(PointerByReference pSvc) {
            this.svc = new WbemServices(pSvc.getValue());
            this.refresh();
        }

        public WbemServices getService() {
            return this.svc;
        }

        public boolean isStale() {
            return System.currentTimeMillis() > this.staleAfter;
        }

        public void refresh() {
            this.staleAfter = 300000L + System.currentTimeMillis();
        }

        public void close() {
            this.svc.Release();
        }
    }

    public class WmiResult<T extends Enum<T>> {
        private Map<T, List<Object>> propertyMap;
        private int resultCount = 0;

        public WmiResult(Class<T> propertyEnum) {
            this.propertyMap = new EnumMap<T, List<Object>>(propertyEnum);
            for (Enum type : (Enum[])propertyEnum.getEnumConstants()) {
                this.propertyMap.put(type, new ArrayList());
            }
        }

        public List<Object> get(T item) {
            return this.propertyMap.get(item);
        }

        public int getResultCount() {
            return this.resultCount;
        }

        public void incrementResultCount() {
            ++this.resultCount;
        }
    }

    public class WmiQuery<T extends Enum<T>> {
        private String nameSpace;
        private String wmiClassName;
        private Class<T> propertyEnum;

        public WmiQuery(String nameSpace, String wmiClassName, Class<T> propertyEnum) {
            this.nameSpace = nameSpace;
            this.wmiClassName = wmiClassName;
            this.propertyEnum = propertyEnum;
        }

        public Class<T> getPropertyEnum() {
            return this.propertyEnum;
        }

        public String getNameSpace() {
            return this.nameSpace;
        }

        public void setNameSpace(String nameSpace) {
            this.nameSpace = nameSpace;
        }

        public String getWmiClassName() {
            return this.wmiClassName;
        }

        public void setWmiClassName(String wmiClassName) {
            this.wmiClassName = wmiClassName;
        }
    }

    public static interface WmiProperty {
        public ValueType getType();
    }

    private static enum NamespaceProperty implements WmiProperty
    {
        NAME(ValueType.STRING);

        private ValueType type;

        private NamespaceProperty(ValueType type) {
            this.type = type;
        }

        @Override
        public ValueType getType() {
            return this.type;
        }
    }

    public static enum ValueType {
        STRING,
        UINT64,
        UINT32,
        UINT16,
        FLOAT,
        DATETIME,
        BOOLEAN;

    }
}

