/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.windows;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.ptr.IntByReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.jna.platform.windows.IPHlpAPI;
import oshi.software.common.AbstractNetworkParams;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;
import oshi.util.platform.windows.WmiUtil;

public class WindowsNetworkParams
extends AbstractNetworkParams {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG;
    private static final String IPV4_DEFAULT_DEST = "0.0.0.0/0";
    private static final String IPV6_DEFAULT_DEST = "::/0";
    private static final int COMPUTER_NAME_DNS_DOMAIN_FULLY_QUALIFIED = 3;
    private static final WmiProperty[] NETROUTE_PROPERTIES;
    private static final String[] NETROUTE_STRINGS;
    private static final WmiUtil.ValueType[] NETROUTE_TYPES;
    private static final WmiProperty[] IP4ROUTE_PROPERTIES;
    private static final String[] IP4ROUTE_STRINGS;
    private static final WmiUtil.ValueType[] IP4ROUTE_TYPES;

    @Override
    public String getDomainName() {
        char[] buffer = new char[256];
        IntByReference bufferSize = new IntByReference(buffer.length);
        if (!Kernel32.INSTANCE.GetComputerNameEx(3, buffer, bufferSize)) {
            LOG.error("Failed to get dns domain name. Error code: {}", (Object)Kernel32.INSTANCE.GetLastError());
            return "";
        }
        return new String(buffer).trim();
    }

    @Override
    public String[] getDnsServers() {
        IntByReference bufferSize = new IntByReference();
        int ret = IPHlpAPI.INSTANCE.GetNetworkParams(null, bufferSize);
        if (ret != 111) {
            LOG.error("Failed to get network parameters buffer size. Error code: {}", (Object)ret);
            return new String[0];
        }
        IPHlpAPI.FIXED_INFO buffer = new IPHlpAPI.FIXED_INFO((Pointer)new Memory((long)bufferSize.getValue()));
        ret = IPHlpAPI.INSTANCE.GetNetworkParams(buffer, bufferSize);
        if (ret != 0) {
            LOG.error("Failed to get network parameters. Error code: {}", (Object)ret);
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        IPHlpAPI.IP_ADDR_STRING dns = buffer.DnsServerList;
        while (dns != null) {
            String addr = new String(dns.IpAddress.String);
            int nullPos = addr.indexOf(0);
            if (nullPos != -1) {
                addr = addr.substring(0, nullPos);
            }
            list.add(addr);
            dns = dns.Next == null ? null : new IPHlpAPI.IP_ADDR_STRING(dns.Next);
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public String getIpv4DefaultGateway() {
        if (WmiUtil.hasNamespace("StandardCimv2")) {
            return this.getNextHop(IPV4_DEFAULT_DEST);
        }
        return this.getNextHopWin7(IPV4_DEFAULT_DEST.split("/")[0]);
    }

    @Override
    public String getIpv6DefaultGateway() {
        if (WmiUtil.hasNamespace("StandardCimv2")) {
            return this.getNextHop(IPV6_DEFAULT_DEST);
        }
        return this.parseIpv6Route();
    }

    private String getNextHop(String dest) {
        Map<String, List<Object>> vals = WmiUtil.selectObjectsFrom("ROOT\\StandardCimv2", "MSFT_NetRoute", NETROUTE_STRINGS, "WHERE DestinationPrefix=\"" + dest + "\"", NETROUTE_TYPES);
        List<Object> metrics = vals.get(WmiProperty.ROUTEMETRIC.name());
        if (vals.get(WmiProperty.ROUTEMETRIC.name()).isEmpty()) {
            return "";
        }
        int index = 0;
        Long min = Long.MAX_VALUE;
        for (int i = 0; i < metrics.size(); ++i) {
            Long metric = (Long)metrics.get(i);
            if (metric >= min) continue;
            min = metric;
            index = i;
        }
        return (String)vals.get(WmiProperty.NEXTHOP.name()).get(index);
    }

    private String getNextHopWin7(String dest) {
        Map<String, List<Object>> vals = WmiUtil.selectObjectsFrom(null, "Win32_IP4RouteTable", IP4ROUTE_STRINGS, "WHERE Destination=\"" + dest + "\"", IP4ROUTE_TYPES);
        List<Object> metrics = vals.get(WmiProperty.METRIC1.name());
        if (vals.get(WmiProperty.METRIC1.name()).isEmpty()) {
            return "";
        }
        int index = 0;
        Long min = Long.MAX_VALUE;
        for (int i = 0; i < metrics.size(); ++i) {
            Long metric = (Long)metrics.get(i);
            if (metric >= min) continue;
            min = metric;
            index = i;
        }
        return (String)vals.get(WmiProperty.NEXTHOP.name()).get(index);
    }

    private String parseIpv6Route() {
        List<String> lines = ExecutingCommand.runNative("route print -6 ::/0");
        for (String line : lines) {
            String[] fields = ParseUtil.whitespaces.split(line.trim());
            if (fields.length <= 3 || !IPV6_DEFAULT_DEST.equals(fields[2])) continue;
            return fields[3];
        }
        return "";
    }

    static {
        int i;
        LOG = LoggerFactory.getLogger(WindowsNetworkParams.class);
        NETROUTE_PROPERTIES = new WmiProperty[]{WmiProperty.NEXTHOP, WmiProperty.ROUTEMETRIC};
        NETROUTE_STRINGS = new String[NETROUTE_PROPERTIES.length];
        for (i = 0; i < NETROUTE_PROPERTIES.length; ++i) {
            WindowsNetworkParams.NETROUTE_STRINGS[i] = NETROUTE_PROPERTIES[i].name();
        }
        NETROUTE_TYPES = new WmiUtil.ValueType[NETROUTE_PROPERTIES.length];
        for (i = 0; i < NETROUTE_PROPERTIES.length; ++i) {
            WindowsNetworkParams.NETROUTE_TYPES[i] = NETROUTE_PROPERTIES[i].getType();
        }
        IP4ROUTE_PROPERTIES = new WmiProperty[]{WmiProperty.NEXTHOP, WmiProperty.METRIC1};
        IP4ROUTE_STRINGS = new String[IP4ROUTE_PROPERTIES.length];
        for (i = 0; i < IP4ROUTE_PROPERTIES.length; ++i) {
            WindowsNetworkParams.IP4ROUTE_STRINGS[i] = IP4ROUTE_PROPERTIES[i].name();
        }
        IP4ROUTE_TYPES = new WmiUtil.ValueType[IP4ROUTE_PROPERTIES.length];
        for (i = 0; i < IP4ROUTE_PROPERTIES.length; ++i) {
            WindowsNetworkParams.IP4ROUTE_TYPES[i] = IP4ROUTE_PROPERTIES[i].getType();
        }
    }

    static enum WmiProperty {
        NEXTHOP(WmiUtil.ValueType.STRING),
        ROUTEMETRIC(WmiUtil.ValueType.UINT16),
        METRIC1(WmiUtil.ValueType.UINT16);

        private WmiUtil.ValueType type;

        public WmiUtil.ValueType getType() {
            return this.type;
        }

        private WmiProperty(WmiUtil.ValueType type) {
            this.type = type;
        }
    }
}

