/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import com.sun.jna.Native;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.Disks;
import oshi.hardware.HWDiskStore;
import oshi.hardware.HWPartition;
import oshi.jna.platform.windows.Pdh;
import oshi.util.MapUtil;
import oshi.util.ParseUtil;
import oshi.util.StringUtil;
import oshi.util.platform.windows.PdhUtil;
import oshi.util.platform.windows.WmiUtil;

public class WindowsDisks
implements Disks {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(WindowsDisks.class);
    private static Map<String, Long> readMap = new HashMap<String, Long>();
    private static Map<String, Long> readByteMap = new HashMap<String, Long>();
    private static Map<String, Long> writeMap = new HashMap<String, Long>();
    private static Map<String, Long> writeByteMap = new HashMap<String, Long>();
    private static Map<String, Long> xferTimeMap = new HashMap<String, Long>();
    private static Map<String, Long> timeStampMap = new HashMap<String, Long>();
    private static Map<String, List<String>> driveToPartitionMap = new HashMap<String, List<String>>();
    private static Map<String, String> partitionToLogicalDriveMap = new HashMap<String, String>();
    private static Map<String, HWPartition> partitionMap = new HashMap<String, HWPartition>();
    private static final Pattern DEVICE_ID = Pattern.compile(".*\\.DeviceID=\"(.*)\"");
    private static final int BUFSIZE = 255;
    private static final String DISK_DRIVE_CLASS = "Win32_DiskDrive";
    private static final String ANTECEDENT_PROPERTY = "Antecedent";
    private static final String DEPENDENT_PROPERTY = "Dependent";
    private static final String DESCRIPTION_PROPERTY = "Description";
    private static final String DEVICE_ID_PROPERTY = "DeviceID";
    private static final String DISK_INDEX_PROPERTY = "DiskIndex";
    private static final String INDEX_PROPERTY = "Index";
    private static final String MANUFACTURER_PROPERTY = "Manufacturer";
    private static final String MODEL_PROPERTY = "Model";
    private static final String NAME_PROPERTY = "Name";
    private static final String SERIALNUMBER_PROPERTY = "SerialNumber";
    private static final String SIZE_PROPERTY = "Size";
    private static final String TYPE_PROPERTY = "Type";
    private static final String[] DRIVE_PROPERTIES = new String[]{"Name", "Manufacturer", "Model", "SerialNumber", "Size", "Index"};
    private static final WmiUtil.ValueType[] DRIVE_TYPES = new WmiUtil.ValueType[]{WmiUtil.ValueType.STRING, WmiUtil.ValueType.STRING, WmiUtil.ValueType.STRING, WmiUtil.ValueType.STRING, WmiUtil.ValueType.STRING, WmiUtil.ValueType.UINT32};
    private static final String DRIVE_TO_PARTITION_PROPERTIES = StringUtil.join(",", new String[]{"Antecedent", "Dependent"});
    private static final String LOGICAL_DISK_TO_PARTITION_PROPERTIES = StringUtil.join(",", new String[]{"Antecedent", "Dependent"});
    private static final String[] PARTITION_PROPERTIES = new String[]{"Name", "Type", "Description", "DeviceID", "Size", "DiskIndex", "Index"};
    private static final WmiUtil.ValueType[] PARTITION_TYPES = new WmiUtil.ValueType[]{WmiUtil.ValueType.STRING, WmiUtil.ValueType.STRING, WmiUtil.ValueType.STRING, WmiUtil.ValueType.STRING, WmiUtil.ValueType.STRING, WmiUtil.ValueType.UINT32, WmiUtil.ValueType.UINT32};
    private static final String PDH_DISK_READS_FORMAT = "\\PhysicalDisk(%s)\\Disk Reads/sec";
    private static final String PDH_DISK_READ_BYTES_FORMAT = "\\PhysicalDisk(%s)\\Disk Read Bytes/sec";
    private static final String PDH_DISK_WRITES_FORMAT = "\\PhysicalDisk(%s)\\Disk Writes/sec";
    private static final String PDH_DISK_WRITE_BYTES_FORMAT = "\\PhysicalDisk(%s)\\Disk Write Bytes/sec";
    private static final String PDH_DISK_TIME_FORMAT = "\\PhysicalDisk(%s)\\%% Disk Time";
    private static final String PHYSICALDRIVE_PREFIX = "\\\\.\\PHYSICALDRIVE";

    public static boolean updateDiskStats(HWDiskStore diskStore) {
        String index = null;
        HWPartition[] partitions = diskStore.getPartitions();
        if (partitions.length > 0) {
            index = Integer.toString(partitions[0].getMajor());
        } else if (diskStore.getName().startsWith(PHYSICALDRIVE_PREFIX)) {
            index = diskStore.getName().substring(PHYSICALDRIVE_PREFIX.length(), diskStore.getName().length());
        } else {
            LOG.warn("Couldn't match index for {}", (Object)diskStore.getName());
            return false;
        }
        WindowsDisks.populateReadWriteMaps(index);
        if (readMap.containsKey(index)) {
            diskStore.setReads(MapUtil.getOrDefault(readMap, index, 0L));
            diskStore.setReadBytes(MapUtil.getOrDefault(readByteMap, index, 0L));
            diskStore.setWrites(MapUtil.getOrDefault(writeMap, index, 0L));
            diskStore.setWriteBytes(MapUtil.getOrDefault(writeByteMap, index, 0L));
            diskStore.setTransferTime(MapUtil.getOrDefault(xferTimeMap, index, 0L));
            diskStore.setTimeStamp(MapUtil.getOrDefault(timeStampMap, index, 0L));
            return true;
        }
        return false;
    }

    @Override
    public HWDiskStore[] getDisks() {
        ArrayList<HWDiskStore> result = new ArrayList<HWDiskStore>();
        WindowsDisks.populateReadWriteMaps(null);
        this.populatePartitionMaps();
        Map<String, List<Object>> vals = WmiUtil.selectObjectsFrom(null, DISK_DRIVE_CLASS, DRIVE_PROPERTIES, null, DRIVE_TYPES);
        for (int i = 0; i < vals.get(NAME_PROPERTY).size(); ++i) {
            HWDiskStore ds = new HWDiskStore();
            ds.setName((String)vals.get(NAME_PROPERTY).get(i));
            ds.setModel(String.format("%s %s", vals.get(MODEL_PROPERTY).get(i), vals.get(MANUFACTURER_PROPERTY).get(i)).trim());
            ds.setSerial(ParseUtil.hexStringToString((String)vals.get(SERIALNUMBER_PROPERTY).get(i)));
            String index = vals.get(INDEX_PROPERTY).get(i).toString();
            ds.setReads(MapUtil.getOrDefault(readMap, index, 0L));
            ds.setReadBytes(MapUtil.getOrDefault(readByteMap, index, 0L));
            ds.setWrites(MapUtil.getOrDefault(writeMap, index, 0L));
            ds.setWriteBytes(MapUtil.getOrDefault(writeByteMap, index, 0L));
            ds.setTransferTime(MapUtil.getOrDefault(xferTimeMap, index, 0L));
            ds.setTimeStamp(MapUtil.getOrDefault(timeStampMap, index, 0L));
            ds.setSize(ParseUtil.parseLongOrDefault((String)vals.get(SIZE_PROPERTY).get(i), 0L));
            ArrayList<HWPartition> partitions = new ArrayList<HWPartition>();
            List<String> partList = driveToPartitionMap.get(ds.getName());
            if (partList != null && !partList.isEmpty()) {
                for (String part : partList) {
                    partitions.add(partitionMap.get(part));
                }
            }
            ds.setPartitions(partitions.toArray(new HWPartition[partitions.size()]));
            result.add(ds);
        }
        return result.toArray(new HWDiskStore[result.size()]);
    }

    private static void populateReadWriteMaps(String index) {
        if (index == null) {
            readMap.clear();
            readByteMap.clear();
            writeMap.clear();
            writeByteMap.clear();
            xferTimeMap.clear();
            timeStampMap.clear();
        }
        WinDef.DWORDByReference pcchCounterListLength = new WinDef.DWORDByReference(new WinDef.DWORD(0L));
        WinDef.DWORDByReference pcchInstanceListLength = new WinDef.DWORDByReference(new WinDef.DWORD(0L));
        Pdh.INSTANCE.PdhEnumObjectItems(null, null, "PhysicalDisk", null, pcchCounterListLength, null, pcchInstanceListLength, 100, 0);
        char[] mszCounterList = new char[pcchCounterListLength.getValue().intValue()];
        char[] mszInstanceList = new char[pcchInstanceListLength.getValue().intValue()];
        Pdh.INSTANCE.PdhEnumObjectItems(null, null, "PhysicalDisk", mszCounterList, pcchCounterListLength, mszInstanceList, pcchInstanceListLength, 100, 0);
        List instances = Native.toStringList((char[])mszInstanceList);
        instances.remove("_Total");
        for (String i : instances) {
            String xferTimeString;
            String writeBytesString;
            String writeString;
            String readBytesString;
            String name = ParseUtil.whitespaces.split(i)[0];
            String readString = String.format(PDH_DISK_READS_FORMAT, i);
            if (!PdhUtil.isCounter(readString)) {
                PdhUtil.addCounter(readString);
            }
            if (!PdhUtil.isCounter(readBytesString = String.format(PDH_DISK_READ_BYTES_FORMAT, i))) {
                PdhUtil.addCounter(readBytesString);
            }
            if (!PdhUtil.isCounter(writeString = String.format(PDH_DISK_WRITES_FORMAT, i))) {
                PdhUtil.addCounter(writeString);
            }
            if (!PdhUtil.isCounter(writeBytesString = String.format(PDH_DISK_WRITE_BYTES_FORMAT, i))) {
                PdhUtil.addCounter(writeBytesString);
            }
            if (!PdhUtil.isCounter(xferTimeString = String.format(PDH_DISK_TIME_FORMAT, i))) {
                PdhUtil.addCounter(xferTimeString);
            }
            readMap.put(name, PdhUtil.queryCounter(readString));
            readByteMap.put(name, PdhUtil.queryCounter(readBytesString));
            writeMap.put(name, PdhUtil.queryCounter(writeString));
            writeByteMap.put(name, PdhUtil.queryCounter(writeBytesString));
            xferTimeMap.put(name, PdhUtil.queryCounter(xferTimeString) / 10000L);
            timeStampMap.put(name, PdhUtil.queryCounterTimestamp(xferTimeString));
        }
    }

    private void populatePartitionMaps() {
        Matcher mDep;
        Matcher mAnt;
        int i;
        driveToPartitionMap.clear();
        partitionToLogicalDriveMap.clear();
        partitionMap.clear();
        Map<String, List<String>> partitionQueryMap = WmiUtil.selectStringsFrom(null, "Win32_DiskDriveToDiskPartition", DRIVE_TO_PARTITION_PROPERTIES, null);
        for (i = 0; i < partitionQueryMap.get(ANTECEDENT_PROPERTY).size(); ++i) {
            mAnt = DEVICE_ID.matcher(partitionQueryMap.get(ANTECEDENT_PROPERTY).get(i));
            mDep = DEVICE_ID.matcher(partitionQueryMap.get(DEPENDENT_PROPERTY).get(i));
            if (!mAnt.matches() || !mDep.matches()) continue;
            MapUtil.createNewListIfAbsent(driveToPartitionMap, mAnt.group(1).replaceAll("\\\\\\\\", "\\\\")).add(mDep.group(1));
        }
        partitionQueryMap = WmiUtil.selectStringsFrom(null, "Win32_LogicalDiskToPartition", LOGICAL_DISK_TO_PARTITION_PROPERTIES, null);
        for (i = 0; i < partitionQueryMap.get(ANTECEDENT_PROPERTY).size(); ++i) {
            mAnt = DEVICE_ID.matcher(partitionQueryMap.get(ANTECEDENT_PROPERTY).get(i));
            mDep = DEVICE_ID.matcher(partitionQueryMap.get(DEPENDENT_PROPERTY).get(i));
            if (!mAnt.matches() || !mDep.matches()) continue;
            partitionToLogicalDriveMap.put(mAnt.group(1), mDep.group(1) + "\\");
        }
        Map<String, List<Object>> hwPartitionQueryMap = WmiUtil.selectObjectsFrom(null, "Win32_DiskPartition", PARTITION_PROPERTIES, null, PARTITION_TYPES);
        for (int i2 = 0; i2 < hwPartitionQueryMap.get(NAME_PROPERTY).size(); ++i2) {
            String deviceID = (String)hwPartitionQueryMap.get(DEVICE_ID_PROPERTY).get(i2);
            String logicalDrive = MapUtil.getOrDefault(partitionToLogicalDriveMap, deviceID, "");
            String uuid = "";
            if (!logicalDrive.isEmpty()) {
                char[] volumeChr = new char[255];
                Kernel32.INSTANCE.GetVolumeNameForVolumeMountPoint(logicalDrive, volumeChr, 255);
                uuid = ParseUtil.parseUuidOrDefault(new String(volumeChr).trim(), "");
            }
            partitionMap.put(deviceID, new HWPartition((String)hwPartitionQueryMap.get(NAME_PROPERTY).get(i2), (String)hwPartitionQueryMap.get(TYPE_PROPERTY).get(i2), (String)hwPartitionQueryMap.get(DESCRIPTION_PROPERTY).get(i2), uuid, ParseUtil.parseLongOrDefault((String)hwPartitionQueryMap.get(SIZE_PROPERTY).get(i2), 0L), ((Long)hwPartitionQueryMap.get(DISK_INDEX_PROPERTY).get(i2)).intValue(), ((Long)hwPartitionQueryMap.get(INDEX_PROPERTY).get(i2)).intValue(), logicalDrive));
        }
    }
}

