/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.solaris;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java8.util.function.Function;
import oshi.hardware.UsbDevice;
import oshi.hardware.common.AbstractUsbDevice;
import oshi.util.ExecutingCommand;
import oshi.util.MapUtil;
import oshi.util.ParseUtil;

public class SolarisUsbDevice
extends AbstractUsbDevice {
    private static final long serialVersionUID = 2L;
    private static Map<String, String> nameMap = new HashMap<String, String>();
    private static Map<String, String> vendorIdMap = new HashMap<String, String>();
    private static Map<String, String> productIdMap = new HashMap<String, String>();
    private static Map<String, List<String>> hubMap = new HashMap<String, List<String>>();
    private static Map<String, String> deviceTypeMap = new HashMap<String, String>();
    private static Map<Integer, String> lastParent = new HashMap<Integer, String>();

    public SolarisUsbDevice(String name, String vendor, String vendorId, String productId, String serialNumber, UsbDevice[] connectedDevices) {
        super(name, vendor, vendorId, productId, serialNumber, connectedDevices);
    }

    public static UsbDevice[] getUsbDevices(boolean tree) {
        UsbDevice[] devices = SolarisUsbDevice.getUsbDevices();
        if (tree) {
            return devices;
        }
        ArrayList<UsbDevice> deviceList = new ArrayList<UsbDevice>();
        for (UsbDevice device : devices) {
            deviceList.add(new SolarisUsbDevice(device.getName(), device.getVendor(), device.getVendorId(), device.getProductId(), device.getSerialNumber(), new SolarisUsbDevice[0]));
            SolarisUsbDevice.addDevicesToList(deviceList, device.getConnectedDevices());
        }
        return deviceList.toArray(new UsbDevice[deviceList.size()]);
    }

    private static void addDevicesToList(List<UsbDevice> deviceList, UsbDevice[] connectedDevices) {
        for (UsbDevice device : connectedDevices) {
            deviceList.add(device);
            SolarisUsbDevice.addDevicesToList(deviceList, device.getConnectedDevices());
        }
    }

    private static UsbDevice[] getUsbDevices() {
        nameMap.clear();
        vendorIdMap.clear();
        productIdMap.clear();
        hubMap.clear();
        List<String> devices = ExecutingCommand.runNative("prtconf -pv");
        if (devices.isEmpty()) {
            return new SolarisUsbDevice[0];
        }
        String key = "";
        int indent = 0;
        ArrayList<String> usbControllers = new ArrayList<String>();
        for (String line : devices) {
            if (line.contains("Node 0x")) {
                key = line.replaceFirst("^\\s*", "");
                int depth = line.length() - key.length();
                if (indent == 0) {
                    indent = depth;
                }
                lastParent.put(depth, key);
                if (depth > indent) {
                    MapUtil.computeIfAbsent(hubMap, lastParent.get(depth - indent), new Function<String, List<String>>(){

                        public List<String> apply(String k) {
                            return new ArrayList<String>();
                        }
                    }).add(key);
                    continue;
                }
                usbControllers.add(key);
                continue;
            }
            if (key.isEmpty()) continue;
            if ((line = line.trim()).startsWith("model:")) {
                nameMap.put(key, ParseUtil.getSingleQuoteStringValue(line));
                continue;
            }
            if (line.startsWith("name:")) {
                MapUtil.putIfAbsent(nameMap, key, ParseUtil.getSingleQuoteStringValue(line));
                continue;
            }
            if (line.startsWith("vendor-id:")) {
                if (line.length() <= 4) continue;
                vendorIdMap.put(key, line.substring(line.length() - 4));
                continue;
            }
            if (line.startsWith("device-id:")) {
                if (line.length() <= 4) continue;
                productIdMap.put(key, line.substring(line.length() - 4));
                continue;
            }
            if (!line.startsWith("device_type:")) continue;
            MapUtil.putIfAbsent(deviceTypeMap, key, ParseUtil.getSingleQuoteStringValue(line));
        }
        ArrayList<SolarisUsbDevice> controllerDevices = new ArrayList<SolarisUsbDevice>();
        for (String controller : usbControllers) {
            if (!"usb".equals(MapUtil.getOrDefault(deviceTypeMap, controller, ""))) continue;
            controllerDevices.add(SolarisUsbDevice.getDeviceAndChildren(controller, "0000", "0000"));
        }
        return controllerDevices.toArray(new UsbDevice[controllerDevices.size()]);
    }

    private static SolarisUsbDevice getDeviceAndChildren(String devPath, String vid, String pid) {
        String vendorId = MapUtil.getOrDefault(vendorIdMap, devPath, vid);
        String productId = MapUtil.getOrDefault(productIdMap, devPath, pid);
        List childPaths = MapUtil.getOrDefault(hubMap, devPath, new ArrayList());
        ArrayList<SolarisUsbDevice> usbDevices = new ArrayList<SolarisUsbDevice>();
        for (String path : childPaths) {
            usbDevices.add(SolarisUsbDevice.getDeviceAndChildren(path, vendorId, productId));
        }
        Collections.sort(usbDevices);
        return new SolarisUsbDevice(MapUtil.getOrDefault(nameMap, devPath, vendorId + ":" + productId), "", vendorId, productId, "", usbDevices.toArray(new UsbDevice[usbDevices.size()]));
    }
}

