/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.linux;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java8.util.function.Function;
import oshi.hardware.UsbDevice;
import oshi.hardware.common.AbstractUsbDevice;
import oshi.hardware.platform.mac.MacUsbDevice;
import oshi.jna.platform.linux.Udev;
import oshi.util.MapUtil;

public class LinuxUsbDevice
extends AbstractUsbDevice {
    private static final long serialVersionUID = 2L;
    private static Map<String, String> nameMap = new HashMap<String, String>();
    private static Map<String, String> vendorMap = new HashMap<String, String>();
    private static Map<String, String> vendorIdMap = new HashMap<String, String>();
    private static Map<String, String> productIdMap = new HashMap<String, String>();
    private static Map<String, String> serialMap = new HashMap<String, String>();
    private static Map<String, List<String>> hubMap = new HashMap<String, List<String>>();

    public LinuxUsbDevice(String name, String vendor, String vendorId, String productId, String serialNumber, UsbDevice[] connectedDevices) {
        super(name, vendor, vendorId, productId, serialNumber, connectedDevices);
    }

    public static UsbDevice[] getUsbDevices(boolean tree) {
        UsbDevice[] devices = LinuxUsbDevice.getUsbDevices();
        if (tree) {
            return devices;
        }
        ArrayList<UsbDevice> deviceList = new ArrayList<UsbDevice>();
        for (UsbDevice device : devices) {
            deviceList.add(new LinuxUsbDevice(device.getName(), device.getVendor(), device.getVendorId(), device.getProductId(), device.getSerialNumber(), new MacUsbDevice[0]));
            LinuxUsbDevice.addDevicesToList(deviceList, device.getConnectedDevices());
        }
        return deviceList.toArray(new UsbDevice[deviceList.size()]);
    }

    private static void addDevicesToList(List<UsbDevice> deviceList, UsbDevice[] connectedDevices) {
        for (UsbDevice device : connectedDevices) {
            deviceList.add(device);
            LinuxUsbDevice.addDevicesToList(deviceList, device.getConnectedDevices());
        }
    }

    private static UsbDevice[] getUsbDevices() {
        Udev.UdevHandle udev = Udev.INSTANCE.udev_new();
        Udev.UdevEnumerate enumerate = Udev.INSTANCE.udev_enumerate_new(udev);
        Udev.INSTANCE.udev_enumerate_add_match_subsystem(enumerate, "usb");
        Udev.INSTANCE.udev_enumerate_scan_devices(enumerate);
        Udev.UdevListEntry devices = Udev.INSTANCE.udev_enumerate_get_list_entry(enumerate);
        ArrayList<String> usbControllers = new ArrayList<String>();
        nameMap.clear();
        vendorMap.clear();
        vendorIdMap.clear();
        productIdMap.clear();
        serialMap.clear();
        hubMap.clear();
        Udev.UdevListEntry dev_list_entry = devices;
        while (dev_list_entry != null) {
            String path = Udev.INSTANCE.udev_list_entry_get_name(dev_list_entry);
            Udev.UdevDevice dev = Udev.INSTANCE.udev_device_new_from_syspath(udev, path);
            if ("usb_device".equals(Udev.INSTANCE.udev_device_get_devtype(dev))) {
                Udev.UdevDevice parent;
                String value = Udev.INSTANCE.udev_device_get_sysattr_value(dev, "product");
                if (value != null) {
                    nameMap.put(path, value);
                }
                if ((value = Udev.INSTANCE.udev_device_get_sysattr_value(dev, "manufacturer")) != null) {
                    vendorMap.put(path, value);
                }
                if ((value = Udev.INSTANCE.udev_device_get_sysattr_value(dev, "idVendor")) != null) {
                    vendorIdMap.put(path, value);
                }
                if ((value = Udev.INSTANCE.udev_device_get_sysattr_value(dev, "idProduct")) != null) {
                    productIdMap.put(path, value);
                }
                if ((value = Udev.INSTANCE.udev_device_get_sysattr_value(dev, "serial")) != null) {
                    serialMap.put(path, value);
                }
                if ((parent = Udev.INSTANCE.udev_device_get_parent_with_subsystem_devtype(dev, "usb", "usb_device")) == null) {
                    usbControllers.add(path);
                } else {
                    String parentPath = Udev.INSTANCE.udev_device_get_syspath(parent);
                    MapUtil.computeIfAbsent(hubMap, parentPath, new Function<String, List<String>>(){

                        public List<String> apply(String k) {
                            return new ArrayList<String>();
                        }
                    }).add(path);
                }
                Udev.INSTANCE.udev_device_unref(dev);
            }
            dev_list_entry = Udev.INSTANCE.udev_list_entry_get_next(dev_list_entry);
        }
        Udev.INSTANCE.udev_enumerate_unref(enumerate);
        Udev.INSTANCE.udev_unref(udev);
        ArrayList<LinuxUsbDevice> controllerDevices = new ArrayList<LinuxUsbDevice>();
        for (String controller : usbControllers) {
            controllerDevices.add(LinuxUsbDevice.getDeviceAndChildren(controller, "0000", "0000"));
        }
        return controllerDevices.toArray(new UsbDevice[controllerDevices.size()]);
    }

    private static LinuxUsbDevice getDeviceAndChildren(String devPath, String vid, String pid) {
        String vendorId = MapUtil.getOrDefault(vendorIdMap, devPath, vid);
        String productId = MapUtil.getOrDefault(productIdMap, devPath, pid);
        List childPaths = MapUtil.getOrDefault(hubMap, devPath, new ArrayList());
        ArrayList<LinuxUsbDevice> usbDevices = new ArrayList<LinuxUsbDevice>();
        for (String path : childPaths) {
            usbDevices.add(LinuxUsbDevice.getDeviceAndChildren(path, vendorId, productId));
        }
        Collections.sort(usbDevices);
        return new LinuxUsbDevice(MapUtil.getOrDefault(nameMap, devPath, vendorId + ":" + productId), MapUtil.getOrDefault(vendorMap, devPath, ""), vendorId, productId, MapUtil.getOrDefault(serialMap, devPath, ""), usbDevices.toArray(new UsbDevice[usbDevices.size()]));
    }
}

