/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java8.util.StringJoiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.SystemInfo;
import oshi.hardware.platform.linux.LinuxNetworks;
import oshi.hardware.platform.mac.MacNetworks;
import oshi.hardware.platform.unix.freebsd.FreeBsdNetworks;
import oshi.hardware.platform.unix.solaris.SolarisNetworks;
import oshi.hardware.platform.windows.WindowsNetworks;

public class NetworkIF
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final Logger LOG = LoggerFactory.getLogger(NetworkIF.class);
    private transient NetworkInterface networkInterface;
    private int mtu;
    private String mac;
    private String[] ipv4;
    private String[] ipv6;
    private long bytesRecv;
    private long bytesSent;
    private long packetsRecv;
    private long packetsSent;
    private long inErrors;
    private long outErrors;
    private long speed;
    private long timeStamp;

    public NetworkInterface getNetworkInterface() {
        return this.networkInterface;
    }

    public void setNetworkInterface(NetworkInterface networkInterface) {
        this.networkInterface = networkInterface;
        try {
            this.mtu = networkInterface.getMTU();
            byte[] hwmac = networkInterface.getHardwareAddress();
            if (hwmac != null) {
                StringJoiner sj = new StringJoiner((CharSequence)":");
                for (byte b : hwmac) {
                    sj.add((CharSequence)String.format("%02x", b));
                }
                this.mac = sj.toString();
            } else {
                this.mac = "Unknown";
            }
            ArrayList<String> ipv4list = new ArrayList<String>();
            ArrayList<String> ipv6list = new ArrayList<String>();
            for (InetAddress address : Collections.list(networkInterface.getInetAddresses())) {
                if (address.getHostAddress().length() == 0) continue;
                if (address.getHostAddress().contains(":")) {
                    ipv6list.add(address.getHostAddress().split("%")[0]);
                    continue;
                }
                ipv4list.add(address.getHostAddress());
            }
            this.ipv4 = ipv4list.toArray(new String[ipv4list.size()]);
            this.ipv6 = ipv6list.toArray(new String[ipv6list.size()]);
        }
        catch (SocketException e) {
            LOG.error("Socket exception: {}", (Throwable)e);
            return;
        }
    }

    public String getName() {
        return this.networkInterface.getName();
    }

    public String getDisplayName() {
        return this.networkInterface.getDisplayName();
    }

    public int getMTU() {
        return this.mtu;
    }

    public String getMacaddr() {
        return this.mac;
    }

    public String[] getIPv4addr() {
        return Arrays.copyOf(this.ipv4, this.ipv4.length);
    }

    public String[] getIPv6addr() {
        return Arrays.copyOf(this.ipv6, this.ipv6.length);
    }

    public long getBytesRecv() {
        return this.bytesRecv;
    }

    public void setBytesRecv(long bytesRecv) {
        this.bytesRecv = bytesRecv;
    }

    public long getBytesSent() {
        return this.bytesSent;
    }

    public void setBytesSent(long bytesSent) {
        this.bytesSent = bytesSent;
    }

    public long getPacketsRecv() {
        return this.packetsRecv;
    }

    public void setPacketsRecv(long packetsRecv) {
        this.packetsRecv = packetsRecv;
    }

    public long getPacketsSent() {
        return this.packetsSent;
    }

    public void setPacketsSent(long packetsSent) {
        this.packetsSent = packetsSent;
    }

    public long getInErrors() {
        return this.inErrors;
    }

    public void setInErrors(long inErrors) {
        this.inErrors = inErrors;
    }

    public long getOutErrors() {
        return this.outErrors;
    }

    public void setOutErrors(long outErrors) {
        this.outErrors = outErrors;
    }

    public long getSpeed() {
        return this.speed;
    }

    public void setSpeed(long speed) {
        this.speed = speed;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public void updateNetworkStats() {
        switch (SystemInfo.getCurrentPlatformEnum()) {
            case WINDOWS: {
                WindowsNetworks.updateNetworkStats(this);
                break;
            }
            case LINUX: {
                LinuxNetworks.updateNetworkStats(this);
                break;
            }
            case MACOSX: {
                MacNetworks.updateNetworkStats(this);
                break;
            }
            case SOLARIS: {
                SolarisNetworks.updateNetworkStats(this);
                break;
            }
            case FREEBSD: {
                FreeBsdNetworks.updateNetworkStats(this);
                break;
            }
            default: {
                LOG.error("Unsupported platform. No update performed.");
            }
        }
    }
}

