/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.linux;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import oshi.hardware.Sensors;
import oshi.util.FileUtil;

public class LinuxSensors
implements Sensors {
    private static final long serialVersionUID = 1L;
    private static final String TEMP = "temp";
    private static final String FAN = "fan";
    private static final String VOLTAGE = "in";
    private static final String[] SENSORS = new String[]{"temp", "fan", "in"};
    private static final String HWMON = "/sys/class/hwmon/hwmon";
    private static final String THERMAL_ZONE = "/sys/class/thermal/thermal_zone";
    private Map<String, String> sensorsMap = new HashMap<String, String>();

    public LinuxSensors() {
        String[] stringArray = SENSORS;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String sensor;
            final String sensorPrefix = sensor = stringArray[i];
            this.getSensorFilesFromPath(HWMON, sensor, new FileFilter(){

                @Override
                public boolean accept(File f) {
                    try {
                        return f.getName().startsWith(sensorPrefix) && f.getName().endsWith("_input") && FileUtil.getIntFromFile(f.getCanonicalPath()) > 0;
                    }
                    catch (IOException e) {
                        return false;
                    }
                }
            });
        }
        if (!this.sensorsMap.containsKey(TEMP)) {
            this.getSensorFilesFromPath(THERMAL_ZONE, TEMP, new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.getName().equals(LinuxSensors.TEMP);
                }
            });
        }
    }

    private void getSensorFilesFromPath(String sensorPath, String sensor, FileFilter sensorFileFilter) {
        int i = 0;
        String path = sensorPath + i;
        File dir = new File(path);
        while (dir.isDirectory()) {
            File[] matchingFiles = dir.listFiles(sensorFileFilter);
            if (matchingFiles != null && matchingFiles.length > 0) {
                this.sensorsMap.put(sensor, String.format("%s/%s", path, sensor));
            }
            dir = new File(sensorPath + ++i);
        }
    }

    @Override
    public double getCpuTemperature() {
        long millidegrees = 0L;
        if (!this.sensorsMap.containsKey(TEMP)) {
            return 0.0;
        }
        String hwmon = this.sensorsMap.get(TEMP);
        if (hwmon.contains("hwmon")) {
            millidegrees = FileUtil.getLongFromFile(String.format("%s1_input", hwmon));
            if (millidegrees > 0L) {
                return (double)millidegrees / 1000.0;
            }
            long sum = 0L;
            int count = 0;
            for (int i = 2; i <= 6; ++i) {
                millidegrees = FileUtil.getLongFromFile(String.format("%s%d_input", hwmon, i));
                if (millidegrees <= 0L) continue;
                sum += millidegrees;
                ++count;
            }
            if (count > 0) {
                return (double)sum / ((double)count * 1000.0);
            }
        } else if (hwmon.contains("thermal_zone") && (millidegrees = FileUtil.getLongFromFile(hwmon)) > 0L) {
            return (double)millidegrees / 1000.0;
        }
        return 0.0;
    }

    @Override
    public int[] getFanSpeeds() {
        if (this.sensorsMap.containsKey(FAN)) {
            String fanPath;
            String hwmon = this.sensorsMap.get(FAN);
            ArrayList<Integer> speeds = new ArrayList<Integer>();
            int fan = 1;
            while (new File(fanPath = String.format("%s%d_input", hwmon, fan)).exists()) {
                speeds.add(FileUtil.getIntFromFile(fanPath));
                ++fan;
            }
            int[] fanSpeeds = new int[speeds.size()];
            for (int i = 0; i < speeds.size(); ++i) {
                fanSpeeds[i] = (Integer)speeds.get(i);
            }
            return fanSpeeds;
        }
        return new int[0];
    }

    @Override
    public double getCpuVoltage() {
        if (this.sensorsMap.containsKey(VOLTAGE)) {
            String hwmon = this.sensorsMap.get(VOLTAGE);
            return (double)FileUtil.getIntFromFile(String.format("%s1_input", hwmon)) / 1000.0;
        }
        return 0.0;
    }
}

