/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.freebsd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oshi.hardware.SoundCard;
import oshi.hardware.common.AbstractSoundCard;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;

public class FreeBsdSoundCard
extends AbstractSoundCard {
    private static final String LSHAL = "lshal";
    private static Map<String, String> vendorMap = new HashMap<String, String>();
    private static Map<String, String> productMap = new HashMap<String, String>();

    public FreeBsdSoundCard(String kernelVersion, String name, String codec) {
        super(kernelVersion, name, codec);
    }

    public static List<SoundCard> getSoundCards() {
        vendorMap.clear();
        productMap.clear();
        ArrayList<String> sounds = new ArrayList<String>();
        String key = "";
        for (String line : ExecutingCommand.runNative(LSHAL)) {
            if (line.startsWith("udi =")) {
                key = ParseUtil.getSingleQuoteStringValue(line);
                continue;
            }
            if (key.isEmpty() || (line = line.trim()).isEmpty()) continue;
            if (line.contains("freebsd.driver =") && "pcm".equals(ParseUtil.getSingleQuoteStringValue(line))) {
                sounds.add(key);
                continue;
            }
            if (line.contains("info.product")) {
                productMap.put(key, ParseUtil.getStringBetween(line, '\''));
                continue;
            }
            if (!line.contains("info.vendor")) continue;
            vendorMap.put(key, ParseUtil.getStringBetween(line, '\''));
        }
        ArrayList<SoundCard> soundCards = new ArrayList<SoundCard>();
        for (String _key : sounds) {
            soundCards.add(new FreeBsdSoundCard(productMap.get(_key), vendorMap.get(_key) + " " + productMap.get(_key), productMap.get(_key)));
        }
        return soundCards;
    }
}

