/*
 * Decompiled with CFR 0.152.
 */
package oshi.ffm.windows;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SymbolLookup;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.util.Optional;
import oshi.ffm.windows.WindowsForeignFunctions;

public final class Advapi32FFM
extends WindowsForeignFunctions {
    private static final SymbolLookup ADV = Advapi32FFM.lib("Advapi32");
    private static final MethodHandle AdjustTokenPrivileges = Advapi32FFM.downcall(ADV, "AdjustTokenPrivileges", ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS);
    private static final MethodHandle CloseEventLog = Advapi32FFM.downcall(ADV, "CloseEventLog", ValueLayout.JAVA_INT, ValueLayout.ADDRESS);
    private static final MethodHandle GetTokenInformation = Advapi32FFM.downcall(ADV, "GetTokenInformation", ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.JAVA_INT, ValueLayout.ADDRESS);
    private static final MethodHandle LookupPrivilegeValue = Advapi32FFM.downcall(ADV, "LookupPrivilegeValueW", ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS);
    private static final MethodHandle OpenEventLog = Advapi32FFM.downcall(ADV, "OpenEventLogW", ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS);
    private static final MethodHandle OpenProcessToken = Advapi32FFM.downcall(ADV, "OpenProcessToken", ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.JAVA_INT, ValueLayout.ADDRESS);
    private static final MethodHandle ReadEventLog = Advapi32FFM.downcall(ADV, "ReadEventLogW", ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS);

    public static boolean AdjustTokenPrivileges(MemorySegment hToken, MemorySegment tkp) throws Throwable {
        return Advapi32FFM.isSuccess(AdjustTokenPrivileges.invokeExact(hToken, 0, tkp, 0, MemorySegment.NULL, MemorySegment.NULL));
    }

    public static boolean CloseEventLog(MemorySegment hEventLog) throws Throwable {
        return Advapi32FFM.isSuccess(CloseEventLog.invokeExact(hEventLog));
    }

    public static boolean GetTokenInformation(MemorySegment hToken, int tokenInfoClass, MemorySegment tokenInfo, int tokenInfoLength, MemorySegment returnLength) throws Throwable {
        return Advapi32FFM.isSuccess(GetTokenInformation.invokeExact(hToken, tokenInfoClass, tokenInfo, tokenInfoLength, returnLength));
    }

    public static boolean LookupPrivilegeValue(String name, MemorySegment luid, Arena arena) throws Throwable {
        MemorySegment nameSeg = Advapi32FFM.toWideString(arena, name);
        return Advapi32FFM.isSuccess(LookupPrivilegeValue.invokeExact(MemorySegment.NULL, nameSeg, luid));
    }

    public static Optional<MemorySegment> OpenEventLog(MemorySegment serverName, MemorySegment sourceName) throws Throwable {
        MemorySegment handle = OpenEventLog.invokeExact(serverName, sourceName);
        if (handle == null || handle.equals(MemorySegment.NULL)) {
            return Optional.empty();
        }
        return Optional.of(handle);
    }

    public static Optional<MemorySegment> OpenEventLog(Arena arena, String source) {
        try {
            MemorySegment lpSource = WindowsForeignFunctions.toWideString(arena, source);
            MemorySegment handle = OpenEventLog.invokeExact(MemorySegment.NULL, lpSource);
            if (handle.address() == 0L) {
                return Optional.empty();
            }
            return Optional.of(handle);
        }
        catch (Throwable t) {
            return Optional.empty();
        }
    }

    public static boolean OpenProcessToken(MemorySegment process, int desiredAccess, MemorySegment hTokenOut) throws Throwable {
        return Advapi32FFM.isSuccess(OpenProcessToken.invokeExact(process, desiredAccess, hTokenOut));
    }

    public static boolean ReadEventLog(MemorySegment hEventLog, int flags, MemorySegment buffer, int bufSize, MemorySegment bytesRead, MemorySegment minBytesNeeded) throws Throwable {
        return Advapi32FFM.isSuccess(ReadEventLog.invokeExact(hEventLog, flags, 0, buffer, bufSize, bytesRead, minBytesNeeded));
    }
}

