/*
 * Decompiled with CFR 0.152.
 */
package com.osama.firecrasher;

import android.os.Binder;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.MessageQueue;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class FireLooper
implements Runnable {
    private static final Object EXIT = new Object();
    private static final ThreadLocal<FireLooper> RUNNINGS = new ThreadLocal();
    private static Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private static Handler handler;

    public static void install() {
        handler.removeMessages(0, EXIT);
        handler.post((Runnable)new FireLooper());
    }

    public static void uninstallDelay(long millis) {
        handler.removeMessages(0, EXIT);
        handler.sendMessageDelayed(handler.obtainMessage(0, EXIT), millis);
    }

    public static void uninstall() {
        FireLooper.uninstallDelay(0L);
    }

    public static boolean isSafe() {
        return RUNNINGS.get() != null;
    }

    public static void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler h) {
        uncaughtExceptionHandler = h;
    }

    @Override
    public void run() {
        Field target;
        Method next;
        if (RUNNINGS.get() != null) {
            return;
        }
        try {
            Method m = MessageQueue.class.getDeclaredMethod("next", new Class[0]);
            m.setAccessible(true);
            next = m;
            Field f = Message.class.getDeclaredField("target");
            f.setAccessible(true);
            target = f;
        }
        catch (Exception e) {
            return;
        }
        RUNNINGS.set(this);
        MessageQueue queue = Looper.myQueue();
        Binder.clearCallingIdentity();
        try {
            Message msg;
            while ((msg = (Message)next.invoke((Object)queue, new Object[0])) != null && msg.obj != EXIT) {
                Handler h = (Handler)target.get(msg);
                h.dispatchMessage(msg);
                Binder.clearCallingIdentity();
                int currentapiVersion = Build.VERSION.SDK_INT;
                if (currentapiVersion >= 21) continue;
                msg.recycle();
            }
        }
        catch (InvocationTargetException e) {
            Thread.UncaughtExceptionHandler h = uncaughtExceptionHandler;
            Throwable ex = e;
            ex = e.getCause();
            if (ex == null) {
                ex = e;
            }
            if (h != null) {
                h.uncaughtException(Thread.currentThread(), ex);
            }
            new Handler().post((Runnable)this);
        }
        catch (Exception e) {
            Thread.UncaughtExceptionHandler h = uncaughtExceptionHandler;
            Exception ex = e;
            if (h != null) {
                h.uncaughtException(Thread.currentThread(), ex);
            }
            new Handler().post((Runnable)this);
        }
        RUNNINGS.set(null);
    }

    static {
        handler = new Handler(Looper.getMainLooper());
    }
}

