/*
 * Decompiled with CFR 0.152.
 */
package com.osama.firecrasher;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Application;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.util.Log;
import com.osama.firecrasher.CrashInterface;
import com.osama.firecrasher.CrashListener;
import com.osama.firecrasher.FireCrasher;

public final class CrashHandler
implements Thread.UncaughtExceptionHandler {
    private Activity activity;
    private Application.ActivityLifecycleCallbacks lifecycleCallbacks = new Application.ActivityLifecycleCallbacks(){

        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
            CrashHandler.this.activity = activity;
        }

        public void onActivityStarted(Activity activity) {
        }

        public void onActivityResumed(Activity activity) {
        }

        public void onActivityPaused(Activity activity) {
        }

        public void onActivityStopped(Activity activity) {
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        }

        public void onActivityDestroyed(Activity activity) {
        }
    };
    private CrashListener crashListener;
    private CrashInterface crashInterface;

    public void setCrashListener(CrashListener crashListener) {
        this.crashListener = crashListener;
    }

    public void setCrashInterface(CrashInterface crashListener) {
        this.crashInterface = crashListener;
    }

    @Override
    public void uncaughtException(Thread thread, final Throwable throwable) {
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (CrashHandler.this.crashListener != null) {
                    CrashHandler.this.crashListener.onCrash(throwable, CrashHandler.this.activity);
                } else if (CrashHandler.this.crashInterface != null) {
                    CrashHandler.this.crashInterface.onCrash(throwable, CrashHandler.this.activity);
                } else {
                    AlertDialog alertDialog = new AlertDialog.Builder((Context)CrashHandler.this.activity).create();
                    alertDialog.setTitle((CharSequence)"Crash");
                    alertDialog.setMessage((CharSequence)throwable.getMessage());
                    alertDialog.setButton(-1, (CharSequence)"Recover", new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            dialog.dismiss();
                            FireCrasher.recover(CrashHandler.this.activity);
                        }
                    });
                    alertDialog.show();
                }
            }
        });
        Log.e((String)"FireCrasher.err", (String)thread.getName(), (Throwable)throwable);
    }

    public Application.ActivityLifecycleCallbacks getLifecycleCallbacks() {
        return this.lifecycleCallbacks;
    }
}

