/*
 * Decompiled with CFR 0.152.
 */
package com.osama.firecrasher;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.util.Log;
import com.osama.firecrasher.CrashHandler;
import com.osama.firecrasher.CrashListener;
import com.osama.firecrasher.FireLooper;

public class FireCrasher {
    public static void install(Application application) {
        if (!FireLooper.isSafe()) {
            CrashHandler crashHandler = new CrashHandler();
            application.registerActivityLifecycleCallbacks(crashHandler.getLifecycleCallbacks());
            FireLooper.install();
            FireLooper.setUncaughtExceptionHandler(crashHandler);
            Thread.setDefaultUncaughtExceptionHandler(crashHandler);
        }
    }

    public static void install(Application application, CrashListener crashListener) {
        if (!FireLooper.isSafe()) {
            CrashHandler crashHandler = new CrashHandler();
            crashHandler.setCrashListener(crashListener);
            application.registerActivityLifecycleCallbacks(crashHandler.getLifecycleCallbacks());
            FireLooper.install();
            FireLooper.setUncaughtExceptionHandler(crashHandler);
            Thread.setDefaultUncaughtExceptionHandler(crashHandler);
        }
    }

    protected static void recover(Activity activity) {
        if (activity != null) {
            try {
                ActivityInfo[] list = activity.getPackageManager().getPackageInfo((String)activity.getPackageName(), (int)1).activities;
                if (list.length == 1 && list[0].name.equals(activity.getClass().getName())) {
                    activity.finish();
                    activity.startActivity(new Intent((Context)activity, activity.getClass()));
                } else {
                    activity.onBackPressed();
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.e((String)"FireCrasher", (String)e.getMessage());
            }
        }
    }
}

