/*
 * Decompiled with CFR 0.152.
 */
package com.osama.firecrasher;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.Application;
import android.os.Bundle;
import com.osama.firecrasher.CrashListener;
import java.util.List;

public final class CrashHandler
implements Thread.UncaughtExceptionHandler {
    private Activity activity;
    private Application.ActivityLifecycleCallbacks lifecycleCallbacks = new Application.ActivityLifecycleCallbacks(){

        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
            CrashHandler.this.activity = activity;
        }

        public void onActivityStarted(Activity activity) {
            CrashHandler.this.activity = activity;
        }

        public void onActivityResumed(Activity activity) {
            CrashHandler.this.activity = activity;
        }

        public void onActivityPaused(Activity activity) {
        }

        public void onActivityStopped(Activity activity) {
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        }

        public void onActivityDestroyed(Activity activity) {
        }
    };
    private CrashListener crashListener;

    CrashHandler() {
    }

    public Activity getActivity() {
        return this.activity;
    }

    void setCrashListener(CrashListener crashListener) {
        this.crashListener = crashListener;
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        this.activity.runOnUiThread(() -> {
            if (this.crashListener != null) {
                this.crashListener.onCrash(throwable);
            }
        });
    }

    Application.ActivityLifecycleCallbacks getLifecycleCallbacks() {
        return this.lifecycleCallbacks;
    }

    public int getBackStackCount() {
        if (this.activity == null) {
            return 0;
        }
        ActivityManager m = (ActivityManager)this.activity.getSystemService("activity");
        List runningTaskInfoList = m.getRunningTasks(10);
        int numOfActivities = 0;
        if (runningTaskInfoList.size() >= 1) {
            numOfActivities = ((ActivityManager.RunningTaskInfo)runningTaskInfoList.get((int)0)).numActivities;
        }
        return numOfActivities <= 0 ? 0 : numOfActivities - 1;
    }
}

