/*
 * Decompiled with CFR 0.152.
 */
package com.osama.firecrasher;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.util.Log;
import com.osama.firecrasher.CrashHandler;
import com.osama.firecrasher.CrashInterface;
import com.osama.firecrasher.CrashListener;
import com.osama.firecrasher.FireLooper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/osama/firecrasher/FireCrasher;", "", "()V", "retryCount", "", "getRetryCount", "()I", "setRetryCount", "(I)V", "install", "", "application", "Landroid/app/Application;", "crashListener", "Lcom/osama/firecrasher/CrashInterface;", "Lcom/osama/firecrasher/CrashListener;", "recover", "activity", "Landroid/app/Activity;", "restartApp", "firecrasher_release"})
public final class FireCrasher {
    private static int retryCount;
    public static final FireCrasher INSTANCE;

    public final int getRetryCount() {
        return retryCount;
    }

    public final void setRetryCount(int n) {
        retryCount = n;
    }

    public final void install(@NotNull Application application) {
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        if (!FireLooper.Companion.isSafe$firecrasher_release()) {
            CrashHandler crashHandler = new CrashHandler();
            application.registerActivityLifecycleCallbacks(crashHandler.getLifecycleCallbacks());
            FireLooper.Companion.install$firecrasher_release();
            FireLooper.Companion.setUncaughtExceptionHandler$firecrasher_release(crashHandler);
            Thread.setDefaultUncaughtExceptionHandler(crashHandler);
        }
    }

    public final void install(@NotNull Application application, @NotNull CrashListener crashListener) {
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        Intrinsics.checkParameterIsNotNull((Object)crashListener, (String)"crashListener");
        if (!FireLooper.Companion.isSafe$firecrasher_release()) {
            CrashHandler crashHandler = new CrashHandler();
            crashHandler.setCrashListener(crashListener);
            application.registerActivityLifecycleCallbacks(crashHandler.getLifecycleCallbacks());
            FireLooper.Companion.install$firecrasher_release();
            FireLooper.Companion.setUncaughtExceptionHandler$firecrasher_release(crashHandler);
            Thread.setDefaultUncaughtExceptionHandler(crashHandler);
        }
    }

    public final void install(@NotNull Application application, @NotNull CrashInterface crashListener) {
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        Intrinsics.checkParameterIsNotNull((Object)crashListener, (String)"crashListener");
        if (!FireLooper.Companion.isSafe$firecrasher_release()) {
            CrashHandler crashHandler = new CrashHandler();
            crashHandler.setCrashInterface(crashListener);
            application.registerActivityLifecycleCallbacks(crashHandler.getLifecycleCallbacks());
            FireLooper.Companion.install$firecrasher_release();
            FireLooper.Companion.setUncaughtExceptionHandler$firecrasher_release(crashHandler);
            Thread.setDefaultUncaughtExceptionHandler(crashHandler);
        }
    }

    public final void recover(@Nullable Activity activity) {
        if (activity != null) {
            Intent intent = new Intent((Context)activity, activity.getClass());
            activity.overridePendingTransition(0, 0);
            intent.addFlags(65536);
            if (CrashHandler.getBackStackCount(activity) >= 1) {
                if (retryCount <= 3) {
                    Log.d((String)FireCrasher.class.getSimpleName(), (String)("retryCount :" + ++retryCount));
                    activity.startActivity(intent);
                    activity.finish();
                } else {
                    retryCount = 0;
                    activity.onBackPressed();
                }
            } else if (retryCount <= 3) {
                Log.d((String)FireCrasher.class.getSimpleName(), (String)("retryCount :" + ++retryCount));
                activity.startActivity(intent);
                activity.finish();
            } else {
                retryCount = 0;
                this.restartApp(activity);
                activity.finish();
            }
        }
    }

    private final void restartApp(Activity activity) {
        Context context = activity.getBaseContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"activity.baseContext");
        PackageManager packageManager = context.getPackageManager();
        Context context2 = activity.getBaseContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"activity.baseContext");
        Intent i = packageManager.getLaunchIntentForPackage(context2.getPackageName());
        if (i != null) {
            i.addFlags(0x4000000);
            activity.startActivity(i);
        }
    }

    private FireCrasher() {
    }

    static {
        FireCrasher fireCrasher;
        INSTANCE = fireCrasher = new FireCrasher();
    }
}

