/*
 * Decompiled with CFR 0.152.
 */
package com.osama.firecrasher;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.AlertDialog;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import com.osama.firecrasher.CrashInterface;
import com.osama.firecrasher.CrashListener;
import com.osama.firecrasher.FireCrasher;
import java.util.List;

public final class CrashHandler
implements Thread.UncaughtExceptionHandler {
    private Activity activity;
    private Application.ActivityLifecycleCallbacks lifecycleCallbacks = new Application.ActivityLifecycleCallbacks(){

        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
            CrashHandler.this.activity = activity;
        }

        public void onActivityStarted(Activity activity) {
        }

        public void onActivityResumed(Activity activity) {
        }

        public void onActivityPaused(Activity activity) {
        }

        public void onActivityStopped(Activity activity) {
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        }

        public void onActivityDestroyed(Activity activity) {
        }
    };
    private CrashListener crashListener;
    private CrashInterface crashInterface;

    CrashHandler() {
    }

    void setCrashListener(CrashListener crashListener) {
        this.crashListener = crashListener;
    }

    void setCrashInterface(CrashInterface crashListener) {
        this.crashInterface = crashListener;
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        this.activity.runOnUiThread(() -> {
            if (this.crashListener != null) {
                this.crashListener.onCrash(throwable, this.activity);
            } else if (this.crashInterface != null) {
                this.crashInterface.onCrash(throwable, this.activity);
            } else {
                AlertDialog alertDialog = new AlertDialog.Builder((Context)this.activity).create();
                alertDialog.setTitle((CharSequence)"Crash");
                alertDialog.setMessage((CharSequence)throwable.getMessage());
                alertDialog.setButton(-1, (CharSequence)"Recover", (dialog, which) -> {
                    dialog.dismiss();
                    FireCrasher.INSTANCE.recover(this.activity);
                });
                alertDialog.show();
            }
        });
        Log.e((String)"FireCrasher.err", (String)thread.getName(), (Throwable)throwable);
    }

    Application.ActivityLifecycleCallbacks getLifecycleCallbacks() {
        return this.lifecycleCallbacks;
    }

    public static int getBackStackCount(Activity activity) {
        ActivityManager m = (ActivityManager)activity.getSystemService("activity");
        List runningTaskInfoList = m.getRunningTasks(10);
        int numOfActivities = 0;
        for (ActivityManager.RunningTaskInfo runningTaskInfo : runningTaskInfoList) {
            int id = runningTaskInfo.id;
            CharSequence desc = runningTaskInfo.description;
            numOfActivities = runningTaskInfo.numActivities;
            String string = runningTaskInfo.topActivity.getShortClassName();
        }
        return numOfActivities <= 0 ? 0 : numOfActivities - 1;
    }
}

