/*
 * Decompiled with CFR 0.152.
 */
package com.osama.firecrasher;

import android.os.Binder;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.MessageQueue;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class FireLooper
implements Runnable {
    private static Object EXIT = new Object();
    private static ThreadLocal<FireLooper> FIRE_LOOPER_THREAD_LOCAL = new ThreadLocal();
    private static Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private static Handler handler;

    static void install() {
        handler.removeMessages(0, EXIT);
        handler.post((Runnable)new FireLooper());
    }

    static boolean isSafe() {
        return FIRE_LOOPER_THREAD_LOCAL.get() != null;
    }

    static void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler h) {
        uncaughtExceptionHandler = h;
    }

    @Override
    public void run() {
        Field target;
        Method next;
        if (FIRE_LOOPER_THREAD_LOCAL.get() != null) {
            return;
        }
        try {
            Method method = MessageQueue.class.getDeclaredMethod("next", new Class[0]);
            method.setAccessible(true);
            next = method;
            Field field = Message.class.getDeclaredField("target");
            field.setAccessible(true);
            target = field;
        }
        catch (Exception e) {
            return;
        }
        FIRE_LOOPER_THREAD_LOCAL.set(this);
        MessageQueue queue = Looper.myQueue();
        Binder.clearCallingIdentity();
        try {
            Message message;
            while ((message = (Message)next.invoke((Object)queue, new Object[0])) != null && message.obj != EXIT) {
                Handler handler = (Handler)target.get(message);
                handler.dispatchMessage(message);
                Binder.clearCallingIdentity();
                int currentVersion = Build.VERSION.SDK_INT;
                if (currentVersion >= 21) continue;
                message.recycle();
            }
        }
        catch (InvocationTargetException exception) {
            Thread.UncaughtExceptionHandler exceptionHandler = uncaughtExceptionHandler;
            Throwable throwable = exception.getCause();
            if (throwable == null) {
                throwable = exception;
            }
            if (exceptionHandler != null) {
                exceptionHandler.uncaughtException(Thread.currentThread(), throwable);
            }
            new Handler().post((Runnable)this);
        }
        catch (Exception e) {
            Thread.UncaughtExceptionHandler exceptionHandler = uncaughtExceptionHandler;
            if (exceptionHandler != null) {
                exceptionHandler.uncaughtException(Thread.currentThread(), e);
            }
            new Handler().post((Runnable)this);
        }
        FIRE_LOOPER_THREAD_LOCAL.set(null);
    }

    static {
        handler = new Handler(Looper.getMainLooper());
    }
}

