/*
 * Decompiled with CFR 0.152.
 */
package mf.org.apache.xml.serialize;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import mf.org.apache.xerces.dom.CoreDocumentImpl;
import mf.org.apache.xerces.dom.DOMErrorImpl;
import mf.org.apache.xerces.dom.DOMLocatorImpl;
import mf.org.apache.xerces.dom.DOMMessageFormatter;
import mf.org.apache.xerces.dom.DOMNormalizer;
import mf.org.apache.xerces.dom.DOMStringListImpl;
import mf.org.apache.xerces.impl.XMLEntityManager;
import mf.org.apache.xerces.util.DOMUtil;
import mf.org.apache.xerces.util.NamespaceSupport;
import mf.org.apache.xerces.util.SymbolTable;
import mf.org.apache.xerces.util.XML11Char;
import mf.org.apache.xerces.util.XMLChar;
import mf.org.apache.xml.serialize.XML11Serializer;
import mf.org.apache.xml.serialize.XMLSerializer;
import mf.org.w3c.dom.Attr;
import mf.org.w3c.dom.Comment;
import mf.org.w3c.dom.DOMConfiguration;
import mf.org.w3c.dom.DOMErrorHandler;
import mf.org.w3c.dom.DOMException;
import mf.org.w3c.dom.DOMStringList;
import mf.org.w3c.dom.Document;
import mf.org.w3c.dom.DocumentFragment;
import mf.org.w3c.dom.Element;
import mf.org.w3c.dom.NamedNodeMap;
import mf.org.w3c.dom.Node;
import mf.org.w3c.dom.ProcessingInstruction;
import mf.org.w3c.dom.ls.LSException;
import mf.org.w3c.dom.ls.LSOutput;
import mf.org.w3c.dom.ls.LSSerializer;
import mf.org.w3c.dom.ls.LSSerializerFilter;

public class DOMSerializerImpl
implements LSSerializer,
DOMConfiguration {
    private XMLSerializer serializer;
    private XML11Serializer xml11Serializer;
    private DOMStringList fRecognizedParameters;
    protected short features = 0;
    protected static final short NAMESPACES = 1;
    protected static final short WELLFORMED = 2;
    protected static final short ENTITIES = 4;
    protected static final short CDATA = 8;
    protected static final short SPLITCDATA = 16;
    protected static final short COMMENTS = 32;
    protected static final short DISCARDDEFAULT = 64;
    protected static final short INFOSET = 128;
    protected static final short XMLDECL = 256;
    protected static final short NSDECL = 512;
    protected static final short DOM_ELEMENT_CONTENT_WHITESPACE = 1024;
    protected static final short PRETTY_PRINT = 2048;
    private DOMErrorHandler fErrorHandler = null;
    private final DOMErrorImpl fError = new DOMErrorImpl();
    private final DOMLocatorImpl fLocator = new DOMLocatorImpl();

    public DOMSerializerImpl() {
        this.features = (short)(this.features | 1);
        this.features = (short)(this.features | 4);
        this.features = (short)(this.features | 0x20);
        this.features = (short)(this.features | 8);
        this.features = (short)(this.features | 0x10);
        this.features = (short)(this.features | 2);
        this.features = (short)(this.features | 0x200);
        this.features = (short)(this.features | 0x400);
        this.features = (short)(this.features | 0x40);
        this.features = (short)(this.features | 0x100);
        this.serializer = new XMLSerializer();
        this.initSerializer(this.serializer);
    }

    public DOMConfiguration getDomConfig() {
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setParameter(String name, Object value) throws DOMException {
        if (value instanceof Boolean) {
            boolean state = (Boolean)value;
            if (name.equalsIgnoreCase("infoset")) {
                if (!state) return;
                this.features = (short)(this.features & 0xFFFFFFFB);
                this.features = (short)(this.features & 0xFFFFFFF7);
                this.features = (short)(this.features | 1);
                this.features = (short)(this.features | 0x200);
                this.features = (short)(this.features | 2);
                this.features = (short)(this.features | 0x20);
                return;
            }
            if (name.equalsIgnoreCase("xml-declaration")) {
                this.features = (short)(state ? this.features | 0x100 : this.features & 0xFFFFFEFF);
                return;
            }
            if (name.equalsIgnoreCase("namespaces")) {
                this.features = (short)(state ? this.features | 1 : this.features & 0xFFFFFFFE);
                this.serializer.fNamespaces = state;
                return;
            }
            if (name.equalsIgnoreCase("split-cdata-sections")) {
                this.features = (short)(state ? this.features | 0x10 : this.features & 0xFFFFFFEF);
                return;
            }
            if (name.equalsIgnoreCase("discard-default-content")) {
                this.features = (short)(state ? this.features | 0x40 : this.features & 0xFFFFFFBF);
                return;
            }
            if (name.equalsIgnoreCase("well-formed")) {
                this.features = (short)(state ? this.features | 2 : this.features & 0xFFFFFFFD);
                return;
            }
            if (name.equalsIgnoreCase("entities")) {
                this.features = (short)(state ? this.features | 4 : this.features & 0xFFFFFFFB);
                return;
            }
            if (name.equalsIgnoreCase("cdata-sections")) {
                this.features = (short)(state ? this.features | 8 : this.features & 0xFFFFFFF7);
                return;
            }
            if (name.equalsIgnoreCase("comments")) {
                this.features = (short)(state ? this.features | 0x20 : this.features & 0xFFFFFFDF);
                return;
            }
            if (name.equalsIgnoreCase("format-pretty-print")) {
                this.features = (short)(state ? this.features | 0x800 : this.features & 0xFFFFF7FF);
                return;
            }
            if (name.equalsIgnoreCase("canonical-form") || name.equalsIgnoreCase("validate-if-schema") || name.equalsIgnoreCase("validate") || name.equalsIgnoreCase("check-character-normalization") || name.equalsIgnoreCase("datatype-normalization") || name.equalsIgnoreCase("normalize-characters")) {
                if (!state) return;
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{name});
                throw new DOMException(9, msg);
            }
            if (name.equalsIgnoreCase("namespace-declarations")) {
                this.features = (short)(state ? this.features | 0x200 : this.features & 0xFFFFFDFF);
                this.serializer.fNamespacePrefixes = state;
                return;
            }
            if (!name.equalsIgnoreCase("element-content-whitespace") && !name.equalsIgnoreCase("ignore-unknown-character-denormalizations")) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_FOUND", new Object[]{name});
                throw new DOMException(9, msg);
            }
            if (state) return;
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{name});
            throw new DOMException(9, msg);
        }
        if (name.equalsIgnoreCase("error-handler")) {
            if (value != null && !(value instanceof DOMErrorHandler)) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "TYPE_MISMATCH_ERR", new Object[]{name});
                throw new DOMException(17, msg);
            }
            this.fErrorHandler = (DOMErrorHandler)value;
            return;
        }
        if (name.equalsIgnoreCase("resource-resolver") || name.equalsIgnoreCase("schema-location") || name.equalsIgnoreCase("schema-type") && value != null) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{name});
            throw new DOMException(9, msg);
        }
        String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_FOUND", new Object[]{name});
        throw new DOMException(8, msg);
    }

    public boolean canSetParameter(String name, Object state) {
        if (state == null) {
            return true;
        }
        if (state instanceof Boolean) {
            boolean value = (Boolean)state;
            if (name.equalsIgnoreCase("namespaces") || name.equalsIgnoreCase("split-cdata-sections") || name.equalsIgnoreCase("discard-default-content") || name.equalsIgnoreCase("xml-declaration") || name.equalsIgnoreCase("well-formed") || name.equalsIgnoreCase("infoset") || name.equalsIgnoreCase("entities") || name.equalsIgnoreCase("cdata-sections") || name.equalsIgnoreCase("comments") || name.equalsIgnoreCase("format-pretty-print") || name.equalsIgnoreCase("namespace-declarations")) {
                return true;
            }
            if (name.equalsIgnoreCase("canonical-form") || name.equalsIgnoreCase("validate-if-schema") || name.equalsIgnoreCase("validate") || name.equalsIgnoreCase("check-character-normalization") || name.equalsIgnoreCase("datatype-normalization") || name.equalsIgnoreCase("normalize-characters")) {
                return !value;
            }
            if (name.equalsIgnoreCase("element-content-whitespace") || name.equalsIgnoreCase("ignore-unknown-character-denormalizations")) {
                return value;
            }
        } else if (name.equalsIgnoreCase("error-handler") && state == null || state instanceof DOMErrorHandler) {
            return true;
        }
        return false;
    }

    public DOMStringList getParameterNames() {
        if (this.fRecognizedParameters == null) {
            ArrayList<String> parameters = new ArrayList<String>();
            parameters.add("namespaces");
            parameters.add("split-cdata-sections");
            parameters.add("discard-default-content");
            parameters.add("xml-declaration");
            parameters.add("canonical-form");
            parameters.add("validate-if-schema");
            parameters.add("validate");
            parameters.add("check-character-normalization");
            parameters.add("datatype-normalization");
            parameters.add("format-pretty-print");
            parameters.add("normalize-characters");
            parameters.add("well-formed");
            parameters.add("infoset");
            parameters.add("namespace-declarations");
            parameters.add("element-content-whitespace");
            parameters.add("entities");
            parameters.add("cdata-sections");
            parameters.add("comments");
            parameters.add("ignore-unknown-character-denormalizations");
            parameters.add("error-handler");
            this.fRecognizedParameters = new DOMStringListImpl(parameters);
        }
        return this.fRecognizedParameters;
    }

    public Object getParameter(String name) throws DOMException {
        if (name.equalsIgnoreCase("comments")) {
            return (this.features & 0x20) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equalsIgnoreCase("namespaces")) {
            return (this.features & 1) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equalsIgnoreCase("xml-declaration")) {
            return (this.features & 0x100) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equalsIgnoreCase("cdata-sections")) {
            return (this.features & 8) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equalsIgnoreCase("entities")) {
            return (this.features & 4) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equalsIgnoreCase("split-cdata-sections")) {
            return (this.features & 0x10) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equalsIgnoreCase("well-formed")) {
            return (this.features & 2) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equalsIgnoreCase("namespace-declarations")) {
            return (this.features & 0x200) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equalsIgnoreCase("element-content-whitespace") || name.equalsIgnoreCase("ignore-unknown-character-denormalizations")) {
            return Boolean.TRUE;
        }
        if (name.equalsIgnoreCase("discard-default-content")) {
            return (this.features & 0x40) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equalsIgnoreCase("format-pretty-print")) {
            return (this.features & 0x800) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equalsIgnoreCase("infoset")) {
            if ((this.features & 4) == 0 && (this.features & 8) == 0 && (this.features & 1) != 0 && (this.features & 0x200) != 0 && (this.features & 2) != 0 && (this.features & 0x20) != 0) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (name.equalsIgnoreCase("normalize-characters") || name.equalsIgnoreCase("canonical-form") || name.equalsIgnoreCase("validate-if-schema") || name.equalsIgnoreCase("check-character-normalization") || name.equalsIgnoreCase("validate") || name.equalsIgnoreCase("validate-if-schema") || name.equalsIgnoreCase("datatype-normalization")) {
            return Boolean.FALSE;
        }
        if (name.equalsIgnoreCase("error-handler")) {
            return this.fErrorHandler;
        }
        if (name.equalsIgnoreCase("resource-resolver") || name.equalsIgnoreCase("schema-location") || name.equalsIgnoreCase("schema-type")) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{name});
            throw new DOMException(9, msg);
        }
        String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_FOUND", new Object[]{name});
        throw new DOMException(8, msg);
    }

    public String writeToString(Node wnode) throws DOMException, LSException {
        StringWriter destination;
        block16: {
            XMLSerializer ser = null;
            String ver = this._getXmlVersion(wnode);
            if (ver != null && ver.equals("1.1")) {
                if (this.xml11Serializer == null) {
                    this.xml11Serializer = new XML11Serializer();
                    this.initSerializer(this.xml11Serializer);
                }
                this.copySettings(this.serializer, this.xml11Serializer);
                ser = this.xml11Serializer;
            } else {
                ser = this.serializer;
            }
            destination = new StringWriter();
            try {
                this.prepareForSerialization(ser, wnode);
                ser._format.setEncoding("UTF-16");
                ser.setOutputCharStream(destination);
                if (wnode.getNodeType() == 9) {
                    ser.serialize((Document)wnode);
                    break block16;
                }
                if (wnode.getNodeType() == 11) {
                    ser.serialize((DocumentFragment)wnode);
                    break block16;
                }
                if (wnode.getNodeType() == 1) {
                    ser.serialize((Element)wnode);
                    break block16;
                }
                String msg = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "unable-to-serialize-node", null);
                if (ser.fDOMErrorHandler != null) {
                    DOMErrorImpl error = new DOMErrorImpl();
                    error.fType = "unable-to-serialize-node";
                    error.fMessage = msg;
                    error.fSeverity = (short)3;
                    ser.fDOMErrorHandler.handleError(error);
                }
                throw new LSException(82, msg);
            }
            catch (LSException lse) {
                throw lse;
            }
            catch (RuntimeException e) {
                if (e == DOMNormalizer.abort) {
                    String error = null;
                    return error;
                }
                throw (LSException)DOMUtil.createLSException((short)82, e).fillInStackTrace();
            }
            catch (IOException ioe) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "STRING_TOO_LONG", new Object[]{ioe.getMessage()});
                throw new DOMException(2, msg);
            }
            finally {
                ser.clearDocumentState();
            }
        }
        return destination.toString();
    }

    public void setNewLine(String newLine) {
        this.serializer._format.setLineSeparator(newLine);
    }

    public String getNewLine() {
        return this.serializer._format.getLineSeparator();
    }

    public LSSerializerFilter getFilter() {
        return this.serializer.fDOMFilter;
    }

    public void setFilter(LSSerializerFilter filter) {
        this.serializer.fDOMFilter = filter;
    }

    private void initSerializer(XMLSerializer ser) {
        ser.fNSBinder = new NamespaceSupport();
        ser.fLocalNSBinder = new NamespaceSupport();
        ser.fSymbolTable = new SymbolTable();
    }

    private void copySettings(XMLSerializer src, XMLSerializer dest) {
        dest.fDOMErrorHandler = this.fErrorHandler;
        dest._format.setEncoding(src._format.getEncoding());
        dest._format.setLineSeparator(src._format.getLineSeparator());
        dest.fDOMFilter = src.fDOMFilter;
    }

    public boolean write(Node node, LSOutput destination) throws LSException {
        block26: {
            if (node == null) {
                return false;
            }
            XMLSerializer ser = null;
            String ver = this._getXmlVersion(node);
            if (ver != null && ver.equals("1.1")) {
                if (this.xml11Serializer == null) {
                    this.xml11Serializer = new XML11Serializer();
                    this.initSerializer(this.xml11Serializer);
                }
                this.copySettings(this.serializer, this.xml11Serializer);
                ser = this.xml11Serializer;
            } else {
                ser = this.serializer;
            }
            String encoding = null;
            encoding = destination.getEncoding();
            if (encoding == null && (encoding = this._getInputEncoding(node)) == null && (encoding = this._getXmlEncoding(node)) == null) {
                encoding = "UTF-8";
            }
            try {
                this.prepareForSerialization(ser, node);
                ser._format.setEncoding(encoding);
                OutputStream outputStream = destination.getByteStream();
                Writer writer = destination.getCharacterStream();
                String uri = destination.getSystemId();
                if (writer == null) {
                    if (outputStream == null) {
                        if (uri == null) {
                            String msg = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "no-output-specified", null);
                            if (ser.fDOMErrorHandler != null) {
                                DOMErrorImpl error = new DOMErrorImpl();
                                error.fType = "no-output-specified";
                                error.fMessage = msg;
                                error.fSeverity = (short)3;
                                ser.fDOMErrorHandler.handleError(error);
                            }
                            throw new LSException(82, msg);
                        }
                        ser.setOutputByteStream(XMLEntityManager.createOutputStream(uri));
                    } else {
                        ser.setOutputByteStream(outputStream);
                    }
                } else {
                    ser.setOutputCharStream(writer);
                }
                if (node.getNodeType() == 9) {
                    ser.serialize((Document)node);
                    break block26;
                }
                if (node.getNodeType() == 11) {
                    ser.serialize((DocumentFragment)node);
                    break block26;
                }
                if (node.getNodeType() == 1) {
                    ser.serialize((Element)node);
                    break block26;
                }
                boolean bl = false;
                return bl;
            }
            catch (UnsupportedEncodingException ue) {
                if (ser.fDOMErrorHandler != null) {
                    DOMErrorImpl error = new DOMErrorImpl();
                    error.fException = ue;
                    error.fType = "unsupported-encoding";
                    error.fMessage = ue.getMessage();
                    error.fSeverity = (short)3;
                    ser.fDOMErrorHandler.handleError(error);
                }
                throw new LSException(82, DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "unsupported-encoding", null));
            }
            catch (LSException lse) {
                throw lse;
            }
            catch (RuntimeException e) {
                if (e == DOMNormalizer.abort) {
                    boolean error = false;
                    return error;
                }
                throw (LSException)DOMUtil.createLSException((short)82, e).fillInStackTrace();
            }
            catch (Exception e) {
                if (ser.fDOMErrorHandler != null) {
                    DOMErrorImpl error = new DOMErrorImpl();
                    error.fException = e;
                    error.fMessage = e.getMessage();
                    error.fSeverity = (short)2;
                    ser.fDOMErrorHandler.handleError(error);
                }
                throw (LSException)DOMUtil.createLSException((short)82, e).fillInStackTrace();
            }
            finally {
                ser.clearDocumentState();
            }
        }
        return true;
    }

    public boolean writeToURI(Node node, String URI2) throws LSException {
        block18: {
            if (node == null) {
                return false;
            }
            XMLSerializer ser = null;
            String ver = this._getXmlVersion(node);
            if (ver != null && ver.equals("1.1")) {
                if (this.xml11Serializer == null) {
                    this.xml11Serializer = new XML11Serializer();
                    this.initSerializer(this.xml11Serializer);
                }
                this.copySettings(this.serializer, this.xml11Serializer);
                ser = this.xml11Serializer;
            } else {
                ser = this.serializer;
            }
            String encoding = this._getInputEncoding(node);
            if (encoding == null && (encoding = this._getXmlEncoding(node)) == null) {
                encoding = "UTF-8";
            }
            try {
                this.prepareForSerialization(ser, node);
                ser._format.setEncoding(encoding);
                ser.setOutputByteStream(XMLEntityManager.createOutputStream(URI2));
                if (node.getNodeType() == 9) {
                    ser.serialize((Document)node);
                    break block18;
                }
                if (node.getNodeType() == 11) {
                    ser.serialize((DocumentFragment)node);
                    break block18;
                }
                if (node.getNodeType() == 1) {
                    ser.serialize((Element)node);
                    break block18;
                }
                boolean bl = false;
                return bl;
            }
            catch (LSException lse) {
                throw lse;
            }
            catch (RuntimeException e) {
                if (e == DOMNormalizer.abort) {
                    boolean bl = false;
                    return bl;
                }
                throw (LSException)DOMUtil.createLSException((short)82, e).fillInStackTrace();
            }
            catch (Exception e) {
                if (ser.fDOMErrorHandler != null) {
                    DOMErrorImpl error = new DOMErrorImpl();
                    error.fException = e;
                    error.fMessage = e.getMessage();
                    error.fSeverity = (short)2;
                    ser.fDOMErrorHandler.handleError(error);
                }
                throw (LSException)DOMUtil.createLSException((short)82, e).fillInStackTrace();
            }
            finally {
                ser.clearDocumentState();
            }
        }
        return true;
    }

    private void prepareForSerialization(XMLSerializer ser, Node node) {
        ser.reset();
        ser.features = this.features;
        ser.fDOMErrorHandler = this.fErrorHandler;
        ser.fNamespaces = (this.features & 1) != 0;
        ser.fNamespacePrefixes = (this.features & 0x200) != 0;
        ser._format.setIndenting((this.features & 0x800) != 0);
        ser._format.setOmitComments((this.features & 0x20) == 0);
        ser._format.setOmitXMLDeclaration((this.features & 0x100) == 0);
        if ((this.features & 2) != 0) {
            Node root = node;
            boolean verifyNames = true;
            Document document = node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument();
            try {
                Method versionChanged = document.getClass().getMethod("isXMLVersionChanged()", new Class[0]);
                if (versionChanged != null) {
                    verifyNames = (Boolean)versionChanged.invoke((Object)document, (Object[])null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (node.getFirstChild() != null) {
                while (node != null) {
                    this.verify(node, verifyNames, false);
                    Node next = node.getFirstChild();
                    while (next == null) {
                        next = node.getNextSibling();
                        if (next != null) continue;
                        if (root == (node = node.getParentNode())) {
                            next = null;
                            break;
                        }
                        next = node.getNextSibling();
                    }
                    node = next;
                }
            } else {
                this.verify(node, verifyNames, false);
            }
        }
    }

    private void verify(Node node, boolean verifyNames, boolean xml11Version) {
        short type = node.getNodeType();
        this.fLocator.fRelatedNode = node;
        switch (type) {
            case 9: {
                break;
            }
            case 10: {
                break;
            }
            case 1: {
                NamedNodeMap attributes;
                boolean wellformed;
                if (verifyNames && !(wellformed = (this.features & 1) != 0 ? CoreDocumentImpl.isValidQName(node.getPrefix(), node.getLocalName(), xml11Version) : CoreDocumentImpl.isXMLName(node.getNodeName(), xml11Version)) && this.fErrorHandler != null) {
                    String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "wf-invalid-character-in-node-name", new Object[]{"Element", node.getNodeName()});
                    DOMNormalizer.reportDOMError(this.fErrorHandler, this.fError, this.fLocator, msg, (short)3, "wf-invalid-character-in-node-name");
                }
                NamedNodeMap namedNodeMap = attributes = node.hasAttributes() ? node.getAttributes() : null;
                if (attributes == null) break;
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Attr attr = (Attr)attributes.item(i);
                    this.fLocator.fRelatedNode = attr;
                    DOMNormalizer.isAttrValueWF(this.fErrorHandler, this.fError, this.fLocator, attributes, attr, attr.getValue(), xml11Version);
                    if (!verifyNames || (wellformed = CoreDocumentImpl.isXMLName(attr.getNodeName(), xml11Version))) continue;
                    String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "wf-invalid-character-in-node-name", new Object[]{"Attr", node.getNodeName()});
                    DOMNormalizer.reportDOMError(this.fErrorHandler, this.fError, this.fLocator, msg, (short)3, "wf-invalid-character-in-node-name");
                }
                break;
            }
            case 8: {
                if ((this.features & 0x20) == 0) break;
                DOMNormalizer.isCommentWF(this.fErrorHandler, this.fError, this.fLocator, ((Comment)node).getData(), xml11Version);
                break;
            }
            case 5: {
                if (!verifyNames || (this.features & 4) == 0) break;
                CoreDocumentImpl.isXMLName(node.getNodeName(), xml11Version);
                break;
            }
            case 4: {
                DOMNormalizer.isXMLCharWF(this.fErrorHandler, this.fError, this.fLocator, node.getNodeValue(), xml11Version);
                break;
            }
            case 3: {
                DOMNormalizer.isXMLCharWF(this.fErrorHandler, this.fError, this.fLocator, node.getNodeValue(), xml11Version);
                break;
            }
            case 7: {
                boolean wellformed;
                ProcessingInstruction pinode = (ProcessingInstruction)node;
                String target = pinode.getTarget();
                if (verifyNames && !(wellformed = xml11Version ? XML11Char.isXML11ValidName(target) : XMLChar.isValidName(target))) {
                    String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "wf-invalid-character-in-node-name", new Object[]{"Element", node.getNodeName()});
                    DOMNormalizer.reportDOMError(this.fErrorHandler, this.fError, this.fLocator, msg, (short)3, "wf-invalid-character-in-node-name");
                }
                DOMNormalizer.isXMLCharWF(this.fErrorHandler, this.fError, this.fLocator, pinode.getData(), xml11Version);
                break;
            }
        }
        this.fLocator.fRelatedNode = null;
    }

    private String _getXmlVersion(Node node) {
        Document doc;
        Document document = doc = node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument();
        if (doc != null && DocumentMethods.fgDocumentMethodsAvailable) {
            try {
                return (String)DocumentMethods.fgDocumentGetXmlVersionMethod.invoke((Object)doc, (Object[])null);
            }
            catch (VirtualMachineError vme) {
                throw vme;
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    private String _getInputEncoding(Node node) {
        Document doc;
        Document document = doc = node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument();
        if (doc != null && DocumentMethods.fgDocumentMethodsAvailable) {
            try {
                return (String)DocumentMethods.fgDocumentGetInputEncodingMethod.invoke((Object)doc, (Object[])null);
            }
            catch (VirtualMachineError vme) {
                throw vme;
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    private String _getXmlEncoding(Node node) {
        Document doc;
        Document document = doc = node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument();
        if (doc != null && DocumentMethods.fgDocumentMethodsAvailable) {
            try {
                return (String)DocumentMethods.fgDocumentGetXmlEncodingMethod.invoke((Object)doc, (Object[])null);
            }
            catch (VirtualMachineError vme) {
                throw vme;
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    static class DocumentMethods {
        private static Method fgDocumentGetXmlVersionMethod = null;
        private static Method fgDocumentGetInputEncodingMethod = null;
        private static Method fgDocumentGetXmlEncodingMethod = null;
        private static boolean fgDocumentMethodsAvailable = false;

        private DocumentMethods() {
        }

        static {
            try {
                fgDocumentGetXmlVersionMethod = Document.class.getMethod("getXmlVersion", new Class[0]);
                fgDocumentGetInputEncodingMethod = Document.class.getMethod("getInputEncoding", new Class[0]);
                fgDocumentGetXmlEncodingMethod = Document.class.getMethod("getXmlEncoding", new Class[0]);
                fgDocumentMethodsAvailable = true;
            }
            catch (Exception exc) {
                fgDocumentGetXmlVersionMethod = null;
                fgDocumentGetInputEncodingMethod = null;
                fgDocumentGetXmlEncodingMethod = null;
                fgDocumentMethodsAvailable = false;
            }
        }
    }
}

