/*
 * Decompiled with CFR 0.152.
 */
package mf.org.apache.xerces.xinclude;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import mf.org.apache.xerces.impl.XMLEntityManager;
import mf.org.apache.xerces.impl.XMLErrorReporter;
import mf.org.apache.xerces.impl.io.ASCIIReader;
import mf.org.apache.xerces.impl.io.Latin1Reader;
import mf.org.apache.xerces.impl.io.UTF16Reader;
import mf.org.apache.xerces.impl.io.UTF8Reader;
import mf.org.apache.xerces.util.EncodingMap;
import mf.org.apache.xerces.util.HTTPInputSource;
import mf.org.apache.xerces.util.MessageFormatter;
import mf.org.apache.xerces.util.XMLChar;
import mf.org.apache.xerces.xinclude.XIncludeHandler;
import mf.org.apache.xerces.xni.XMLString;
import mf.org.apache.xerces.xni.parser.XMLInputSource;

public class XIncludeTextReader {
    private Reader fReader;
    private final XIncludeHandler fHandler;
    private XMLInputSource fSource;
    private XMLErrorReporter fErrorReporter;
    private XMLString fTempString = new XMLString();

    public XIncludeTextReader(XMLInputSource source, XIncludeHandler handler, int bufferSize) throws IOException {
        this.fHandler = handler;
        this.fSource = source;
        this.fTempString = new XMLString(new char[bufferSize + 1], 0, 0);
    }

    public void setErrorReporter(XMLErrorReporter errorReporter) {
        this.fErrorReporter = errorReporter;
    }

    protected Reader getReader(XMLInputSource source) throws IOException {
        if (source.getCharacterStream() != null) {
            return source.getCharacterStream();
        }
        InputStream stream = null;
        String encoding = source.getEncoding();
        if (encoding == null) {
            encoding = "UTF-8";
        }
        if (source.getByteStream() != null) {
            stream = source.getByteStream();
            if (!(stream instanceof BufferedInputStream)) {
                stream = new BufferedInputStream(stream, this.fTempString.ch.length);
            }
        } else {
            String expandedSystemId = XMLEntityManager.expandSystemId(source.getSystemId(), source.getBaseSystemId(), false);
            URL url = new URL(expandedSystemId);
            URLConnection urlCon = url.openConnection();
            if (urlCon instanceof HttpURLConnection && source instanceof HTTPInputSource) {
                HttpURLConnection urlConnection = (HttpURLConnection)urlCon;
                HTTPInputSource httpInputSource = (HTTPInputSource)source;
                Iterator propIter = httpInputSource.getHTTPRequestProperties();
                while (propIter.hasNext()) {
                    Map.Entry entry = (Map.Entry)propIter.next();
                    urlConnection.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
                }
                boolean followRedirects = httpInputSource.getFollowHTTPRedirects();
                if (!followRedirects) {
                    urlConnection.setInstanceFollowRedirects(followRedirects);
                }
            }
            stream = new BufferedInputStream(urlCon.getInputStream());
            String rawContentType = urlCon.getContentType();
            int index = rawContentType != null ? rawContentType.indexOf(59) : -1;
            String contentType = null;
            String charset = null;
            if (index != -1) {
                contentType = rawContentType.substring(0, index).trim();
                charset = rawContentType.substring(index + 1).trim();
                if (charset.startsWith("charset=")) {
                    if ((charset = charset.substring(8).trim()).charAt(0) == '\"' && charset.charAt(charset.length() - 1) == '\"' || charset.charAt(0) == '\'' && charset.charAt(charset.length() - 1) == '\'') {
                        charset = charset.substring(1, charset.length() - 1);
                    }
                } else {
                    charset = null;
                }
            } else {
                contentType = rawContentType.trim();
            }
            String detectedEncoding = null;
            if (contentType.equals("text/xml")) {
                detectedEncoding = charset != null ? charset : "US-ASCII";
            } else if (contentType.equals("application/xml")) {
                detectedEncoding = charset != null ? charset : this.getEncodingName(stream);
            } else if (contentType.endsWith("+xml")) {
                detectedEncoding = this.getEncodingName(stream);
            }
            if (detectedEncoding != null) {
                encoding = detectedEncoding;
            }
        }
        encoding = encoding.toUpperCase(Locale.ENGLISH);
        if ((encoding = this.consumeBOM(stream, encoding)).equals("UTF-8")) {
            return this.createUTF8Reader(stream);
        }
        if (encoding.equals("UTF-16BE")) {
            return this.createUTF16Reader(stream, true);
        }
        if (encoding.equals("UTF-16LE")) {
            return this.createUTF16Reader(stream, false);
        }
        String javaEncoding = EncodingMap.getIANA2JavaMapping(encoding);
        if (javaEncoding == null) {
            MessageFormatter aFormatter = this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/1998/REC-xml-19980210");
            Locale aLocale = this.fErrorReporter.getLocale();
            throw new IOException(aFormatter.formatMessage(aLocale, "EncodingDeclInvalid", new Object[]{encoding}));
        }
        if (javaEncoding.equals("ASCII")) {
            return this.createASCIIReader(stream);
        }
        if (javaEncoding.equals("ISO8859_1")) {
            return this.createLatin1Reader(stream);
        }
        return new InputStreamReader(stream, javaEncoding);
    }

    private Reader createUTF8Reader(InputStream stream) {
        return new UTF8Reader(stream, this.fTempString.ch.length, this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/1998/REC-xml-19980210"), this.fErrorReporter.getLocale());
    }

    private Reader createUTF16Reader(InputStream stream, boolean isBigEndian) {
        return new UTF16Reader(stream, this.fTempString.ch.length << 1, isBigEndian, this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/1998/REC-xml-19980210"), this.fErrorReporter.getLocale());
    }

    private Reader createASCIIReader(InputStream stream) {
        return new ASCIIReader(stream, this.fTempString.ch.length, this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/1998/REC-xml-19980210"), this.fErrorReporter.getLocale());
    }

    private Reader createLatin1Reader(InputStream stream) {
        return new Latin1Reader(stream, this.fTempString.ch.length);
    }

    protected String getEncodingName(InputStream stream) throws IOException {
        byte[] b4 = new byte[4];
        String encoding = null;
        stream.mark(4);
        int count = stream.read(b4, 0, 4);
        stream.reset();
        if (count == 4) {
            encoding = this.getEncodingName(b4);
        }
        return encoding;
    }

    protected String consumeBOM(InputStream stream, String encoding) throws IOException {
        byte[] b = new byte[3];
        int count = 0;
        stream.mark(3);
        if (encoding.equals("UTF-8")) {
            count = stream.read(b, 0, 3);
            if (count == 3) {
                int b0 = b[0] & 0xFF;
                int b1 = b[1] & 0xFF;
                int b2 = b[2] & 0xFF;
                if (b0 != 239 || b1 != 187 || b2 != 191) {
                    stream.reset();
                }
            } else {
                stream.reset();
            }
        } else if (encoding.startsWith("UTF-16")) {
            count = stream.read(b, 0, 2);
            if (count == 2) {
                int b0 = b[0] & 0xFF;
                int b1 = b[1] & 0xFF;
                if (b0 == 254 && b1 == 255) {
                    return "UTF-16BE";
                }
                if (b0 == 255 && b1 == 254) {
                    return "UTF-16LE";
                }
            }
            stream.reset();
        }
        return encoding;
    }

    protected String getEncodingName(byte[] b4) {
        int b0 = b4[0] & 0xFF;
        int b1 = b4[1] & 0xFF;
        if (b0 == 254 && b1 == 255) {
            return "UTF-16BE";
        }
        if (b0 == 255 && b1 == 254) {
            return "UTF-16LE";
        }
        int b2 = b4[2] & 0xFF;
        if (b0 == 239 && b1 == 187 && b2 == 191) {
            return "UTF-8";
        }
        int b3 = b4[3] & 0xFF;
        if (b0 == 0 && b1 == 0 && b2 == 0 && b3 == 60) {
            return "ISO-10646-UCS-4";
        }
        if (b0 == 60 && b1 == 0 && b2 == 0 && b3 == 0) {
            return "ISO-10646-UCS-4";
        }
        if (b0 == 0 && b1 == 0 && b2 == 60 && b3 == 0) {
            return "ISO-10646-UCS-4";
        }
        if (b0 == 0 && b1 == 60 && b2 == 0 && b3 == 0) {
            return "ISO-10646-UCS-4";
        }
        if (b0 == 0 && b1 == 60 && b2 == 0 && b3 == 63) {
            return "UTF-16BE";
        }
        if (b0 == 60 && b1 == 0 && b2 == 63 && b3 == 0) {
            return "UTF-16LE";
        }
        if (b0 == 76 && b1 == 111 && b2 == 167 && b3 == 148) {
            return "CP037";
        }
        return null;
    }

    public void parse() throws IOException {
        this.fReader = this.getReader(this.fSource);
        this.fSource = null;
        int readSize = this.fReader.read(this.fTempString.ch, 0, this.fTempString.ch.length - 1);
        this.fHandler.fHasIncludeReportedContent = true;
        while (readSize != -1) {
            for (int i = 0; i < readSize; ++i) {
                char ch = this.fTempString.ch[i];
                if (this.isValid(ch)) continue;
                if (XMLChar.isHighSurrogate(ch)) {
                    int ch2;
                    if (++i < readSize) {
                        ch2 = this.fTempString.ch[i];
                    } else {
                        ch2 = this.fReader.read();
                        if (ch2 != -1) {
                            this.fTempString.ch[readSize++] = (char)ch2;
                        }
                    }
                    if (XMLChar.isLowSurrogate(ch2)) {
                        int sup = XMLChar.supplemental(ch, (char)ch2);
                        if (this.isValid(sup)) continue;
                        this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "InvalidCharInContent", new Object[]{Integer.toString(sup, 16)}, (short)2);
                        continue;
                    }
                    this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "InvalidCharInContent", new Object[]{Integer.toString(ch2, 16)}, (short)2);
                    continue;
                }
                this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "InvalidCharInContent", new Object[]{Integer.toString(ch, 16)}, (short)2);
            }
            if (this.fHandler != null && readSize > 0) {
                this.fTempString.offset = 0;
                this.fTempString.length = readSize;
                this.fHandler.characters(this.fTempString, this.fHandler.modifyAugmentations(null, true));
            }
            readSize = this.fReader.read(this.fTempString.ch, 0, this.fTempString.ch.length - 1);
        }
    }

    public void setInputSource(XMLInputSource source) {
        this.fSource = source;
    }

    public void close() throws IOException {
        if (this.fReader != null) {
            this.fReader.close();
            this.fReader = null;
        }
    }

    protected boolean isValid(int ch) {
        return XMLChar.isValid(ch);
    }

    protected void setBufferSize(int bufferSize) {
        if (this.fTempString.ch.length != ++bufferSize) {
            this.fTempString.ch = new char[bufferSize];
        }
    }
}

