/*
 * Decompiled with CFR 0.152.
 */
package mf.org.apache.xerces.impl.xs.opti;

import mf.org.apache.xerces.impl.xs.opti.DefaultElement;
import mf.org.apache.xerces.impl.xs.opti.NamedNodeMapImpl;
import mf.org.apache.xerces.impl.xs.opti.SchemaDOM;
import mf.org.w3c.dom.Attr;
import mf.org.w3c.dom.Document;
import mf.org.w3c.dom.NamedNodeMap;
import mf.org.w3c.dom.Node;

public class ElementImpl
extends DefaultElement {
    SchemaDOM schemaDOM;
    Attr[] attrs;
    int row = -1;
    int col = -1;
    int parentRow = -1;
    int line;
    int column;
    int charOffset;
    String fAnnotation;
    String fSyntheticAnnotation;

    public ElementImpl(int line, int column, int offset) {
        this.nodeType = 1;
        this.line = line;
        this.column = column;
        this.charOffset = offset;
    }

    public ElementImpl(int line, int column) {
        this(line, column, -1);
    }

    public ElementImpl(String prefix, String localpart, String rawname, String uri, int line, int column, int offset) {
        super(prefix, localpart, rawname, uri, (short)1);
        this.line = line;
        this.column = column;
        this.charOffset = offset;
    }

    public ElementImpl(String prefix, String localpart, String rawname, String uri, int line, int column) {
        this(prefix, localpart, rawname, uri, line, column, -1);
    }

    public Document getOwnerDocument() {
        return this.schemaDOM;
    }

    public Node getParentNode() {
        return this.schemaDOM.relations[this.row][0];
    }

    public boolean hasChildNodes() {
        return this.parentRow != -1;
    }

    public Node getFirstChild() {
        if (this.parentRow == -1) {
            return null;
        }
        return this.schemaDOM.relations[this.parentRow][1];
    }

    public Node getLastChild() {
        int i;
        if (this.parentRow == -1) {
            return null;
        }
        for (i = 1; i < this.schemaDOM.relations[this.parentRow].length; ++i) {
            if (this.schemaDOM.relations[this.parentRow][i] != null) continue;
            return this.schemaDOM.relations[this.parentRow][i - 1];
        }
        if (i == 1) {
            ++i;
        }
        return this.schemaDOM.relations[this.parentRow][i - 1];
    }

    public Node getPreviousSibling() {
        if (this.col == 1) {
            return null;
        }
        return this.schemaDOM.relations[this.row][this.col - 1];
    }

    public Node getNextSibling() {
        if (this.col == this.schemaDOM.relations[this.row].length - 1) {
            return null;
        }
        return this.schemaDOM.relations[this.row][this.col + 1];
    }

    public NamedNodeMap getAttributes() {
        return new NamedNodeMapImpl(this.attrs);
    }

    public boolean hasAttributes() {
        return this.attrs.length != 0;
    }

    public String getTagName() {
        return this.rawname;
    }

    public String getAttribute(String name) {
        for (int i = 0; i < this.attrs.length; ++i) {
            if (!this.attrs[i].getName().equals(name)) continue;
            return this.attrs[i].getValue();
        }
        return "";
    }

    public Attr getAttributeNode(String name) {
        for (int i = 0; i < this.attrs.length; ++i) {
            if (!this.attrs[i].getName().equals(name)) continue;
            return this.attrs[i];
        }
        return null;
    }

    public String getAttributeNS(String namespaceURI, String localName) {
        for (int i = 0; i < this.attrs.length; ++i) {
            if (!this.attrs[i].getLocalName().equals(localName) || !ElementImpl.nsEquals(this.attrs[i].getNamespaceURI(), namespaceURI)) continue;
            return this.attrs[i].getValue();
        }
        return "";
    }

    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        for (int i = 0; i < this.attrs.length; ++i) {
            if (!this.attrs[i].getName().equals(localName) || !ElementImpl.nsEquals(this.attrs[i].getNamespaceURI(), namespaceURI)) continue;
            return this.attrs[i];
        }
        return null;
    }

    public boolean hasAttribute(String name) {
        for (int i = 0; i < this.attrs.length; ++i) {
            if (!this.attrs[i].getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAttributeNS(String namespaceURI, String localName) {
        for (int i = 0; i < this.attrs.length; ++i) {
            if (!this.attrs[i].getName().equals(localName) || !ElementImpl.nsEquals(this.attrs[i].getNamespaceURI(), namespaceURI)) continue;
            return true;
        }
        return false;
    }

    public void setAttribute(String name, String value) {
        for (int i = 0; i < this.attrs.length; ++i) {
            if (!this.attrs[i].getName().equals(name)) continue;
            this.attrs[i].setValue(value);
            return;
        }
    }

    public int getLineNumber() {
        return this.line;
    }

    public int getColumnNumber() {
        return this.column;
    }

    public int getCharacterOffset() {
        return this.charOffset;
    }

    public String getAnnotation() {
        return this.fAnnotation;
    }

    public String getSyntheticAnnotation() {
        return this.fSyntheticAnnotation;
    }

    private static boolean nsEquals(String nsURI_1, String nsURI_2) {
        if (nsURI_1 == null) {
            return nsURI_2 == null;
        }
        return nsURI_1.equals(nsURI_2);
    }
}

