/*
 * Decompiled with CFR 0.152.
 */
package mf.org.apache.xerces.impl.xs;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import mf.org.apache.xerces.dom.DOMErrorImpl;
import mf.org.apache.xerces.dom.DOMMessageFormatter;
import mf.org.apache.xerces.dom.DOMStringListImpl;
import mf.org.apache.xerces.impl.XMLEntityManager;
import mf.org.apache.xerces.impl.XMLErrorReporter;
import mf.org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import mf.org.apache.xerces.impl.dv.SchemaDVFactory;
import mf.org.apache.xerces.impl.dv.xs.SchemaDVFactoryImpl;
import mf.org.apache.xerces.impl.xs.FilePathToURI;
import mf.org.apache.xerces.impl.xs.SchemaGrammar;
import mf.org.apache.xerces.impl.xs.SchemaSymbols;
import mf.org.apache.xerces.impl.xs.SubstitutionGroupHandler;
import mf.org.apache.xerces.impl.xs.XSAttributeDecl;
import mf.org.apache.xerces.impl.xs.XSConstraints;
import mf.org.apache.xerces.impl.xs.XSDDescription;
import mf.org.apache.xerces.impl.xs.XSDeclarationPool;
import mf.org.apache.xerces.impl.xs.XSElementDecl;
import mf.org.apache.xerces.impl.xs.XSElementDeclHelper;
import mf.org.apache.xerces.impl.xs.XSGrammarBucket;
import mf.org.apache.xerces.impl.xs.XSMessageFormatter;
import mf.org.apache.xerces.impl.xs.XSModelImpl;
import mf.org.apache.xerces.impl.xs.models.CMBuilder;
import mf.org.apache.xerces.impl.xs.models.CMNodeFactory;
import mf.org.apache.xerces.impl.xs.traversers.XSDHandler;
import mf.org.apache.xerces.util.DOMEntityResolverWrapper;
import mf.org.apache.xerces.util.DOMErrorHandlerWrapper;
import mf.org.apache.xerces.util.DefaultErrorHandler;
import mf.org.apache.xerces.util.MessageFormatter;
import mf.org.apache.xerces.util.ParserConfigurationSettings;
import mf.org.apache.xerces.util.SymbolTable;
import mf.org.apache.xerces.util.URI;
import mf.org.apache.xerces.util.XMLSymbols;
import mf.org.apache.xerces.xni.QName;
import mf.org.apache.xerces.xni.XNIException;
import mf.org.apache.xerces.xni.grammars.Grammar;
import mf.org.apache.xerces.xni.grammars.XMLGrammarLoader;
import mf.org.apache.xerces.xni.grammars.XMLGrammarPool;
import mf.org.apache.xerces.xni.grammars.XSGrammar;
import mf.org.apache.xerces.xni.parser.XMLComponent;
import mf.org.apache.xerces.xni.parser.XMLComponentManager;
import mf.org.apache.xerces.xni.parser.XMLConfigurationException;
import mf.org.apache.xerces.xni.parser.XMLEntityResolver;
import mf.org.apache.xerces.xni.parser.XMLErrorHandler;
import mf.org.apache.xerces.xni.parser.XMLInputSource;
import mf.org.apache.xerces.xs.LSInputList;
import mf.org.apache.xerces.xs.StringList;
import mf.org.apache.xerces.xs.XSLoader;
import mf.org.apache.xerces.xs.XSModel;
import mf.org.w3c.dom.DOMConfiguration;
import mf.org.w3c.dom.DOMErrorHandler;
import mf.org.w3c.dom.DOMException;
import mf.org.w3c.dom.DOMStringList;
import mf.org.w3c.dom.ls.LSInput;
import mf.org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.InputSource;

public class XMLSchemaLoader
implements XMLGrammarLoader,
XMLComponent,
XSElementDeclHelper,
XSLoader,
DOMConfiguration {
    protected static final String SCHEMA_FULL_CHECKING = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String CONTINUE_AFTER_FATAL_ERROR = "http://apache.org/xml/features/continue-after-fatal-error";
    protected static final String ALLOW_JAVA_ENCODINGS = "http://apache.org/xml/features/allow-java-encodings";
    protected static final String STANDARD_URI_CONFORMANT_FEATURE = "http://apache.org/xml/features/standard-uri-conformant";
    protected static final String VALIDATE_ANNOTATIONS = "http://apache.org/xml/features/validate-annotations";
    protected static final String DISALLOW_DOCTYPE = "http://apache.org/xml/features/disallow-doctype-decl";
    protected static final String GENERATE_SYNTHETIC_ANNOTATIONS = "http://apache.org/xml/features/generate-synthetic-annotations";
    protected static final String HONOUR_ALL_SCHEMALOCATIONS = "http://apache.org/xml/features/honour-all-schemaLocations";
    protected static final String AUGMENT_PSVI = "http://apache.org/xml/features/validation/schema/augment-psvi";
    protected static final String PARSER_SETTINGS = "http://apache.org/xml/features/internal/parser-settings";
    protected static final String NAMESPACE_GROWTH = "http://apache.org/xml/features/namespace-growth";
    protected static final String TOLERATE_DUPLICATES = "http://apache.org/xml/features/internal/tolerate-duplicates";
    protected static final String SCHEMA_DV_FACTORY = "http://apache.org/xml/properties/internal/validation/schema/dv-factory";
    private static final String[] RECOGNIZED_FEATURES = new String[]{"http://apache.org/xml/features/validation/schema-full-checking", "http://apache.org/xml/features/validation/schema/augment-psvi", "http://apache.org/xml/features/continue-after-fatal-error", "http://apache.org/xml/features/allow-java-encodings", "http://apache.org/xml/features/standard-uri-conformant", "http://apache.org/xml/features/disallow-doctype-decl", "http://apache.org/xml/features/generate-synthetic-annotations", "http://apache.org/xml/features/validate-annotations", "http://apache.org/xml/features/honour-all-schemaLocations", "http://apache.org/xml/features/namespace-growth", "http://apache.org/xml/features/internal/tolerate-duplicates"};
    public static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    public static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    protected static final String ERROR_HANDLER = "http://apache.org/xml/properties/internal/error-handler";
    public static final String ENTITY_RESOLVER = "http://apache.org/xml/properties/internal/entity-resolver";
    public static final String XMLGRAMMAR_POOL = "http://apache.org/xml/properties/internal/grammar-pool";
    protected static final String SCHEMA_LOCATION = "http://apache.org/xml/properties/schema/external-schemaLocation";
    protected static final String SCHEMA_NONS_LOCATION = "http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation";
    protected static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    protected static final String SECURITY_MANAGER = "http://apache.org/xml/properties/security-manager";
    protected static final String LOCALE = "http://apache.org/xml/properties/locale";
    protected static final String ENTITY_MANAGER = "http://apache.org/xml/properties/internal/entity-manager";
    private static final String[] RECOGNIZED_PROPERTIES = new String[]{"http://apache.org/xml/properties/internal/entity-manager", "http://apache.org/xml/properties/internal/symbol-table", "http://apache.org/xml/properties/internal/error-reporter", "http://apache.org/xml/properties/internal/error-handler", "http://apache.org/xml/properties/internal/entity-resolver", "http://apache.org/xml/properties/internal/grammar-pool", "http://apache.org/xml/properties/schema/external-schemaLocation", "http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", "http://java.sun.com/xml/jaxp/properties/schemaSource", "http://apache.org/xml/properties/security-manager", "http://apache.org/xml/properties/locale", "http://apache.org/xml/properties/internal/validation/schema/dv-factory"};
    private final ParserConfigurationSettings fLoaderConfig = new ParserConfigurationSettings();
    private XMLErrorReporter fErrorReporter = new XMLErrorReporter();
    private XMLEntityManager fEntityManager = null;
    private XMLEntityResolver fUserEntityResolver = null;
    private XMLGrammarPool fGrammarPool = null;
    private String fExternalSchemas = null;
    private String fExternalNoNSSchema = null;
    private Object fJAXPSource = null;
    private boolean fIsCheckedFully = false;
    private boolean fJAXPProcessed = false;
    private boolean fSettingsChanged = true;
    private XSDHandler fSchemaHandler;
    private XSGrammarBucket fGrammarBucket;
    private XSDeclarationPool fDeclPool = null;
    private SubstitutionGroupHandler fSubGroupHandler;
    private CMBuilder fCMBuilder;
    private XSDDescription fXSDDescription = new XSDDescription();
    private SchemaDVFactory fDefaultSchemaDVFactory;
    private WeakHashMap fJAXPCache;
    private Locale fLocale = Locale.getDefault();
    private DOMStringList fRecognizedParameters = null;
    private DOMErrorHandlerWrapper fErrorHandler = null;
    private DOMEntityResolverWrapper fResourceResolver = null;

    public XMLSchemaLoader() {
        this(new SymbolTable(), null, new XMLEntityManager(), null, null, null);
    }

    public XMLSchemaLoader(SymbolTable symbolTable) {
        this(symbolTable, null, new XMLEntityManager(), null, null, null);
    }

    XMLSchemaLoader(XMLErrorReporter errorReporter, XSGrammarBucket grammarBucket, SubstitutionGroupHandler sHandler, CMBuilder builder) {
        this(null, errorReporter, null, grammarBucket, sHandler, builder);
    }

    XMLSchemaLoader(SymbolTable symbolTable, XMLErrorReporter errorReporter, XMLEntityManager entityResolver, XSGrammarBucket grammarBucket, SubstitutionGroupHandler sHandler, CMBuilder builder) {
        this.fLoaderConfig.addRecognizedFeatures(RECOGNIZED_FEATURES);
        this.fLoaderConfig.addRecognizedProperties(RECOGNIZED_PROPERTIES);
        if (symbolTable != null) {
            this.fLoaderConfig.setProperty(SYMBOL_TABLE, symbolTable);
        }
        if (errorReporter == null) {
            errorReporter = new XMLErrorReporter();
            errorReporter.setLocale(this.fLocale);
            errorReporter.setProperty(ERROR_HANDLER, new DefaultErrorHandler());
        }
        this.fErrorReporter = errorReporter;
        if (this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/xml-schema-1") == null) {
            this.fErrorReporter.putMessageFormatter("http://www.w3.org/TR/xml-schema-1", new XSMessageFormatter());
        }
        this.fLoaderConfig.setProperty(ERROR_REPORTER, this.fErrorReporter);
        this.fEntityManager = entityResolver;
        if (this.fEntityManager != null) {
            this.fLoaderConfig.setProperty(ENTITY_MANAGER, this.fEntityManager);
        }
        this.fLoaderConfig.setFeature(AUGMENT_PSVI, true);
        if (grammarBucket == null) {
            grammarBucket = new XSGrammarBucket();
        }
        this.fGrammarBucket = grammarBucket;
        if (sHandler == null) {
            sHandler = new SubstitutionGroupHandler(this);
        }
        this.fSubGroupHandler = sHandler;
        CMNodeFactory nodeFactory = new CMNodeFactory();
        if (builder == null) {
            builder = new CMBuilder(nodeFactory);
        }
        this.fCMBuilder = builder;
        System.out.println("flag1");
        this.fSchemaHandler = new XSDHandler(this.fGrammarBucket);
        this.fJAXPCache = new WeakHashMap();
        this.fSettingsChanged = true;
    }

    public String[] getRecognizedFeatures() {
        return (String[])RECOGNIZED_FEATURES.clone();
    }

    public boolean getFeature(String featureId) throws XMLConfigurationException {
        return this.fLoaderConfig.getFeature(featureId);
    }

    public void setFeature(String featureId, boolean state) throws XMLConfigurationException {
        this.fSettingsChanged = true;
        if (featureId.equals(CONTINUE_AFTER_FATAL_ERROR)) {
            this.fErrorReporter.setFeature(CONTINUE_AFTER_FATAL_ERROR, state);
        } else if (featureId.equals(GENERATE_SYNTHETIC_ANNOTATIONS)) {
            this.fSchemaHandler.setGenerateSyntheticAnnotations(state);
        }
        this.fLoaderConfig.setFeature(featureId, state);
    }

    public String[] getRecognizedProperties() {
        return (String[])RECOGNIZED_PROPERTIES.clone();
    }

    public Object getProperty(String propertyId) throws XMLConfigurationException {
        return this.fLoaderConfig.getProperty(propertyId);
    }

    public void setProperty(String propertyId, Object state) throws XMLConfigurationException {
        this.fSettingsChanged = true;
        this.fLoaderConfig.setProperty(propertyId, state);
        if (propertyId.equals(JAXP_SCHEMA_SOURCE)) {
            this.fJAXPSource = state;
            this.fJAXPProcessed = false;
        } else if (propertyId.equals(XMLGRAMMAR_POOL)) {
            this.fGrammarPool = (XMLGrammarPool)state;
        } else if (propertyId.equals(SCHEMA_LOCATION)) {
            this.fExternalSchemas = (String)state;
        } else if (propertyId.equals(SCHEMA_NONS_LOCATION)) {
            this.fExternalNoNSSchema = (String)state;
        } else if (propertyId.equals(LOCALE)) {
            this.setLocale((Locale)state);
        } else if (propertyId.equals(ENTITY_RESOLVER)) {
            this.fEntityManager.setProperty(ENTITY_RESOLVER, state);
        } else if (propertyId.equals(ERROR_REPORTER)) {
            this.fErrorReporter = (XMLErrorReporter)state;
            if (this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/xml-schema-1") == null) {
                this.fErrorReporter.putMessageFormatter("http://www.w3.org/TR/xml-schema-1", new XSMessageFormatter());
            }
        }
    }

    public void setLocale(Locale locale) {
        this.fLocale = locale;
        this.fErrorReporter.setLocale(locale);
    }

    public Locale getLocale() {
        return this.fLocale;
    }

    public void setErrorHandler(XMLErrorHandler errorHandler) {
        this.fErrorReporter.setProperty(ERROR_HANDLER, errorHandler);
    }

    public XMLErrorHandler getErrorHandler() {
        return this.fErrorReporter.getErrorHandler();
    }

    public void setEntityResolver(XMLEntityResolver entityResolver) {
        this.fUserEntityResolver = entityResolver;
        this.fLoaderConfig.setProperty(ENTITY_RESOLVER, entityResolver);
        this.fEntityManager.setProperty(ENTITY_RESOLVER, entityResolver);
    }

    public XMLEntityResolver getEntityResolver() {
        return this.fUserEntityResolver;
    }

    public void loadGrammar(XMLInputSource[] source) throws IOException, XNIException {
        int numSource = source.length;
        for (int i = 0; i < numSource; ++i) {
            this.loadGrammar(source[i]);
        }
    }

    public Grammar loadGrammar(XMLInputSource source) throws IOException, XNIException {
        this.reset(this.fLoaderConfig);
        this.fSettingsChanged = false;
        XSDDescription desc = new XSDDescription();
        desc.fContextType = (short)3;
        desc.setBaseSystemId(source.getBaseSystemId());
        desc.setLiteralSystemId(source.getSystemId());
        Hashtable locationPairs = new Hashtable();
        XMLSchemaLoader.processExternalHints(this.fExternalSchemas, this.fExternalNoNSSchema, locationPairs, this.fErrorReporter);
        SchemaGrammar grammar = this.loadSchema(desc, source, locationPairs);
        if (grammar != null && this.fGrammarPool != null) {
            this.fGrammarPool.cacheGrammars("http://www.w3.org/2001/XMLSchema", this.fGrammarBucket.getGrammars());
            if (this.fIsCheckedFully && this.fJAXPCache.get(grammar) != grammar) {
                XSConstraints.fullSchemaChecking(this.fGrammarBucket, this.fSubGroupHandler, this.fCMBuilder, this.fErrorReporter);
            }
        }
        return grammar;
    }

    SchemaGrammar loadSchema(XSDDescription desc, XMLInputSource source, Hashtable locationPairs) throws IOException, XNIException {
        if (!this.fJAXPProcessed) {
            this.processJAXPSchemaSource(locationPairs);
        }
        SchemaGrammar grammar = this.fSchemaHandler.parseSchema(source, desc, locationPairs);
        return grammar;
    }

    public static XMLInputSource resolveDocument(XSDDescription desc, Hashtable locationPairs, XMLEntityResolver entityResolver) throws IOException {
        String[] hints;
        String namespace;
        String ns;
        LocationArray tempLA;
        String loc = null;
        if ((desc.getContextType() == 2 || desc.fromInstance()) && (tempLA = (LocationArray)locationPairs.get(ns = (namespace = desc.getTargetNamespace()) == null ? XMLSymbols.EMPTY_STRING : namespace)) != null) {
            loc = tempLA.getFirstLocation();
        }
        if (loc == null && (hints = desc.getLocationHints()) != null && hints.length > 0) {
            loc = hints[0];
        }
        String expandedLoc = XMLEntityManager.expandSystemId(loc, desc.getBaseSystemId(), false);
        desc.setLiteralSystemId(loc);
        desc.setExpandedSystemId(expandedLoc);
        return entityResolver.resolveEntity(desc);
    }

    public static void processExternalHints(String sl, String nsl, Hashtable locations, XMLErrorReporter er) {
        XSAttributeDecl attrDecl;
        if (sl != null) {
            try {
                attrDecl = SchemaGrammar.SG_XSI.getGlobalAttributeDecl(SchemaSymbols.XSI_SCHEMALOCATION);
                attrDecl.fType.validate(sl, null, null);
                if (!XMLSchemaLoader.tokenizeSchemaLocationStr(sl, locations, null)) {
                    er.reportError("http://www.w3.org/TR/xml-schema-1", "SchemaLocation", new Object[]{sl}, (short)0);
                }
            }
            catch (InvalidDatatypeValueException ex) {
                er.reportError("http://www.w3.org/TR/xml-schema-1", ex.getKey(), ex.getArgs(), (short)0);
            }
        }
        if (nsl != null) {
            try {
                attrDecl = SchemaGrammar.SG_XSI.getGlobalAttributeDecl(SchemaSymbols.XSI_NONAMESPACESCHEMALOCATION);
                attrDecl.fType.validate(nsl, null, null);
                LocationArray la = (LocationArray)locations.get(XMLSymbols.EMPTY_STRING);
                if (la == null) {
                    la = new LocationArray();
                    locations.put(XMLSymbols.EMPTY_STRING, la);
                }
                la.addLocation(nsl);
            }
            catch (InvalidDatatypeValueException ex) {
                er.reportError("http://www.w3.org/TR/xml-schema-1", ex.getKey(), ex.getArgs(), (short)0);
            }
        }
    }

    public static boolean tokenizeSchemaLocationStr(String schemaStr, Hashtable locations, String base) {
        if (schemaStr != null) {
            StringTokenizer t = new StringTokenizer(schemaStr, " \n\t\r");
            while (t.hasMoreTokens()) {
                String namespace = t.nextToken();
                if (!t.hasMoreTokens()) {
                    return false;
                }
                String location = t.nextToken();
                LocationArray la = (LocationArray)locations.get(namespace);
                if (la == null) {
                    la = new LocationArray();
                    locations.put(namespace, la);
                }
                if (base != null) {
                    try {
                        location = XMLEntityManager.expandSystemId(location, base, false);
                    }
                    catch (URI.MalformedURIException malformedURIException) {
                        // empty catch block
                    }
                }
                la.addLocation(location);
            }
        }
        return true;
    }

    private void processJAXPSchemaSource(Hashtable locationPairs) throws IOException {
        this.fJAXPProcessed = true;
        if (this.fJAXPSource == null) {
            return;
        }
        Class<?> componentType = this.fJAXPSource.getClass().getComponentType();
        XMLInputSource xis = null;
        String sid = null;
        if (componentType == null) {
            SchemaGrammar g;
            if ((this.fJAXPSource instanceof InputStream || this.fJAXPSource instanceof InputSource) && (g = (SchemaGrammar)this.fJAXPCache.get(this.fJAXPSource)) != null) {
                this.fGrammarBucket.putGrammar(g);
                return;
            }
            this.fXSDDescription.reset();
            xis = this.xsdToXMLInputSource(this.fJAXPSource);
            sid = xis.getSystemId();
            this.fXSDDescription.fContextType = (short)3;
            if (sid != null) {
                this.fXSDDescription.setBaseSystemId(xis.getBaseSystemId());
                this.fXSDDescription.setLiteralSystemId(sid);
                this.fXSDDescription.setExpandedSystemId(sid);
                this.fXSDDescription.fLocationHints = new String[]{sid};
            }
            if ((g = this.loadSchema(this.fXSDDescription, xis, locationPairs)) != null) {
                if (this.fJAXPSource instanceof InputStream || this.fJAXPSource instanceof InputSource) {
                    this.fJAXPCache.put(this.fJAXPSource, g);
                    if (this.fIsCheckedFully) {
                        XSConstraints.fullSchemaChecking(this.fGrammarBucket, this.fSubGroupHandler, this.fCMBuilder, this.fErrorReporter);
                    }
                }
                this.fGrammarBucket.putGrammar(g);
            }
            return;
        }
        if (!(componentType == Object.class || componentType == String.class || componentType == File.class || componentType == InputStream.class || componentType == InputSource.class || File.class.isAssignableFrom(componentType) || InputStream.class.isAssignableFrom(componentType) || InputSource.class.isAssignableFrom(componentType) || componentType.isInterface())) {
            MessageFormatter mf = this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/xml-schema-1");
            throw new XMLConfigurationException(1, mf.formatMessage(this.fErrorReporter.getLocale(), "jaxp12-schema-source-type.2", new Object[]{componentType.getName()}));
        }
        Object[] objArr = (Object[])this.fJAXPSource;
        ArrayList<String> jaxpSchemaSourceNamespaces = new ArrayList<String>();
        for (int i = 0; i < objArr.length; ++i) {
            SchemaGrammar g;
            if ((objArr[i] instanceof InputStream || objArr[i] instanceof InputSource) && (g = (SchemaGrammar)this.fJAXPCache.get(objArr[i])) != null) {
                this.fGrammarBucket.putGrammar(g);
                continue;
            }
            this.fXSDDescription.reset();
            xis = this.xsdToXMLInputSource(objArr[i]);
            sid = xis.getSystemId();
            this.fXSDDescription.fContextType = (short)3;
            if (sid != null) {
                this.fXSDDescription.setBaseSystemId(xis.getBaseSystemId());
                this.fXSDDescription.setLiteralSystemId(sid);
                this.fXSDDescription.setExpandedSystemId(sid);
                this.fXSDDescription.fLocationHints = new String[]{sid};
            }
            String targetNamespace = null;
            SchemaGrammar grammar = this.fSchemaHandler.parseSchema(xis, this.fXSDDescription, locationPairs);
            if (this.fIsCheckedFully) {
                XSConstraints.fullSchemaChecking(this.fGrammarBucket, this.fSubGroupHandler, this.fCMBuilder, this.fErrorReporter);
            }
            if (grammar == null) continue;
            targetNamespace = grammar.getTargetNamespace();
            if (jaxpSchemaSourceNamespaces.contains(targetNamespace)) {
                MessageFormatter mf = this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/xml-schema-1");
                throw new IllegalArgumentException(mf.formatMessage(this.fErrorReporter.getLocale(), "jaxp12-schema-source-ns", null));
            }
            jaxpSchemaSourceNamespaces.add(targetNamespace);
            if (objArr[i] instanceof InputStream || objArr[i] instanceof InputSource) {
                this.fJAXPCache.put(objArr[i], grammar);
            }
            this.fGrammarBucket.putGrammar(grammar);
        }
    }

    private XMLInputSource xsdToXMLInputSource(Object val) {
        if (val instanceof String) {
            String loc = (String)val;
            this.fXSDDescription.reset();
            this.fXSDDescription.setValues(null, loc, null, null);
            XMLInputSource xis = null;
            try {
                xis = this.fEntityManager.resolveEntity(this.fXSDDescription);
            }
            catch (IOException ex) {
                this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "schema_reference.4", new Object[]{loc}, (short)1);
            }
            if (xis == null) {
                return new XMLInputSource(null, loc, null);
            }
            return xis;
        }
        if (val instanceof InputSource) {
            return XMLSchemaLoader.saxToXMLInputSource((InputSource)val);
        }
        if (val instanceof InputStream) {
            return new XMLInputSource(null, null, null, (InputStream)val, null);
        }
        if (val instanceof File) {
            File file = (File)val;
            String escapedURI = FilePathToURI.filepath2URI(file.getAbsolutePath());
            BufferedInputStream is = null;
            try {
                is = new BufferedInputStream(new FileInputStream(file));
            }
            catch (FileNotFoundException ex) {
                this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "schema_reference.4", new Object[]{file.toString()}, (short)1);
            }
            return new XMLInputSource(null, escapedURI, null, is, null);
        }
        MessageFormatter mf = this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/xml-schema-1");
        throw new XMLConfigurationException(1, mf.formatMessage(this.fErrorReporter.getLocale(), "jaxp12-schema-source-type.1", new Object[]{val != null ? val.getClass().getName() : "null"}));
    }

    private static XMLInputSource saxToXMLInputSource(InputSource sis) {
        String publicId = sis.getPublicId();
        String systemId = sis.getSystemId();
        Reader charStream = sis.getCharacterStream();
        if (charStream != null) {
            return new XMLInputSource(publicId, systemId, null, charStream, null);
        }
        InputStream byteStream = sis.getByteStream();
        if (byteStream != null) {
            return new XMLInputSource(publicId, systemId, null, byteStream, sis.getEncoding());
        }
        return new XMLInputSource(publicId, systemId, null);
    }

    public Boolean getFeatureDefault(String featureId) {
        if (featureId.equals(AUGMENT_PSVI)) {
            return Boolean.TRUE;
        }
        return null;
    }

    public Object getPropertyDefault(String propertyId) {
        return null;
    }

    public void reset(XMLComponentManager componentManager) throws XMLConfigurationException {
        this.fGrammarBucket.reset();
        this.fSubGroupHandler.reset();
        if (!this.fSettingsChanged || !this.parserSettingsUpdated(componentManager)) {
            this.fJAXPProcessed = false;
            this.initGrammarBucket();
            if (this.fDeclPool != null) {
                this.fDeclPool.reset();
            }
            return;
        }
        this.fEntityManager = (XMLEntityManager)componentManager.getProperty(ENTITY_MANAGER);
        this.fErrorReporter = (XMLErrorReporter)componentManager.getProperty(ERROR_REPORTER);
        SchemaDVFactory dvFactory = null;
        try {
            dvFactory = (SchemaDVFactory)componentManager.getProperty(SCHEMA_DV_FACTORY);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            // empty catch block
        }
        if (dvFactory == null) {
            if (this.fDefaultSchemaDVFactory == null) {
                this.fDefaultSchemaDVFactory = SchemaDVFactory.getInstance();
            }
            dvFactory = this.fDefaultSchemaDVFactory;
        }
        this.fSchemaHandler.setDVFactory(dvFactory);
        try {
            this.fExternalSchemas = (String)componentManager.getProperty(SCHEMA_LOCATION);
            this.fExternalNoNSSchema = (String)componentManager.getProperty(SCHEMA_NONS_LOCATION);
        }
        catch (XMLConfigurationException e) {
            this.fExternalSchemas = null;
            this.fExternalNoNSSchema = null;
        }
        try {
            this.fJAXPSource = componentManager.getProperty(JAXP_SCHEMA_SOURCE);
            this.fJAXPProcessed = false;
        }
        catch (XMLConfigurationException e) {
            this.fJAXPSource = null;
            this.fJAXPProcessed = false;
        }
        try {
            this.fGrammarPool = (XMLGrammarPool)componentManager.getProperty(XMLGRAMMAR_POOL);
        }
        catch (XMLConfigurationException e) {
            this.fGrammarPool = null;
        }
        this.initGrammarBucket();
        boolean psvi = true;
        try {
            psvi = componentManager.getFeature(AUGMENT_PSVI);
        }
        catch (XMLConfigurationException e) {
            psvi = false;
        }
        if (psvi || this.fGrammarPool == null) {
            // empty if block
        }
        this.fCMBuilder.setDeclPool(null);
        this.fSchemaHandler.setDeclPool(null);
        if (dvFactory instanceof SchemaDVFactoryImpl) {
            ((SchemaDVFactoryImpl)dvFactory).setDeclPool(null);
        }
        try {
            boolean fatalError = componentManager.getFeature(CONTINUE_AFTER_FATAL_ERROR);
            this.fErrorReporter.setFeature(CONTINUE_AFTER_FATAL_ERROR, fatalError);
        }
        catch (XMLConfigurationException fatalError) {
            // empty catch block
        }
        try {
            this.fIsCheckedFully = componentManager.getFeature(SCHEMA_FULL_CHECKING);
        }
        catch (XMLConfigurationException e) {
            this.fIsCheckedFully = false;
        }
        try {
            this.fSchemaHandler.setGenerateSyntheticAnnotations(componentManager.getFeature(GENERATE_SYNTHETIC_ANNOTATIONS));
        }
        catch (XMLConfigurationException e) {
            this.fSchemaHandler.setGenerateSyntheticAnnotations(false);
        }
        this.fSchemaHandler.reset(componentManager);
    }

    private boolean parserSettingsUpdated(XMLComponentManager componentManager) {
        if (componentManager != this.fLoaderConfig) {
            try {
                return componentManager.getFeature(PARSER_SETTINGS);
            }
            catch (XMLConfigurationException xMLConfigurationException) {
                // empty catch block
            }
        }
        return true;
    }

    private void initGrammarBucket() {
        if (this.fGrammarPool != null) {
            Grammar[] initialGrammars = this.fGrammarPool.retrieveInitialGrammarSet("http://www.w3.org/2001/XMLSchema");
            int length = initialGrammars != null ? initialGrammars.length : 0;
            for (int i = 0; i < length; ++i) {
                if (this.fGrammarBucket.putGrammar((SchemaGrammar)initialGrammars[i], true)) continue;
                this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "GrammarConflict", null, (short)0);
            }
        }
    }

    public DOMConfiguration getConfig() {
        return this;
    }

    public XSModel load(LSInput is) {
        try {
            Grammar g = this.loadGrammar(this.dom2xmlInputSource(is));
            return ((XSGrammar)g).toXSModel();
        }
        catch (Exception e) {
            this.reportDOMFatalError(e);
            return null;
        }
    }

    public XSModel loadInputList(LSInputList is) {
        int length = is.getLength();
        SchemaGrammar[] gs = new SchemaGrammar[length];
        for (int i = 0; i < length; ++i) {
            try {
                gs[i] = (SchemaGrammar)this.loadGrammar(this.dom2xmlInputSource(is.item(i)));
                continue;
            }
            catch (Exception e) {
                this.reportDOMFatalError(e);
                return null;
            }
        }
        return new XSModelImpl(gs);
    }

    public XSModel loadURI(String uri) {
        try {
            Grammar g = this.loadGrammar(new XMLInputSource(null, uri, null));
            return ((XSGrammar)g).toXSModel();
        }
        catch (Exception e) {
            this.reportDOMFatalError(e);
            return null;
        }
    }

    public XSModel loadURIList(StringList uriList) {
        int length = uriList.getLength();
        SchemaGrammar[] gs = new SchemaGrammar[length];
        for (int i = 0; i < length; ++i) {
            try {
                gs[i] = (SchemaGrammar)this.loadGrammar(new XMLInputSource(null, uriList.item(i), null));
                continue;
            }
            catch (Exception e) {
                this.reportDOMFatalError(e);
                return null;
            }
        }
        return new XSModelImpl(gs);
    }

    void reportDOMFatalError(Exception e) {
        if (this.fErrorHandler != null) {
            DOMErrorImpl error = new DOMErrorImpl();
            error.fException = e;
            error.fMessage = e.getMessage();
            error.fSeverity = (short)3;
            this.fErrorHandler.getErrorHandler().handleError(error);
        }
    }

    public boolean canSetParameter(String name, Object value) {
        if (value instanceof Boolean) {
            return name.equals("validate") || name.equals(SCHEMA_FULL_CHECKING) || name.equals(VALIDATE_ANNOTATIONS) || name.equals(CONTINUE_AFTER_FATAL_ERROR) || name.equals(ALLOW_JAVA_ENCODINGS) || name.equals(STANDARD_URI_CONFORMANT_FEATURE) || name.equals(GENERATE_SYNTHETIC_ANNOTATIONS) || name.equals(HONOUR_ALL_SCHEMALOCATIONS) || name.equals(NAMESPACE_GROWTH) || name.equals(TOLERATE_DUPLICATES);
        }
        return name.equals("error-handler") || name.equals("resource-resolver") || name.equals(SYMBOL_TABLE) || name.equals(ERROR_REPORTER) || name.equals(ERROR_HANDLER) || name.equals(ENTITY_RESOLVER) || name.equals(XMLGRAMMAR_POOL) || name.equals(SCHEMA_LOCATION) || name.equals(SCHEMA_NONS_LOCATION) || name.equals(JAXP_SCHEMA_SOURCE) || name.equals(SCHEMA_DV_FACTORY);
    }

    public Object getParameter(String name) throws DOMException {
        if (name.equals("error-handler")) {
            return this.fErrorHandler != null ? this.fErrorHandler.getErrorHandler() : null;
        }
        if (name.equals("resource-resolver")) {
            return this.fResourceResolver != null ? this.fResourceResolver.getEntityResolver() : null;
        }
        try {
            boolean feature = this.getFeature(name);
            return feature ? Boolean.TRUE : Boolean.FALSE;
        }
        catch (Exception e) {
            try {
                Object property = this.getProperty(name);
                return property;
            }
            catch (Exception ex) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{name});
                throw new DOMException(9, msg);
            }
        }
    }

    public DOMStringList getParameterNames() {
        if (this.fRecognizedParameters == null) {
            ArrayList<String> v = new ArrayList<String>();
            v.add("validate");
            v.add("error-handler");
            v.add("resource-resolver");
            v.add(SYMBOL_TABLE);
            v.add(ERROR_REPORTER);
            v.add(ERROR_HANDLER);
            v.add(ENTITY_RESOLVER);
            v.add(XMLGRAMMAR_POOL);
            v.add(SCHEMA_LOCATION);
            v.add(SCHEMA_NONS_LOCATION);
            v.add(JAXP_SCHEMA_SOURCE);
            v.add(SCHEMA_FULL_CHECKING);
            v.add(CONTINUE_AFTER_FATAL_ERROR);
            v.add(ALLOW_JAVA_ENCODINGS);
            v.add(STANDARD_URI_CONFORMANT_FEATURE);
            v.add(VALIDATE_ANNOTATIONS);
            v.add(GENERATE_SYNTHETIC_ANNOTATIONS);
            v.add(HONOUR_ALL_SCHEMALOCATIONS);
            v.add(NAMESPACE_GROWTH);
            v.add(TOLERATE_DUPLICATES);
            this.fRecognizedParameters = new DOMStringListImpl(v);
        }
        return this.fRecognizedParameters;
    }

    public void setParameter(String name, Object value) throws DOMException {
        if (value instanceof Boolean) {
            boolean state = (Boolean)value;
            if (name.equals("validate") && state) {
                return;
            }
            try {
                this.setFeature(name, state);
            }
            catch (Exception e) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{name});
                throw new DOMException(9, msg);
            }
            return;
        }
        if (name.equals("error-handler")) {
            if (value instanceof DOMErrorHandler) {
                try {
                    this.fErrorHandler = new DOMErrorHandlerWrapper((DOMErrorHandler)value);
                    this.setErrorHandler(this.fErrorHandler);
                }
                catch (XMLConfigurationException state) {}
            } else {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{name});
                throw new DOMException(9, msg);
            }
            return;
        }
        if (name.equals("resource-resolver")) {
            if (value instanceof LSResourceResolver) {
                try {
                    this.fResourceResolver = new DOMEntityResolverWrapper((LSResourceResolver)value);
                    this.setEntityResolver(this.fResourceResolver);
                }
                catch (XMLConfigurationException msg) {}
            } else {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{name});
                throw new DOMException(9, msg);
            }
            return;
        }
        try {
            this.setProperty(name, value);
        }
        catch (Exception ex) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "FEATURE_NOT_SUPPORTED", new Object[]{name});
            throw new DOMException(9, msg);
        }
    }

    XMLInputSource dom2xmlInputSource(LSInput is) {
        XMLInputSource xis = null;
        xis = is.getCharacterStream() != null ? new XMLInputSource(is.getPublicId(), is.getSystemId(), is.getBaseURI(), is.getCharacterStream(), "UTF-16") : (is.getByteStream() != null ? new XMLInputSource(is.getPublicId(), is.getSystemId(), is.getBaseURI(), is.getByteStream(), is.getEncoding()) : (is.getStringData() != null && is.getStringData().length() != 0 ? new XMLInputSource(is.getPublicId(), is.getSystemId(), is.getBaseURI(), new StringReader(is.getStringData()), "UTF-16") : new XMLInputSource(is.getPublicId(), is.getSystemId(), is.getBaseURI())));
        return xis;
    }

    public XSElementDecl getGlobalElementDecl(QName element) {
        SchemaGrammar sGrammar = this.fGrammarBucket.getGrammar(element.uri);
        if (sGrammar != null) {
            return sGrammar.getGlobalElementDecl(element.localpart);
        }
        return null;
    }

    static class LocationArray {
        int length;
        String[] locations = new String[2];

        LocationArray() {
        }

        public void resize(int oldLength, int newLength) {
            String[] temp = new String[newLength];
            System.arraycopy(this.locations, 0, temp, 0, Math.min(oldLength, newLength));
            this.locations = temp;
            this.length = Math.min(oldLength, newLength);
        }

        public void addLocation(String location) {
            if (this.length >= this.locations.length) {
                this.resize(this.length, Math.max(1, this.length * 2));
            }
            this.locations[this.length++] = location;
        }

        public String[] getLocationArray() {
            if (this.length < this.locations.length) {
                this.resize(this.locations.length, this.length);
            }
            return this.locations;
        }

        public String getFirstLocation() {
            return this.length > 0 ? this.locations[0] : null;
        }

        public int getLength() {
            return this.length;
        }
    }
}

