/*
 * Decompiled with CFR 0.152.
 */
package mf.org.apache.xerces.impl.xs;

import java.io.File;
import java.io.UnsupportedEncodingException;

final class FilePathToURI {
    private static boolean[] gNeedEscaping = new boolean[128];
    private static char[] gAfterEscaping1 = new char[128];
    private static char[] gAfterEscaping2 = new char[128];
    private static char[] gHexChs = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private FilePathToURI() {
    }

    public static String filepath2URI(String path) {
        int i;
        int ch;
        if (path == null) {
            return null;
        }
        char separator = File.separatorChar;
        path = path.replace(separator, '/');
        int len = path.length();
        StringBuffer buffer = new StringBuffer(len * 3);
        buffer.append("file://");
        if (len >= 2 && path.charAt(1) == ':' && (ch = Character.toUpperCase(path.charAt(0))) >= 65 && ch <= 90) {
            buffer.append('/');
        }
        for (i = 0; i < len && (ch = path.charAt(i)) < 128; ++i) {
            if (gNeedEscaping[ch]) {
                buffer.append('%');
                buffer.append(gAfterEscaping1[ch]);
                buffer.append(gAfterEscaping2[ch]);
                continue;
            }
            buffer.append((char)ch);
        }
        if (i < len) {
            byte[] bytes = null;
            try {
                bytes = path.substring(i).getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return path;
            }
            for (byte b : bytes) {
                if (b < 0) {
                    ch = b + 256;
                    buffer.append('%');
                    buffer.append(gHexChs[ch >> 4]);
                    buffer.append(gHexChs[ch & 0xF]);
                    continue;
                }
                if (gNeedEscaping[b]) {
                    buffer.append('%');
                    buffer.append(gAfterEscaping1[b]);
                    buffer.append(gAfterEscaping2[b]);
                    continue;
                }
                buffer.append((char)b);
            }
        }
        return buffer.toString();
    }

    static {
        for (int i = 0; i <= 31; ++i) {
            FilePathToURI.gNeedEscaping[i] = true;
            FilePathToURI.gAfterEscaping1[i] = gHexChs[i >> 4];
            FilePathToURI.gAfterEscaping2[i] = gHexChs[i & 0xF];
        }
        FilePathToURI.gNeedEscaping[127] = true;
        FilePathToURI.gAfterEscaping1[127] = 55;
        FilePathToURI.gAfterEscaping2[127] = 70;
        for (char ch : new char[]{' ', '<', '>', '#', '%', '\"', '{', '}', '|', '\\', '^', '~', '[', ']', '`'}) {
            FilePathToURI.gNeedEscaping[ch] = true;
            FilePathToURI.gAfterEscaping1[ch] = gHexChs[ch >> 4];
            FilePathToURI.gAfterEscaping2[ch] = gHexChs[ch & 0xF];
        }
    }
}

