/*
 * Decompiled with CFR 0.152.
 */
package com.orhanobut.hawk;

import android.content.Context;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.orhanobut.hawk.AesEncryption;
import com.orhanobut.hawk.Base64Encryption;
import com.orhanobut.hawk.Encoder;
import com.orhanobut.hawk.Encryption;
import com.orhanobut.hawk.GsonParser;
import com.orhanobut.hawk.Hawk;
import com.orhanobut.hawk.HawkEncoder;
import com.orhanobut.hawk.HawkUtils;
import com.orhanobut.hawk.LogLevel;
import com.orhanobut.hawk.Parser;
import com.orhanobut.hawk.SharedPreferencesStorage;
import com.orhanobut.hawk.SqliteStorage;
import com.orhanobut.hawk.Storage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Func0;

public class HawkBuilder {
    private static final String TAG = "HAWK";
    private static final String TAG_INFO = "324909sdfsd98098";
    private static final String KEY_NO_CRYPTO = "dfsklj2342nasdfoasdfcrpknasdf";
    private Context context;
    private EncryptionMethod encryptionMethod;
    private String password;
    private LogLevel logLevel;
    private Storage cryptoStorage;
    private Encoder encoder;
    private Parser parser;
    private Encryption encryption;

    public HawkBuilder(Context context) {
        HawkUtils.checkNull("Context", context);
        this.context = context.getApplicationContext();
    }

    public HawkBuilder setEncryptionMethod(EncryptionMethod encryptionMethod) {
        this.encryptionMethod = encryptionMethod;
        return this;
    }

    public HawkBuilder setPassword(String password) {
        if (TextUtils.isEmpty((CharSequence)password)) {
            throw new NullPointerException("Password should not be null or empty");
        }
        this.password = password;
        return this;
    }

    public HawkBuilder setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
        return this;
    }

    public HawkBuilder setStorage(Storage storage) {
        this.cryptoStorage = storage;
        return this;
    }

    public HawkBuilder setParser(Parser parser) {
        this.parser = parser;
        return this;
    }

    HawkBuilder setEncoder(Encoder encoder) {
        this.encoder = encoder;
        return this;
    }

    HawkBuilder setEncryption(Encryption encryption) {
        this.encryption = encryption;
        return this;
    }

    EncryptionMethod getEncryptionMethod() {
        if (this.encryptionMethod == null) {
            this.encryptionMethod = EncryptionMethod.MEDIUM;
        }
        return this.encryptionMethod;
    }

    String getPassword() {
        return this.password;
    }

    LogLevel getLogLevel() {
        if (this.logLevel == null) {
            this.logLevel = LogLevel.NONE;
        }
        return this.logLevel;
    }

    Storage getStorage() {
        if (this.cryptoStorage == null) {
            this.cryptoStorage = new SharedPreferencesStorage(this.context, TAG);
        }
        return this.cryptoStorage;
    }

    Encoder getEncoder() {
        if (this.encoder == null) {
            this.encoder = new HawkEncoder(this.getParser());
        }
        return this.encoder;
    }

    Storage getInfoStorage() {
        return new SharedPreferencesStorage(this.context, TAG_INFO);
    }

    Parser getParser() {
        if (this.parser == null) {
            this.parser = new GsonParser(new Gson());
        }
        return this.parser;
    }

    Encryption getEncryption() {
        return this.encryption;
    }

    private void validate() {
        if (this.getEncryptionMethod() == EncryptionMethod.HIGHEST && TextUtils.isEmpty((CharSequence)this.getPassword())) {
            throw new IllegalStateException("Password cannot be null if encryption mode is highest");
        }
    }

    public void build() {
        this.startBuild();
    }

    public void build(final Callback callback) {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    HawkBuilder.this.startBuild();
                    callback.onSuccess();
                }
                catch (Exception e) {
                    callback.onFail(e);
                }
            }
        });
        executor.shutdown();
    }

    public Observable<Boolean> buildRx() {
        HawkUtils.checkRx();
        return Observable.defer((Func0)new Func0<Observable<Boolean>>(){

            public Observable<Boolean> call() {
                return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<Boolean>(){

                    public void call(Subscriber<? super Boolean> subscriber) {
                        try {
                            HawkBuilder.this.startBuild();
                            subscriber.onNext((Object)true);
                            subscriber.onCompleted();
                        }
                        catch (Exception e) {
                            subscriber.onError((Throwable)e);
                        }
                    }
                });
            }
        });
    }

    void startBuild() {
        this.validate();
        this.setEncryption();
        Hawk.build(this);
    }

    private void setEncryption() {
        switch (this.getEncryptionMethod()) {
            case NO_ENCRYPTION: {
                this.encryption = new Base64Encryption();
                break;
            }
            case HIGHEST: {
                this.encryption = new AesEncryption(this.getStorage(), this.getPassword());
                if (this.getEncryption().init()) break;
                this.getInfoStorage().put(KEY_NO_CRYPTO, true);
                this.encryption = new Base64Encryption();
                break;
            }
            case MEDIUM: {
                this.encryption = new AesEncryption(this.getStorage(), null);
                if (this.getEncryption().init()) break;
                this.getInfoStorage().put(KEY_NO_CRYPTO, true);
                this.encryption = new Base64Encryption();
                break;
            }
            default: {
                throw new IllegalStateException("encryption mode should be valid");
            }
        }
    }

    public static Storage newSharedPrefStorage(Context context) {
        return new SharedPreferencesStorage(context, TAG);
    }

    public static Storage newSqliteStorage(Context context) {
        return new SqliteStorage(context);
    }

    public static interface Callback {
        public void onSuccess();

        public void onFail(Exception var1);
    }

    public static enum EncryptionMethod {
        HIGHEST,
        MEDIUM,
        NO_ENCRYPTION;

    }
}

