/*
 * Decompiled with CFR 0.152.
 */
package com.orhanobut.hawk;

import android.text.TextUtils;
import com.orhanobut.hawk.DataInfo;
import com.orhanobut.hawk.DataType;
import com.orhanobut.hawk.HawkUtils;
import com.orhanobut.hawk.Logger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class DataHelper {
    private static final char DELIMITER = '@';
    private static final String INFO_DELIMITER = "#";
    private static final char NEW_VERSION = 'V';
    private static final Map<Character, DataType> TYPE_MAP = new HashMap<Character, DataType>();

    private DataHelper() {
    }

    static DataInfo getDataInfo(String storedText) {
        HawkUtils.checkNullOrEmpty("Text", storedText);
        int index = storedText.indexOf(64);
        if (index == -1) {
            throw new IllegalArgumentException("Text should contain delimiter");
        }
        String text = storedText.substring(0, index);
        String cipherText = storedText.substring(index + 1);
        if (TextUtils.isEmpty((CharSequence)text) || TextUtils.isEmpty((CharSequence)cipherText)) {
            throw new IllegalArgumentException("Invalid stored text");
        }
        char firstChar = text.charAt(text.length() - 1);
        if (firstChar == 'V') {
            return DataHelper.getNewDataInfo(text, cipherText);
        }
        throw new IllegalStateException("storedText is not valid");
    }

    static DataInfo getNewDataInfo(String text, String cipherText) {
        String[] infos = text.split(INFO_DELIMITER);
        char type = infos[2].charAt(0);
        DataType dataType = TYPE_MAP.get(Character.valueOf(type));
        Class<?> keyClazz = null;
        if (!TextUtils.isEmpty((CharSequence)infos[0])) {
            try {
                keyClazz = Class.forName(infos[0]);
            }
            catch (ClassNotFoundException e) {
                Logger.d(e.getMessage());
            }
        }
        Class<?> valueClazz = null;
        if (!TextUtils.isEmpty((CharSequence)infos[1])) {
            try {
                valueClazz = Class.forName(infos[1]);
            }
            catch (ClassNotFoundException e) {
                Logger.d(e.getMessage());
            }
        }
        return new DataInfo(dataType, cipherText, keyClazz, valueClazz);
    }

    static <T> String addType(String cipherText, T t) {
        DataType dataType;
        HawkUtils.checkNullOrEmpty("Cipher text", cipherText);
        HawkUtils.checkNull("Value", t);
        String keyClassName = "";
        String valueClassName = "";
        if (List.class.isAssignableFrom(t.getClass())) {
            List list = (List)t;
            if (!list.isEmpty()) {
                keyClassName = list.get(0).getClass().getName();
            }
            dataType = DataType.LIST;
        } else if (Map.class.isAssignableFrom(t.getClass())) {
            Iterator iterator;
            dataType = DataType.MAP;
            Map map = (Map)t;
            if (!map.isEmpty() && (iterator = map.entrySet().iterator()).hasNext()) {
                Map.Entry entry = iterator.next();
                keyClassName = entry.getKey().getClass().getName();
                valueClassName = entry.getValue().getClass().getName();
            }
        } else if (Set.class.isAssignableFrom(t.getClass())) {
            Iterator iterator;
            Set set = (Set)t;
            if (!set.isEmpty() && (iterator = set.iterator()).hasNext()) {
                keyClassName = iterator.next().getClass().getName();
            }
            dataType = DataType.SET;
        } else {
            dataType = DataType.OBJECT;
            keyClassName = t.getClass().getName();
        }
        return keyClassName + INFO_DELIMITER + valueClassName + INFO_DELIMITER + dataType.getType() + 'V' + '@' + cipherText;
    }

    static {
        TYPE_MAP.put(Character.valueOf(DataType.OBJECT.getType()), DataType.OBJECT);
        TYPE_MAP.put(Character.valueOf(DataType.LIST.getType()), DataType.LIST);
        TYPE_MAP.put(Character.valueOf(DataType.MAP.getType()), DataType.MAP);
        TYPE_MAP.put(Character.valueOf(DataType.SET.getType()), DataType.SET);
    }
}

