/*
 * Decompiled with CFR 0.152.
 */
package com.orhanobut.hawk;

import com.orhanobut.hawk.Converter;
import com.orhanobut.hawk.DataInfo;
import com.orhanobut.hawk.Encryption;
import com.orhanobut.hawk.HawkBuilder;
import com.orhanobut.hawk.HawkFacade;
import com.orhanobut.hawk.HawkUtils;
import com.orhanobut.hawk.LogInterceptor;
import com.orhanobut.hawk.Serializer;
import com.orhanobut.hawk.Storage;

public class DefaultHawkFacade
implements HawkFacade {
    private final Storage storage;
    private final Converter converter;
    private final Encryption encryption;
    private final Serializer serializer;
    private final LogInterceptor logInterceptor;

    public DefaultHawkFacade(HawkBuilder builder) {
        this.encryption = builder.getEncryption();
        this.storage = builder.getStorage();
        this.converter = builder.getConverter();
        this.serializer = builder.getSerializer();
        this.logInterceptor = builder.getLogInterceptor();
        this.logInterceptor.onLog("Hawk.init -> Encryption : " + this.encryption.getClass().getSimpleName());
    }

    @Override
    public <T> boolean put(String key, T value) {
        HawkUtils.checkNull("Key", key);
        this.log("Hawk.put -> key: " + key + ", value: " + value);
        if (value == null) {
            this.log("Hawk.put -> Value is null. Any existing value will be deleted with the given key");
            return this.delete(key);
        }
        String plainText = this.converter.toString(value);
        this.log("Hawk.put -> Converted to " + plainText);
        if (plainText == null) {
            this.log("Hawk.put -> Converter failed");
            return false;
        }
        String cipherText = null;
        try {
            cipherText = this.encryption.encrypt(key, plainText);
            this.log("Hawk.put -> Encrypted to " + cipherText);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (cipherText == null) {
            this.log("Hawk.put -> Encryption failed");
            return false;
        }
        String serializedText = this.serializer.serialize(cipherText, value);
        this.log("Hawk.put -> Serialized to " + serializedText);
        if (serializedText == null) {
            this.log("Hawk.put -> Serialization failed");
            return false;
        }
        if (this.storage.put(key, serializedText)) {
            this.log("Hawk.put -> Stored successfully");
            return true;
        }
        this.log("Hawk.put -> Store operation failed");
        return false;
    }

    @Override
    public <T> T get(String key) {
        this.log("Hawk.get -> key: " + key);
        if (key == null) {
            this.log("Hawk.get -> null key, returning null value ");
            return null;
        }
        String serializedText = (String)this.storage.get(key);
        this.log("Hawk.get -> Fetched from storage : " + serializedText);
        if (serializedText == null) {
            this.log("Hawk.get -> Fetching from storage failed");
            return null;
        }
        DataInfo dataInfo = this.serializer.deserialize(serializedText);
        this.log("Hawk.get -> Deserialized");
        if (dataInfo == null) {
            this.log("Hawk.get -> Deserialization failed");
            return null;
        }
        String plainText = null;
        try {
            plainText = this.encryption.decrypt(key, dataInfo.cipherText);
            this.log("Hawk.get -> Decrypted to : " + plainText);
        }
        catch (Exception e) {
            this.log("Hawk.get -> Decrypt failed: " + e.getMessage());
        }
        if (plainText == null) {
            this.log("Hawk.get -> Decrypt failed");
            return null;
        }
        T result = null;
        try {
            result = this.converter.fromString(plainText, dataInfo);
            this.log("Hawk.get -> Converted to : " + result);
        }
        catch (Exception e) {
            this.log("Hawk.get -> Converter failed");
        }
        return result;
    }

    @Override
    public <T> T get(String key, T defaultValue) {
        T t = this.get(key);
        if (t == null) {
            return defaultValue;
        }
        return t;
    }

    @Override
    public long count() {
        return this.storage.count();
    }

    @Override
    public boolean deleteAll() {
        return this.storage.deleteAll();
    }

    @Override
    public boolean delete(String key) {
        return this.storage.delete(key);
    }

    @Override
    public boolean contains(String key) {
        return this.storage.contains(key);
    }

    @Override
    public boolean isBuilt() {
        return true;
    }

    @Override
    public void destroy() {
    }

    private void log(String message) {
        this.logInterceptor.onLog(message);
    }
}

