/*
 * Decompiled with CFR 0.152.
 */
package com.orhanobut.hawk;

import android.content.Context;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.text.TextUtils;
import android.util.Pair;
import com.orhanobut.hawk.Storage;
import java.util.List;

class SqliteStorage
implements Storage {
    private final SqliteHelper helper;

    SqliteStorage(Context context) {
        if (context == null) {
            throw new NullPointerException("Context should not be null");
        }
        this.helper = new SqliteHelper(context);
    }

    @Override
    public <T> boolean put(String key, T value) {
        this.checkKey(key);
        return this.helper.put(key, String.valueOf(value));
    }

    @Override
    public boolean put(List<Pair<String, ?>> items) {
        return this.helper.put(items);
    }

    @Override
    public <T> T get(String key) {
        this.checkKey(key);
        return (T)this.helper.get(key);
    }

    @Override
    public boolean remove(String key) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return true;
        }
        return this.helper.delete(key);
    }

    @Override
    public boolean remove(String ... keys) {
        return this.helper.delete(keys);
    }

    @Override
    public boolean clear() {
        return this.helper.clearAll();
    }

    @Override
    public long count() {
        return this.helper.count();
    }

    @Override
    public boolean contains(String key) {
        if (key == null) {
            return false;
        }
        return this.helper.contains(key);
    }

    private void checkKey(String key) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            throw new NullPointerException("Key cannot be null or empty");
        }
    }

    private static class SqliteHelper
    extends SQLiteOpenHelper {
        private static final String DB_NAME = "Hawk";
        private static final String TABLE_NAME = "hawk";
        private static final String COL_KEY = "hawk_key";
        private static final String COL_VALUE = "hawk_value";
        private static final int VERSION = 1;

        public SqliteHelper(Context context) {
            super(context, DB_NAME, null, 1);
        }

        public void onCreate(SQLiteDatabase db) {
            db.execSQL("CREATE TABLE hawk ( hawk_key text primary key not null, hawk_value text null);");
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        }

        public boolean put(String key, String value) {
            SQLiteDatabase db = this.getWritableDatabase();
            db.execSQL("INSERT OR REPLACE INTO hawk (hawk_key, hawk_value)  VALUES('" + key + "', '" + value + "')");
            db.close();
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean put(List<Pair<String, ?>> list) {
            SQLiteDatabase db = this.getWritableDatabase();
            boolean result = true;
            try {
                db.beginTransaction();
                for (Pair<String, ?> pair : list) {
                    db.execSQL("INSERT OR REPLACE INTO hawk (hawk_key, hawk_value)  VALUES('" + (String)pair.first + "', '" + String.valueOf(pair.second) + "')");
                }
                db.setTransactionSuccessful();
            }
            catch (Exception e) {
                result = false;
            }
            finally {
                db.endTransaction();
                db.close();
            }
            return result;
        }

        public boolean delete(String key) {
            SQLiteDatabase db = this.getWritableDatabase();
            int count = db.delete(TABLE_NAME, "hawk_key='" + key + "'", null);
            db.close();
            return count != -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean delete(String ... keys) {
            SQLiteDatabase db = this.getWritableDatabase();
            boolean result = true;
            try {
                db.beginTransaction();
                for (String key : keys) {
                    if (key == null) continue;
                    int count = db.delete(TABLE_NAME, "hawk_key='" + key + "'", null);
                }
                db.setTransactionSuccessful();
            }
            catch (Exception e) {
                result = false;
            }
            finally {
                db.endTransaction();
                db.close();
            }
            return result;
        }

        public boolean contains(String key) {
            return this.get(key) != null;
        }

        public String get(String key) {
            SQLiteDatabase db = this.getReadableDatabase();
            Cursor cursor = db.rawQuery("SELECT * FROM hawk WHERE hawk_key = '" + key + "'", null);
            if (cursor == null) {
                return null;
            }
            cursor.moveToFirst();
            if (cursor.getCount() == 0) {
                return null;
            }
            String value = cursor.getString(1);
            db.close();
            return value;
        }

        public boolean clearAll() {
            SQLiteDatabase db = this.getWritableDatabase();
            db.execSQL("DELETE FROM hawk");
            db.close();
            return true;
        }

        public long count() {
            SQLiteDatabase db = this.getWritableDatabase();
            long count = DatabaseUtils.queryNumEntries((SQLiteDatabase)db, (String)TABLE_NAME);
            db.close();
            return count;
        }
    }
}

