/*
 * Decompiled with CFR 0.152.
 */
package com.orhanobut.hawk;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Pair;
import com.orhanobut.hawk.Storage;
import java.util.List;

final class SharedPreferencesStorage
implements Storage {
    private final SharedPreferences preferences;

    SharedPreferencesStorage(Context context, String tag) {
        this.preferences = context.getSharedPreferences(tag, 0);
    }

    @Override
    public <T> boolean put(String key, T value) {
        return this.getEditor().putString(key, String.valueOf(value)).commit();
    }

    @Override
    public boolean put(List<Pair<String, ?>> items) {
        SharedPreferences.Editor editor = this.getEditor();
        for (Pair<String, ?> item : items) {
            editor.putString((String)item.first, String.valueOf(item.second));
        }
        return editor.commit();
    }

    @Override
    public <T> T get(String key) {
        return (T)this.preferences.getString(key, null);
    }

    @Override
    public boolean remove(String key) {
        return this.getEditor().remove(key).commit();
    }

    @Override
    public boolean remove(String ... keys) {
        SharedPreferences.Editor editor = this.getEditor();
        for (String key : keys) {
            editor.remove(key);
        }
        return editor.commit();
    }

    @Override
    public boolean contains(String key) {
        return this.preferences.contains(key);
    }

    @Override
    public boolean clear() {
        return this.getEditor().clear().commit();
    }

    @Override
    public long count() {
        return this.preferences.getAll().size();
    }

    private SharedPreferences.Editor getEditor() {
        return this.preferences.edit();
    }
}

