/*
 * Decompiled with CFR 0.152.
 */
package com.orhanobut.hawk;

import com.google.gson.reflect.TypeToken;
import com.orhanobut.hawk.DataInfo;
import com.orhanobut.hawk.DataType;
import com.orhanobut.hawk.Encoder;
import com.orhanobut.hawk.Logger;
import com.orhanobut.hawk.Parser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class HawkEncoder
implements Encoder {
    private final Parser parser;

    public HawkEncoder(Parser parser) {
        if (parser == null) {
            throw new NullPointerException("Parser should not be null");
        }
        this.parser = parser;
    }

    @Override
    public <T> byte[] encode(T value) {
        if (value == null) {
            return null;
        }
        String json = this.parser.toJson(value);
        byte[] bytes = json.getBytes();
        return bytes;
    }

    @Override
    public <T> T decode(byte[] bytes, DataInfo info) throws Exception {
        if (bytes == null) {
            return null;
        }
        if (info == null) {
            throw new NullPointerException("data info should not be null");
        }
        if (info.isNewVersion()) {
            return this.decodeNew(bytes, info);
        }
        return this.decodeOld(bytes, info);
    }

    @Deprecated
    private <T> T decodeOld(byte[] bytes, DataInfo info) throws Exception {
        boolean isList;
        boolean bl = isList = info.getDataType() == DataType.LIST;
        if (!isList && info.isSerializable()) {
            return this.toSerializable(bytes);
        }
        String json = new String(bytes);
        Class type = info.getKeyClazz();
        if (!isList) {
            return this.parser.fromJson(json, type);
        }
        return this.toList(json, type);
    }

    private <T> T decodeNew(byte[] bytes, DataInfo info) throws Exception {
        String json = new String(bytes);
        Class keyType = info.getKeyClazz();
        Class valueType = info.getValueClazz();
        switch (info.getDataType()) {
            case OBJECT: {
                return this.toObject(json, keyType);
            }
            case LIST: {
                return this.toList(json, keyType);
            }
            case MAP: {
                return this.toMap(json, keyType, valueType);
            }
            case SET: {
                return this.toSet(json, keyType);
            }
        }
        return null;
    }

    private <T> T toObject(String json, Class<?> type) throws Exception {
        return this.parser.fromJson(json, type);
    }

    private <T> T toList(String json, Class<?> type) throws Exception {
        if (type == null) {
            return (T)new ArrayList();
        }
        List list = (List)this.parser.fromJson(json, new TypeToken<List<T>>(){}.getType());
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            list.set(i, this.parser.fromJson(this.parser.toJson(list.get(i)), type));
        }
        return (T)list;
    }

    private <T> T toSet(String json, Class<?> type) throws Exception {
        HashSet resultSet = new HashSet();
        if (type == null) {
            return (T)resultSet;
        }
        Set set = (Set)this.parser.fromJson(json, new TypeToken<Set<T>>(){}.getType());
        for (Object t : set) {
            String valueJson = this.parser.toJson(t);
            Object value = this.parser.fromJson(valueJson, type);
            resultSet.add(value);
        }
        return (T)resultSet;
    }

    private <K, V, T> T toMap(String json, Class<?> keyType, Class<?> valueType) throws Exception {
        HashMap resultMap = new HashMap();
        if (keyType == null || valueType == null) {
            return (T)resultMap;
        }
        Map map = (Map)this.parser.fromJson(json, new TypeToken<Map<K, V>>(){}.getType());
        for (Map.Entry entry : map.entrySet()) {
            String keyJson = this.parser.toJson(entry.getKey());
            Object k = this.parser.fromJson(keyJson, keyType);
            String valueJson = this.parser.toJson(entry.getValue());
            Object v = this.parser.fromJson(valueJson, valueType);
            resultMap.put(k, v);
        }
        return (T)resultMap;
    }

    @Deprecated
    private <T> T toSerializable(byte[] bytes) {
        ObjectInputStream inputStream = null;
        try {
            inputStream = new ObjectInputStream(new ByteArrayInputStream(bytes));
        }
        catch (IOException e) {
            Logger.d(e.getMessage());
        }
        if (inputStream == null) {
            return null;
        }
        Object result = null;
        try {
            result = inputStream.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            Logger.d(e.getMessage());
        }
        return (T)result;
    }
}

