/*
 * Decompiled with CFR 0.152.
 */
package com.orhanobut.hawk;

import android.content.Context;
import android.util.Base64;
import android.util.Log;
import android.util.Pair;
import com.google.gson.Gson;
import com.orhanobut.hawk.AesEncryption;
import com.orhanobut.hawk.DataHelper;
import com.orhanobut.hawk.DataInfo;
import com.orhanobut.hawk.Encoder;
import com.orhanobut.hawk.Encryption;
import com.orhanobut.hawk.GsonParser;
import com.orhanobut.hawk.HawkEncoder;
import com.orhanobut.hawk.LogLevel;
import com.orhanobut.hawk.Logger;
import com.orhanobut.hawk.SharedPreferencesStorage;
import com.orhanobut.hawk.Storage;
import com.orhanobut.hawk.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import rx.Observable;
import rx.Subscriber;

public final class Hawk {
    private static final String TAG = "HAWK";
    private static final String TAG_CRYPTO = "324909sdfsd98098";
    private static final String KEY_NO_CRYPTO = "dfsklj2342nasdfoasdfcrpknasdf";
    private static Encoder encoder;
    private static Storage storage;
    private static Encryption encryption;
    private static LogLevel logLevel;
    private static ExecutorService executorService;
    private static boolean noEncryption;

    private Hawk() {
    }

    public static void init(Context context) {
        Hawk.init(context, null, LogLevel.NONE);
    }

    public static void init(Context context, String password, Callback callback) {
        Hawk.init(context, password, LogLevel.NONE, callback);
    }

    public static void init(Context context, String password) {
        Hawk.init(context, password, LogLevel.NONE);
    }

    public static void init(Context context, String password, LogLevel logLevel) {
        Context appContext = context.getApplicationContext();
        Hawk.logLevel = logLevel;
        storage = new SharedPreferencesStorage(appContext, TAG);
        encoder = new HawkEncoder(new GsonParser(new Gson()));
        if (storage.contains(KEY_NO_CRYPTO)) {
            noEncryption = true;
            return;
        }
        SharedPreferencesStorage cryptoStorage = new SharedPreferencesStorage(appContext, TAG_CRYPTO);
        encryption = new AesEncryption(cryptoStorage, password);
        boolean result = encryption.init();
        Hawk.setEncryptionMode(result);
    }

    public static void initWithoutEncryption(Context context, LogLevel logLevel) {
        Context appContext = context.getApplicationContext();
        Hawk.logLevel = logLevel;
        storage = new SharedPreferencesStorage(appContext, TAG);
        encoder = new HawkEncoder(new GsonParser(new Gson()));
        noEncryption = true;
    }

    private static void setEncryptionMode(boolean isCryptoSupported) {
        if (isCryptoSupported) {
            noEncryption = false;
            return;
        }
        storage.put(KEY_NO_CRYPTO, true);
        noEncryption = true;
    }

    public static void init(final Context context, final String password, final LogLevel logLevel, final Callback callback) {
        executorService = Executors.newSingleThreadExecutor();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    Hawk.init(context, password, logLevel);
                    callback.onSuccess();
                }
                catch (Exception e) {
                    Logger.e("Exception occurred while initialization : ", e);
                    callback.onFail(e);
                }
            }
        };
        executorService.execute(runnable);
        executorService.shutdown();
    }

    public static <T> boolean put(String key, T value) {
        if (key == null) {
            throw new NullPointerException("Key cannot be null");
        }
        if (value == null) {
            return Hawk.remove(key);
        }
        String encodedText = Hawk.zip(value);
        return encodedText != null && storage.put(key, encodedText);
    }

    public static <T> Observable<Boolean> putObservable(final String key, final T value) {
        Hawk.checkRx();
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<Boolean>(){

            public void call(Subscriber<? super Boolean> subscriber) {
                block3: {
                    try {
                        boolean result = Hawk.put(key, value);
                        if (!subscriber.isUnsubscribed()) {
                            subscriber.onNext((Object)result);
                            subscriber.onCompleted();
                        }
                    }
                    catch (Exception e) {
                        if (subscriber.isUnsubscribed()) break block3;
                        subscriber.onError((Throwable)e);
                    }
                }
            }
        });
    }

    private static void checkRx() {
        if (!Utils.hasRxJavaOnClasspath()) {
            throw new NoClassDefFoundError("RxJava is not on classpath, make sure that you have it in your dependencies");
        }
    }

    private static <T> String zip(T value) {
        if (value == null) {
            throw new NullPointerException("Value cannot be null");
        }
        byte[] encodedValue = encoder.encode(value);
        String cipherText = noEncryption ? Base64.encodeToString((byte[])encodedValue, (int)0) : encryption.encrypt(encodedValue);
        if (cipherText == null) {
            return null;
        }
        return DataHelper.addType(cipherText, value);
    }

    public static <T> T get(String key) {
        if (key == null) {
            throw new NullPointerException("Key cannot be null");
        }
        String fullText = (String)storage.get(key);
        if (fullText == null) {
            return null;
        }
        DataInfo dataInfo = DataHelper.getDataInfo(fullText);
        byte[] bytes = noEncryption ? DataHelper.decodeBase64(dataInfo.getCipherText()) : encryption.decrypt(dataInfo.getCipherText());
        if (bytes == null) {
            return null;
        }
        try {
            return encoder.decode(bytes, dataInfo);
        }
        catch (Exception e) {
            Logger.d(e.getMessage());
            return null;
        }
    }

    public static <T> T get(String key, T defaultValue) {
        T t = Hawk.get(key);
        if (t == null) {
            return defaultValue;
        }
        return t;
    }

    public static <T> Observable<T> getObservable(String key) {
        Hawk.checkRx();
        return Hawk.getObservable(key, null);
    }

    public static <T> Observable<T> getObservable(final String key, final T defaultValue) {
        Hawk.checkRx();
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<T>(){

            public void call(Subscriber<? super T> subscriber) {
                block3: {
                    try {
                        Object t = Hawk.get(key, defaultValue);
                        if (!subscriber.isUnsubscribed()) {
                            subscriber.onNext(t);
                            subscriber.onCompleted();
                        }
                    }
                    catch (Exception e) {
                        if (subscriber.isUnsubscribed()) break block3;
                        subscriber.onError((Throwable)e);
                    }
                }
            }
        });
    }

    public static Chain chain() {
        return new Chain();
    }

    public static Chain chain(int capacity) {
        return new Chain(capacity);
    }

    public static int count() {
        return storage.count();
    }

    public static boolean clear() {
        return storage.clear();
    }

    public static boolean remove(String key) {
        return storage.remove(key);
    }

    public static boolean remove(String ... keys) {
        return storage.remove(keys);
    }

    public static boolean contains(String key) {
        return storage.contains(key);
    }

    public static boolean resetCrypto() {
        return encryption == null || encryption.reset();
    }

    public static LogLevel getLogLevel() {
        return logLevel;
    }

    public static interface Callback {
        public void onSuccess();

        public void onFail(Exception var1);
    }

    public static final class Chain {
        private final List<Pair<String, ?>> items;

        public Chain() {
            this(10);
        }

        public Chain(int capacity) {
            this.items = new ArrayList(capacity);
        }

        public <T> Chain put(String key, T value) {
            if (key == null) {
                throw new NullPointerException("Key cannot be null");
            }
            String encodedText = Hawk.zip(value);
            if (encodedText == null) {
                Log.d((String)Hawk.TAG, (String)("Key : " + key + " is not added, encryption failed"));
                return this;
            }
            this.items.add(new Pair((Object)key, (Object)encodedText));
            return this;
        }

        public boolean commit() {
            return storage.put(this.items);
        }
    }
}

