/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rules.evaluation.evaluators;

import com.google.common.collect.Lists;
import com.nedap.archie.query.RMObjectWithPath;
import com.nedap.archie.rules.ModelReference;
import com.nedap.archie.rules.PrimitiveType;
import com.nedap.archie.rules.evaluation.Evaluator;
import com.nedap.archie.rules.evaluation.RuleEvaluation;
import com.nedap.archie.rules.evaluation.Value;
import com.nedap.archie.rules.evaluation.ValueList;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.xpath.XPathExpressionException;

public class ModelReferenceEvaluator
implements Evaluator<ModelReference> {
    @Override
    public ValueList evaluate(RuleEvaluation evaluation, ModelReference statement) {
        List<RMObjectWithPath> rmObjectsWithPath;
        String variable = statement.getVariableReferencePrefix();
        String pathPrefix = "";
        if (variable != null) {
            ValueList value = evaluation.getVariableMap().get(variable);
            if (value == null) {
                throw new RuntimeException("Variable " + variable + " not defined");
            }
            if (value.size() > 1) {
                throw new IllegalStateException("");
            }
            if (value.size() == 1) {
                if (value.getType() == PrimitiveType.ObjectReference) {
                    RMObjectWithPath reference = (RMObjectWithPath)value.get(0).getValue();
                    pathPrefix = reference.getPath();
                } else {
                    if (value.get(0).getPaths().size() > 1) {
                        throw new IllegalStateException("");
                    }
                    pathPrefix = value.get(0).getPaths().get(0);
                }
            }
        }
        String path = pathPrefix + statement.getPath();
        try {
            rmObjectsWithPath = evaluation.getQueryContext().findListWithPaths(path);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException("error evaluating " + path, e);
        }
        List<Value> values = rmObjectsWithPath.stream().map(rmObjectWithPath -> new Value<Object>(rmObjectWithPath.getObject(), Lists.newArrayList((Object[])new String[]{rmObjectWithPath.getPath()}))).collect(Collectors.toList());
        return new ValueList(values);
    }

    @Override
    public List<Class> getSupportedClasses() {
        return Lists.newArrayList((Object[])new Class[]{ModelReference.class});
    }
}

