/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.query;

import com.google.common.collect.Lists;
import com.nedap.archie.paths.PathSegment;
import com.nedap.archie.query.APathQuery;
import com.nedap.archie.query.RMObjectWithPath;
import com.nedap.archie.rminfo.ModelInfoLookup;
import com.nedap.archie.rminfo.RMAttributeInfo;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class RMPathQuery {
    private List<PathSegment> pathSegments = new ArrayList<PathSegment>();

    public RMPathQuery(String query) {
        this.pathSegments = new APathQuery(query).getPathSegments();
    }

    public <T> T find(ModelInfoLookup lookup, Object root) {
        Object currentObject = root;
        try {
            for (PathSegment segment : this.pathSegments) {
                int number;
                if (currentObject == null) {
                    return null;
                }
                RMAttributeInfo attributeInfo = lookup.getAttributeInfo(currentObject.getClass(), segment.getNodeName());
                if (attributeInfo == null) {
                    return null;
                }
                Method method = attributeInfo.getGetMethod();
                currentObject = method.invoke(currentObject, new Object[0]);
                if (currentObject == null) {
                    return null;
                }
                String archetypeNodeIdFromObject = lookup.getArchetypeNodeIdFromRMObject(currentObject);
                if (currentObject instanceof Collection) {
                    Collection collection = (Collection)currentObject;
                    if (!segment.hasExpressions()) {
                        currentObject = collection;
                        continue;
                    }
                    currentObject = this.findRMObject(lookup, segment, collection);
                    continue;
                }
                if (archetypeNodeIdFromObject != null) {
                    if (!segment.hasExpressions()) continue;
                    if (segment.hasIdCode()) {
                        if (archetypeNodeIdFromObject.equals(segment.getNodeId())) continue;
                        return null;
                    }
                    if (segment.hasNumberIndex()) {
                        int number2 = segment.getIndex();
                        if (number2 == 1) continue;
                        return null;
                    }
                    if (!segment.hasArchetypeRef() || archetypeNodeIdFromObject.equals(segment.getNodeId())) continue;
                    throw new IllegalArgumentException("cannot handle RM-queries with node names or archetype references yet");
                }
                if (!segment.hasNumberIndex() || (number = segment.getIndex().intValue()) == 1) continue;
                return null;
            }
            return (T)currentObject;
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> List<RMObjectWithPath> findList(ModelInfoLookup lookup, Object root) {
        ArrayList<RMObjectWithPath> currentObjects = Lists.newArrayList((Object[])new RMObjectWithPath[]{new RMObjectWithPath(root, "/")});
        try {
            for (PathSegment segment : this.pathSegments) {
                if (currentObjects.isEmpty()) {
                    return Collections.emptyList();
                }
                ArrayList<RMObjectWithPath> newCurrentObjects = new ArrayList<RMObjectWithPath>();
                for (int i = 0; i < currentObjects.size(); ++i) {
                    RMObjectWithPath currentObject = (RMObjectWithPath)currentObjects.get(i);
                    Object currentRMObject = currentObject.getObject();
                    RMAttributeInfo attributeInfo = lookup.getAttributeInfo(currentRMObject.getClass(), segment.getNodeName());
                    if (attributeInfo == null) continue;
                    Method method = attributeInfo.getGetMethod();
                    currentRMObject = method.invoke(currentRMObject, new Object[0]);
                    String pathSeparator = "/";
                    if (currentObject.getPath().endsWith("/")) {
                        pathSeparator = "";
                    }
                    String newPath = currentObject.getPath() + pathSeparator + segment.getNodeName();
                    if (currentRMObject == null) continue;
                    String archetypeNodeIdFromObject = lookup.getArchetypeNodeIdFromRMObject((Object)currentObject);
                    if (currentRMObject instanceof Collection) {
                        Collection collection = (Collection)currentRMObject;
                        if (!segment.hasExpressions()) {
                            this.addAllFromCollection(lookup, newCurrentObjects, collection, newPath);
                            continue;
                        }
                        newCurrentObjects.addAll(this.findRMObjectsWithPathCollection(lookup, segment, collection, newPath));
                        continue;
                    }
                    if (archetypeNodeIdFromObject != null) {
                        int number;
                        if (!segment.hasExpressions() || (segment.hasIdCode() ? !archetypeNodeIdFromObject.equals(segment.getNodeId()) : (segment.hasNumberIndex() ? (number = segment.getIndex().intValue()) != 1 : segment.hasArchetypeRef() && !archetypeNodeIdFromObject.equals(segment.getNodeId())))) continue;
                        newCurrentObjects.add(this.createRMObjectWithPath(lookup, currentRMObject, newPath));
                        continue;
                    }
                    if (segment.hasNumberIndex()) {
                        int number = segment.getIndex();
                        if (number == 1) continue;
                    }
                    newCurrentObjects.add(this.createRMObjectWithPath(lookup, currentRMObject, newPath));
                }
                currentObjects = newCurrentObjects;
            }
            return currentObjects;
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private RMObjectWithPath createRMObjectWithPath(ModelInfoLookup lookup, Object currentObject, String newPath) {
        String archetypeNodeId = lookup.getArchetypeNodeIdFromRMObject(currentObject);
        String pathConstraint = this.buildPathConstraint(null, archetypeNodeId);
        return new RMObjectWithPath(currentObject, newPath + pathConstraint);
    }

    private void addAllFromCollection(ModelInfoLookup lookup, List<RMObjectWithPath> newCurrentObjects, Collection toAdd, String basePath) {
        int index = 1;
        for (Object object : toAdd) {
            String constraint = this.buildPathConstraint(index, lookup.getArchetypeNodeIdFromRMObject(object));
            newCurrentObjects.add(new RMObjectWithPath(object, basePath + constraint));
            ++index;
        }
    }

    private String buildPathConstraint(Integer index, String archetypeNodeId) {
        if (index == null && !this.archetypeNodeIdPresent(archetypeNodeId)) {
            return "";
        }
        if (this.archetypeNodeIdPresent(archetypeNodeId) && index == null) {
            return "[" + archetypeNodeId + "]";
        }
        StringBuilder constraint = new StringBuilder("[");
        boolean first = true;
        if (this.archetypeNodeIdPresent(archetypeNodeId)) {
            constraint.append(archetypeNodeId);
            first = false;
        }
        if (index != null) {
            if (!first) {
                constraint.append(", ");
            }
            constraint.append(Integer.toString(index));
        }
        constraint.append("]");
        return constraint.toString();
    }

    private boolean archetypeNodeIdPresent(String archetypeNodeId) {
        return archetypeNodeId != null && !archetypeNodeId.equals("id9999");
    }

    private Collection<RMObjectWithPath> findRMObjectsWithPathCollection(ModelInfoLookup lookup, PathSegment segment, Collection<Object> collection, String path) {
        int i;
        if (segment.hasNumberIndex()) {
            int number = segment.getIndex();
            i = 1;
            for (Object object : collection) {
                if (number == i) {
                    return Lists.newArrayList((Object[])new RMObjectWithPath[]{new RMObjectWithPath(object, path + this.buildPathConstraint(i - 1, lookup.getArchetypeNodeIdFromRMObject(object)))});
                }
                ++i;
            }
        }
        ArrayList<RMObjectWithPath> result = new ArrayList<RMObjectWithPath>();
        i = 1;
        for (Object object : collection) {
            String archetypeNodeId = lookup.getArchetypeNodeIdFromRMObject(object);
            if (segment.hasIdCode()) {
                if (archetypeNodeId.equals(segment.getNodeId())) {
                    result.add(new RMObjectWithPath(object, path + this.buildPathConstraint(i, archetypeNodeId)));
                }
            } else if (segment.hasArchetypeRef()) {
                if (archetypeNodeId.equals(segment.getNodeId())) {
                    result.add(new RMObjectWithPath(object, path + this.buildPathConstraint(i, archetypeNodeId)));
                }
            } else if (this.equalsName(lookup.getNameFromRMObject(object), segment.getNodeId())) {
                result.add(new RMObjectWithPath(object, path + this.buildPathConstraint(i, archetypeNodeId)));
            }
            ++i;
        }
        return result;
    }

    private Object findRMObject(ModelInfoLookup lookup, PathSegment segment, Collection collection) {
        if (segment.hasNumberIndex()) {
            int number = segment.getIndex();
            for (Object object : collection) {
                if (number == 1) {
                    return object;
                }
                --number;
            }
            return null;
        }
        for (Object o : collection) {
            String archetypeNodeId = lookup.getArchetypeNodeIdFromRMObject(o);
            if (!(segment.hasIdCode() ? archetypeNodeId.equals(segment.getNodeId()) : (segment.hasArchetypeRef() ? archetypeNodeId.equals(segment.getNodeId()) : this.equalsName(lookup.getNameFromRMObject(o), segment.getNodeId())))) continue;
            return o;
        }
        return null;
    }

    private boolean equalsName(String name, String nameFromQuery) {
        if (name == null) {
            return false;
        }
        name = name.replaceAll("( |\\t|\\n|\\r)+", "");
        nameFromQuery = nameFromQuery.replaceAll("( |\\t|\\n|\\r)+", "");
        return name.equalsIgnoreCase(nameFromQuery);
    }

    public List<PathSegment> getPathSegments() {
        return this.pathSegments;
    }
}

