/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rmutil;

import com.nedap.archie.paths.PathSegment;
import com.nedap.archie.paths.PathUtil;
import com.nedap.archie.query.RMObjectAttributes;
import com.nedap.archie.rm.archetyped.Pathable;
import com.nedap.archie.rminfo.ArchieRMInfoLookup;
import com.nedap.archie.rminfo.ModelInfoLookup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PathableUtil {
    public static List<PathSegment> getUniquePathSegments(Pathable pathable) {
        Pathable parent = pathable.getParent();
        if (parent == null) {
            return new ArrayList<PathSegment>();
        }
        List<PathSegment> segments = PathableUtil.getUniquePathSegments(parent);
        segments.add(PathableUtil.getUniquePathSegment(pathable));
        return segments;
    }

    private static PathSegment getUniquePathSegment(Pathable pathable) {
        Collection collection;
        List<PathSegment> unindexedPathSegments = pathable.getPathSegments();
        PathSegment unindexedPathSegment = unindexedPathSegments.get(unindexedPathSegments.size() - 1);
        Pathable parent = pathable.getParent();
        String parentAttributeName = unindexedPathSegment.getNodeName();
        ArchieRMInfoLookup modelInfoLookup = ArchieRMInfoLookup.getInstance();
        Object attributeValue = RMObjectAttributes.getAttributeValueFromRMObject((Object)parent, (String)parentAttributeName, (ModelInfoLookup)modelInfoLookup);
        Integer index = null;
        if (attributeValue instanceof Collection && (collection = (Collection)attributeValue).size() > 1) {
            int i = 1;
            for (Object elem : collection) {
                if (elem == pathable) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (index == null) {
                throw new RuntimeException("Cannot find object in parent object");
            }
        }
        return new PathSegment(unindexedPathSegment.getNodeName(), unindexedPathSegment.getNodeId(), index);
    }

    public static String getUniquePath(Pathable pathable) {
        return PathUtil.getPath(PathableUtil.getUniquePathSegments(pathable));
    }
}

